/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class CollectionMatchers {

    public static class ImmutableOpenMapHasKeyMatcher
    extends TypeSafeMatcher<ImmutableOpenMap> {
        private final String key;

        public ImmutableOpenMapHasKeyMatcher(String key) {
            this.key = key;
        }

        protected boolean matchesSafely(ImmutableOpenMap item) {
            return item.containsKey((Object)this.key);
        }

        public void describeMismatchSafely(ImmutableOpenMap map, Description mismatchDescription) {
            if (map.size() == 0) {
                mismatchDescription.appendText("was empty");
            } else {
                mismatchDescription.appendText(" was ").appendValue((Object)map);
            }
        }

        public void describeTo(Description description) {
            description.appendText("ImmutableOpenMap should contain key " + this.key);
        }
    }
}

