/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.Stash;

public class ClientYamlTestExecutionContext {
    private static final Logger logger = Loggers.getLogger(ClientYamlTestExecutionContext.class);
    private final Stash stash = new Stash();
    private final ClientYamlTestClient clientYamlTestClient;
    private ClientYamlTestResponse response;

    public ClientYamlTestExecutionContext(ClientYamlTestClient clientYamlTestClient) {
        this.clientYamlTestClient = clientYamlTestClient;
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, List<Map<String, Object>> bodies, Map<String, String> headers) throws IOException {
        Object responseBody;
        Map.Entry<String, String> entry2;
        HashMap<String, String> requestParams = new HashMap<String, String>(params);
        if (!(this.esVersion().before(Version.V_5_2_0_UNRELEASED) && apiName.endsWith("put_settings"))) {
            requestParams.putIfAbsent("error_trace", "true");
        }
        for (Map.Entry<String, String> entry2 : requestParams.entrySet()) {
            if (!this.stash.containsStashedValue(entry2.getValue())) continue;
            entry2.setValue(this.stash.getValue(entry2.getValue()).toString());
        }
        String body = this.actualBody(bodies);
        try {
            this.response = this.callApiInternal(apiName, requestParams, body, headers);
            entry2 = this.response;
            responseBody = this.response != null ? this.response.getBody() : null;
        }
        catch (ClientYamlTestResponseException e) {
            try {
                this.response = e.getRestTestResponse();
                throw e;
            }
            catch (Throwable throwable) {
                Object responseBody2 = this.response != null ? this.response.getBody() : null;
                this.stash.stashValue("body", responseBody2);
                throw throwable;
            }
        }
        this.stash.stashValue("body", responseBody);
        return entry2;
    }

    private String actualBody(List<Map<String, Object>> bodies) throws IOException {
        if (bodies.isEmpty()) {
            return "";
        }
        if (bodies.size() == 1) {
            return this.bodyAsString(this.stash.replaceStashedValues(bodies.get(0)));
        }
        StringBuilder bodyBuilder = new StringBuilder();
        for (Map<String, Object> body : bodies) {
            bodyBuilder.append(this.bodyAsString(this.stash.replaceStashedValues(body))).append("\n");
        }
        return bodyBuilder.toString();
    }

    private String bodyAsString(Map<String, Object> body) throws IOException {
        return XContentFactory.jsonBuilder().map(body).string();
    }

    private ClientYamlTestResponse callApiInternal(String apiName, Map<String, String> params, String body, Map<String, String> headers) throws IOException {
        return this.clientYamlTestClient.callApi(apiName, params, body, headers);
    }

    public Object response(String path) throws IOException {
        return this.response.evaluate(path, this.stash);
    }

    public void clear() {
        logger.debug("resetting client, response and stash");
        this.response = null;
        this.stash.clear();
    }

    public Stash stash() {
        return this.stash;
    }

    public Version esVersion() {
        return this.clientYamlTestClient.getEsVersion();
    }
}

