/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Version;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.test.rest.yaml.BlacklistedPathPatternMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestCandidate;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.FileUtils;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSection;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSuite;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class ESClientYamlSuiteTestCase
extends ESRestTestCase {
    public static final String REST_TESTS_SUITE = "tests.rest.suite";
    public static final String REST_TESTS_BLACKLIST = "tests.rest.blacklist";
    private static final String REST_TESTS_VALIDATE_SPEC = "tests.rest.validate_spec";
    public static final String REST_TESTS_SPEC = "tests.rest.spec";
    private static final String REST_LOAD_PACKAGED_TESTS = "tests.rest.load_packaged";
    private static final String DEFAULT_TESTS_PATH = "/rest-api-spec/test";
    private static final String DEFAULT_SPEC_PATH = "/rest-api-spec/api";
    private static final String PATHS_SEPARATOR = "(?<!\\\\),";
    private static List<BlacklistedPathPatternMatcher> blacklistPathMatchers;
    private static ClientYamlTestExecutionContext restTestExecutionContext;
    private static ClientYamlTestExecutionContext adminExecutionContext;
    private final ClientYamlTestCandidate testCandidate;

    protected ESClientYamlSuiteTestCase(ClientYamlTestCandidate testCandidate) {
        this.testCandidate = testCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initAndResetContext() throws IOException {
        block12: {
            Version esVersion;
            if (restTestExecutionContext != null) break block12;
            assert (adminExecutionContext == null);
            assert (blacklistPathMatchers == null);
            String[] specPaths = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SPEC, DEFAULT_SPEC_PATH);
            ClientYamlSuiteRestSpec restSpec = null;
            FileSystem fileSystem = ESClientYamlSuiteTestCase.getFileSystem();
            try {
                restSpec = ClientYamlSuiteRestSpec.parseFrom(fileSystem, DEFAULT_SPEC_PATH, specPaths);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{fileSystem});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{fileSystem});
            ESClientYamlSuiteTestCase.validateSpec(restSpec);
            List<HttpHost> hosts = this.getClusterHosts();
            RestClient restClient = ESClientYamlSuiteTestCase.client();
            Tuple<Version, Map<HttpHost, Version>> versionMapTuple = ESClientYamlSuiteTestCase.readVersionsFromInfo(restClient, hosts.size());
            try {
                Tuple<Version, Version> versionVersionTuple = ESClientYamlSuiteTestCase.readVersionsFromCatNodes(restClient);
                esVersion = (Version)versionVersionTuple.v1();
                Version masterVersion = (Version)versionVersionTuple.v2();
                this.logger.info("initializing yaml client, minimum es version: [{}] master version: [{}] hosts: {}", (Object)esVersion, (Object)masterVersion, hosts);
            }
            catch (ResponseException ex) {
                if (ex.getResponse().getStatusLine().getStatusCode() == 403) {
                    this.logger.warn("Fallback to simple info '/' request, _cat/nodes is not authorized");
                    esVersion = (Version)versionMapTuple.v1();
                    this.logger.info("initializing yaml client, minimum es version: [{}] hosts: {}", (Object)esVersion, hosts);
                }
                throw ex;
            }
            ClientYamlTestClient clientYamlTestClient = new ClientYamlTestClient(restSpec, restClient, hosts, esVersion, (Map)versionMapTuple.v2());
            restTestExecutionContext = new ClientYamlTestExecutionContext(clientYamlTestClient);
            adminExecutionContext = new ClientYamlTestExecutionContext(clientYamlTestClient);
            String[] blacklist = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST, null);
            blacklistPathMatchers = new ArrayList<BlacklistedPathPatternMatcher>();
            for (String entry : blacklist) {
                blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
            }
        }
        assert (restTestExecutionContext != null);
        assert (adminExecutionContext != null);
        assert (blacklistPathMatchers != null);
        adminExecutionContext.clear();
        for (BlacklistedPathPatternMatcher blacklistedPathMatcher : blacklistPathMatchers) {
            String testPath = this.testCandidate.getSuitePath() + "/" + this.testCandidate.getTestSection().getName();
            ESClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: blacklisted"), (boolean)blacklistedPathMatcher.isSuffixMatch(testPath));
        }
        restTestExecutionContext.clear();
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getSetupSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getSetupSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTeardownSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getTeardownSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTestSection().getSkipSection().getSkipMessage(this.testCandidate.getTestPath()), (boolean)this.testCandidate.getTestSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
    }

    @Override
    protected void afterIfFailed(List<Throwable> errors) {
        this.logger.info("Stash dump on failure [{}]", (Object)XContentHelper.toString((ToXContent)restTestExecutionContext.stash()).replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t"));
        super.afterIfFailed(errors);
    }

    public static Iterable<Object[]> createParameters() throws IOException {
        List<ClientYamlTestCandidate> restTestCandidates = ESClientYamlSuiteTestCase.collectTestCandidates();
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        for (ClientYamlTestCandidate restTestCandidate : restTestCandidates) {
            objects.add(new Object[]{restTestCandidate});
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ClientYamlTestCandidate> collectTestCandidates() throws IOException {
        ArrayList<ClientYamlTestCandidate> testCandidates = new ArrayList<ClientYamlTestCandidate>();
        FileSystem fileSystem = ESClientYamlSuiteTestCase.getFileSystem();
        try {
            String[] paths = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SUITE, DEFAULT_TESTS_PATH);
            Map<String, Set<Path>> yamlSuites = FileUtils.findYamlSuites(fileSystem, DEFAULT_TESTS_PATH, paths);
            for (String api : yamlSuites.keySet()) {
                ArrayList yamlFiles = new ArrayList(yamlSuites.get(api));
                for (Path yamlFile : yamlFiles) {
                    ClientYamlTestSuite restTestSuite = ClientYamlTestSuite.parse(api, yamlFile);
                    for (ClientYamlTestSection testSection : restTestSuite.getTestSections()) {
                        testCandidates.add(new ClientYamlTestCandidate(restTestSuite, testSection));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{fileSystem});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{fileSystem});
        Collections.sort(testCandidates, (o1, o2) -> o1.getTestPath().compareTo(o2.getTestPath()));
        return testCandidates;
    }

    private static String[] resolvePathsProperty(String propertyName, String defaultValue) {
        String property = System.getProperty(propertyName);
        if (!Strings.hasLength((String)property)) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = Strings.EMPTY_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            return stringArray;
        }
        return property.split(PATHS_SEPARATOR);
    }

    @SuppressForbidden(reason="proper use of URL, hack around a JDK bug")
    protected static FileSystem getFileSystem() throws IOException {
        URL codeLocation = FileUtils.class.getProtectionDomain().getCodeSource().getLocation();
        boolean loadPackaged = RandomizedTest.systemPropertyAsBoolean((String)REST_LOAD_PACKAGED_TESTS, (boolean)true);
        if (codeLocation.getFile().endsWith(".jar") && loadPackaged) {
            try {
                Path tmp = Files.createTempFile(null, ".jar", new FileAttribute[0]);
                try (InputStream in = codeLocation.openStream();){
                    Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
                }
                return FileSystems.newFileSystem(new URI("jar:" + tmp.toUri()), Collections.emptyMap());
            }
            catch (URISyntaxException e) {
                throw new IOException("couldn't open zipfilesystem: ", e);
            }
        }
        return null;
    }

    protected ClientYamlTestExecutionContext getAdminExecutionContext() {
        return adminExecutionContext;
    }

    private static void validateSpec(ClientYamlSuiteRestSpec restSpec) {
        boolean validateSpec = RandomizedTest.systemPropertyAsBoolean((String)REST_TESTS_VALIDATE_SPEC, (boolean)true);
        if (validateSpec) {
            StringBuilder errorMessage = new StringBuilder();
            for (ClientYamlSuiteRestApi restApi : restSpec.getApis()) {
                if (!restApi.getMethods().contains("GET") || !restApi.isBodySupported() || restApi.getMethods().contains("POST")) continue;
                errorMessage.append("\n- ").append(restApi.getName()).append(" supports GET with a body but doesn't support POST");
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }
    }

    @AfterClass
    public static void clearStatic() {
        blacklistPathMatchers = null;
        restTestExecutionContext = null;
        adminExecutionContext = null;
    }

    private static Tuple<Version, Version> readVersionsFromCatNodes(RestClient restClient) throws IOException {
        Response response = restClient.performRequest("GET", "/_cat/nodes", Collections.singletonMap("h", "version,master"), new Header[0]);
        ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response, Version.CURRENT);
        String nodesCatResponse = restTestResponse.getBodyAsString();
        String[] split = nodesCatResponse.split("\n");
        Version version = null;
        Version masterVersion = null;
        for (String perNode : split) {
            String[] versionAndMaster = perNode.split("\\s+");
            assert (versionAndMaster.length == 2) : "invalid line: " + perNode + " length: " + versionAndMaster.length;
            Version currentVersion = Version.fromString((String)versionAndMaster[0]);
            boolean master = versionAndMaster[1].trim().equals("*");
            if (master) {
                assert (masterVersion == null);
                masterVersion = currentVersion;
            }
            if (version == null) {
                version = currentVersion;
                continue;
            }
            if (!version.onOrAfter(currentVersion)) continue;
            version = currentVersion;
        }
        return new Tuple(version, masterVersion);
    }

    private static Tuple<Version, Map<HttpHost, Version>> readVersionsFromInfo(RestClient restClient, int numHosts) throws IOException {
        Version version = null;
        HashMap<HttpHost, Version> hostVersionMap = new HashMap<HttpHost, Version>();
        for (int i = 0; i < numHosts; ++i) {
            Response response = restClient.performRequest("GET", "/", new Header[0]);
            ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response, Version.CURRENT);
            Object latestVersion = restTestResponse.evaluate("version.number");
            if (latestVersion == null) {
                throw new RuntimeException("elasticsearch version not found in the response");
            }
            Version currentVersion = Version.fromString((String)latestVersion.toString());
            if (version == null) {
                version = currentVersion;
            } else if (version.onOrAfter(currentVersion)) {
                version = currentVersion;
            }
            hostVersionMap.put(response.getHost(), currentVersion);
        }
        return new Tuple(version, Collections.unmodifiableMap(hostVersionMap));
    }

    public void test() throws IOException {
        if (this.testCandidate.getTestSection().getExecutableSections().size() == 0) {
            throw new IllegalArgumentException("No executable sections loaded for [" + this.testCandidate.getTestPath() + "]");
        }
        if (!this.testCandidate.getSetupSection().isEmpty()) {
            this.logger.debug("start setup test [{}]", (Object)this.testCandidate.getTestPath());
            for (DoSection doSection : this.testCandidate.getSetupSection().getDoSections()) {
                this.executeSection(doSection);
            }
            this.logger.debug("end setup test [{}]", (Object)this.testCandidate.getTestPath());
        }
        restTestExecutionContext.clear();
        try {
            for (ExecutableSection executableSection : this.testCandidate.getTestSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
        }
        catch (Throwable throwable) {
            this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
            for (DoSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
                this.executeSection(doSection);
            }
            this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
            throw throwable;
        }
        this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
        for (DoSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
            this.executeSection(doSection);
        }
        this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
    }

    private void executeSection(ExecutableSection executableSection) {
        try {
            executableSection.execute(restTestExecutionContext);
        }
        catch (Exception e) {
            throw new RuntimeException(this.errorMessage(executableSection, e), e);
        }
        catch (AssertionError e) {
            throw new AssertionError(this.errorMessage(executableSection, (Throwable)((Object)e)), (Throwable)((Object)e));
        }
    }

    private String errorMessage(ExecutableSection executableSection, Throwable t) {
        return "Failure at [" + this.testCandidate.getSuitePath() + ":" + executableSection.getLocation().lineNumber + "]: " + t.getMessage();
    }
}

