/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.tasks.MockTaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.MockTcpTransport;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.local.LocalTransport;

public final class MockTransportService
extends TransportService {
    private final Map<DiscoveryNode, List<Transport.Connection>> openConnections = new HashMap<DiscoveryNode, List<Transport.Connection>>();
    private final Transport original;
    List<Tracer> activeTracers = new CopyOnWriteArrayList<Tracer>();

    public static MockTransportService local(Settings settings, final Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings) {
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
        LocalTransport transport = new LocalTransport(settings, threadPool, namedWriteableRegistry, (CircuitBreakerService)new NoneCircuitBreakerService()){

            protected Version getVersion() {
                return version;
            }
        };
        return new MockTransportService(settings, (Transport)transport, threadPool, TransportService.NOOP_TRANSPORT_INTERCEPTOR, clusterSettings);
    }

    public static MockTransportService mockTcp(Settings settings, Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings) {
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
        MockTcpTransport transport = new MockTcpTransport(settings, threadPool, BigArrays.NON_RECYCLING_INSTANCE, (CircuitBreakerService)new NoneCircuitBreakerService(), namedWriteableRegistry, new NetworkService(settings, Collections.emptyList()), version);
        if (version.equals((Object)Version.CURRENT)) {
            return new MockTransportService(settings, (Transport)transport, threadPool, TransportService.NOOP_TRANSPORT_INTERCEPTOR, clusterSettings);
        }
        return new MockTransportService(settings, (Transport)transport, threadPool, TransportService.NOOP_TRANSPORT_INTERCEPTOR, boundAddress -> MockTransportService.createLocal(settings, boundAddress.publishAddress(), settings.get(Node.NODE_NAME_SETTING.getKey(), UUIDs.randomBase64UUID()), version), clusterSettings);
    }

    private static DiscoveryNode createLocal(Settings settings, TransportAddress publishAddress, String nodeId, Version version) {
        HashMap attributes = new HashMap(((Settings)Node.NODE_ATTRIBUTES.get(settings)).getAsMap());
        HashSet<DiscoveryNode.Role> roles = new HashSet<DiscoveryNode.Role>();
        if (((Boolean)Node.NODE_INGEST_SETTING.get(settings)).booleanValue()) {
            roles.add(DiscoveryNode.Role.INGEST);
        }
        if (((Boolean)Node.NODE_MASTER_SETTING.get(settings)).booleanValue()) {
            roles.add(DiscoveryNode.Role.MASTER);
        }
        if (((Boolean)Node.NODE_DATA_SETTING.get(settings)).booleanValue()) {
            roles.add(DiscoveryNode.Role.DATA);
        }
        return new DiscoveryNode((String)Node.NODE_NAME_SETTING.get(settings), nodeId, publishAddress, attributes, roles, version);
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, @Nullable ClusterSettings clusterSettings) {
        this(settings, transport, threadPool, interceptor, boundAddress -> DiscoveryNode.createLocal((Settings)settings, (TransportAddress)boundAddress.publishAddress(), (String)settings.get(Node.NODE_NAME_SETTING.getKey(), UUIDs.randomBase64UUID())), clusterSettings);
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings) {
        super(settings, (Transport)new LookupTestTransport(transport), threadPool, interceptor, localNodeFactory, clusterSettings);
        this.original = transport;
    }

    public static TransportAddress[] extractTransportAddresses(TransportService transportService) {
        HashSet<TransportAddress> transportAddresses = new HashSet<TransportAddress>();
        BoundTransportAddress boundTransportAddress = transportService.boundAddress();
        transportAddresses.addAll(Arrays.asList(boundTransportAddress.boundAddresses()));
        transportAddresses.add(boundTransportAddress.publishAddress());
        return transportAddresses.toArray(new TransportAddress[transportAddresses.size()]);
    }

    protected TaskManager createTaskManager() {
        if (((Boolean)MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING.get(this.settings)).booleanValue()) {
            return new MockTaskManager(this.settings);
        }
        return super.createTaskManager();
    }

    public void clearAllRules() {
        this.transport().transports.clear();
    }

    public void clearRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.clearRule(transportAddress);
        }
    }

    public void clearRule(TransportAddress transportAddress) {
        Transport transport = (Transport)this.transport().transports.remove(transportAddress);
        if (transport instanceof ClearableTransport) {
            ((ClearableTransport)transport).clearRule();
        }
    }

    public Transport original() {
        return this.original;
    }

    public void addFailToSendNoConnectRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress) {
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            @Override
            public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
                throw new ConnectTransportException(node, "DISCONNECT: simulated");
            }

            @Override
            protected void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException {
                throw new ConnectTransportException(connection.getNode(), "DISCONNECT: simulated");
            }
        });
    }

    public void addFailToSendNoConnectRule(TransportService transportService, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportService, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportAddress, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportService transportService, Set<String> blockedActions) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress, blockedActions);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, final Set<String> blockedActions) {
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            @Override
            public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
                MockTransportService.this.original.connectToNode(node, connectionProfile);
            }

            @Override
            protected void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException {
                if (blockedActions.contains(action)) {
                    MockTransportService.this.logger.info("--> preventing {} request", (Object)action);
                    throw new ConnectTransportException(connection.getNode(), "DISCONNECT: prevented " + action + " request");
                }
                connection.sendRequest(requestId, action, request, options);
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress) {
        this.addDelegate(transportAddress, new DelegateTransport(this.original){

            @Override
            public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
                throw new ConnectTransportException(node, "UNRESPONSIVE: simulated");
            }

            @Override
            protected void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException {
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService, TimeValue duration) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress, duration);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress, final TimeValue duration) {
        final long startTime = System.currentTimeMillis();
        this.addDelegate(transportAddress, (DelegateTransport)new ClearableTransport(this.original){
            private final Queue<Runnable> requestsToSendWhenCleared;
            private boolean cleared;
            {
                super(transport);
                this.requestsToSendWhenCleared = new LinkedBlockingDeque<Runnable>();
                this.cleared = false;
            }

            TimeValue getDelay() {
                return new TimeValue(duration.millis() - (System.currentTimeMillis() - startTime));
            }

            @Override
            public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
                TimeValue delay = this.getDelay();
                if (delay.millis() <= 0L) {
                    MockTransportService.this.original.connectToNode(node, connectionProfile);
                    return;
                }
                TimeValue connectingTimeout = (TimeValue)NetworkService.TcpSettings.TCP_CONNECT_TIMEOUT.getDefault(Settings.EMPTY);
                try {
                    if (delay.millis() >= connectingTimeout.millis()) {
                        Thread.sleep(connectingTimeout.millis());
                        throw new ConnectTransportException(node, "UNRESPONSIVE: simulated");
                    }
                    Thread.sleep(delay.millis());
                    MockTransportService.this.original.connectToNode(node, connectionProfile);
                }
                catch (InterruptedException e) {
                    throw new ConnectTransportException(node, "UNRESPONSIVE: interrupted while sleeping", (Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void sendRequest(final Transport.Connection connection, final long requestId, final String action, TransportRequest request, final TransportRequestOptions options) throws IOException {
                TimeValue delay = this.getDelay();
                if (delay.millis() <= 0L) {
                    connection.sendRequest(requestId, action, request, options);
                    return;
                }
                RequestHandlerRegistry reg = MockTransportService.this.getRequestHandler(action);
                BytesStreamOutput bStream = new BytesStreamOutput();
                request.writeTo((StreamOutput)bStream);
                final TransportRequest clonedRequest = reg.newRequest();
                clonedRequest.readFrom(bStream.bytes().streamInput());
                AbstractRunnable runnable = new AbstractRunnable(){
                    AtomicBoolean requestSent = new AtomicBoolean();

                    public void onFailure(Exception e) {
                        MockTransportService.this.logger.debug("failed to send delayed request", (Throwable)e);
                    }

                    protected void doRun() throws IOException {
                        if (this.requestSent.compareAndSet(false, true)) {
                            connection.sendRequest(requestId, action, clonedRequest, options);
                        }
                    }
                };
                5 var12_11 = this;
                synchronized (var12_11) {
                    if (this.cleared) {
                        runnable.run();
                    } else {
                        this.requestsToSendWhenCleared.add((Runnable)runnable);
                        MockTransportService.this.threadPool.schedule(delay, "generic", (Runnable)runnable);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearRule() {
                5 var1_1 = this;
                synchronized (var1_1) {
                    assert (!this.cleared);
                    this.cleared = true;
                    this.requestsToSendWhenCleared.forEach(Runnable::run);
                }
            }
        });
    }

    public boolean addDelegate(TransportService transportService, DelegateTransport transport) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addDelegate(transportAddress, transport);
        }
        return noRegistered;
    }

    public boolean addDelegate(TransportAddress transportAddress, DelegateTransport transport) {
        return this.transport().transports.put(transportAddress, transport) == null;
    }

    private LookupTestTransport transport() {
        return (LookupTestTransport)this.transport;
    }

    public void addTracer(Tracer tracer) {
        this.activeTracers.add(tracer);
    }

    public boolean removeTracer(Tracer tracer) {
        return this.activeTracers.remove(tracer);
    }

    public void clearTracers() {
        this.activeTracers.clear();
    }

    protected TransportService.Adapter createAdapter() {
        return new MockAdapter();
    }

    public Transport getOriginalTransport() {
        LookupTestTransport transport = this.transport();
        while (transport instanceof DelegateTransport) {
            transport = ((DelegateTransport)transport).transport;
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport.Connection openConnection(final DiscoveryNode node, ConnectionProfile profile) throws IOException {
        FilteredConnection filteredConnection = new FilteredConnection(super.openConnection(node, profile)){
            final AtomicBoolean closed;
            {
                super(connection);
                this.closed = new AtomicBoolean(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (this.closed.compareAndSet(false, true)) {
                        Map map = MockTransportService.this.openConnections;
                        synchronized (map) {
                            List connections = (List)MockTransportService.this.openConnections.get(node);
                            boolean remove = connections.remove(this);
                            assert (remove);
                            if (connections.isEmpty()) {
                                MockTransportService.this.openConnections.remove(node);
                            }
                        }
                    }
                }
            }
        };
        Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
        synchronized (map) {
            List connections = this.openConnections.computeIfAbsent(node, n -> new CopyOnWriteArrayList());
            connections.add(filteredConnection);
        }
        return filteredConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        super.doClose();
        Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
        synchronized (map) {
            assert (this.openConnections.size() == 0) : "still open connections: " + this.openConnections;
        }
    }

    public DiscoveryNode getLocalDiscoNode() {
        return this.getLocalNode();
    }

    private static class FilteredConnection
    implements Transport.Connection {
        protected final Transport.Connection connection;

        private FilteredConnection(Transport.Connection connection) {
            this.connection = connection;
        }

        public DiscoveryNode getNode() {
            return this.connection.getNode();
        }

        public Version getVersion() {
            return this.connection.getVersion();
        }

        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            this.connection.sendRequest(requestId, action, request, options);
        }

        public void close() throws IOException {
            this.connection.close();
        }
    }

    class MockAdapter
    extends TransportService.Adapter {
        MockAdapter() {
            super((TransportService)MockTransportService.this);
        }

        protected boolean traceEnabled() {
            return super.traceEnabled() || !MockTransportService.this.activeTracers.isEmpty();
        }

        protected void traceReceivedRequest(long requestId, String action) {
            super.traceReceivedRequest(requestId, action);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.receivedRequest(requestId, action);
            }
        }

        protected void traceResponseSent(long requestId, String action) {
            super.traceResponseSent(requestId, action);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.responseSent(requestId, action);
            }
        }

        protected void traceResponseSent(long requestId, String action, Exception e) {
            super.traceResponseSent(requestId, action, e);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.responseSent(requestId, action, e);
            }
        }

        protected void traceReceivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            super.traceReceivedResponse(requestId, sourceNode, action);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.receivedResponse(requestId, sourceNode, action);
            }
        }

        protected void traceRequestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            super.traceRequestSent(node, requestId, action, options);
            for (Tracer tracer : MockTransportService.this.activeTracers) {
                tracer.requestSent(node, requestId, action, options);
            }
        }
    }

    public static class Tracer {
        public void receivedRequest(long requestId, String action) {
        }

        public void responseSent(long requestId, String action) {
        }

        public void responseSent(long requestId, String action, Throwable t) {
        }

        public void receivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
        }

        public void requestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
        }
    }

    public static abstract class ClearableTransport
    extends DelegateTransport {
        public ClearableTransport(Transport transport) {
            super(transport);
        }

        public abstract void clearRule();
    }

    public static class DelegateTransport
    implements Transport {
        protected final Transport transport;

        public DelegateTransport(Transport transport) {
            this.transport = transport;
        }

        public void transportServiceAdapter(TransportServiceAdapter service) {
            this.transport.transportServiceAdapter(service);
        }

        public BoundTransportAddress boundAddress() {
            return this.transport.boundAddress();
        }

        public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws UnknownHostException {
            return this.transport.addressesFromString(address, perAddressLimit);
        }

        public boolean addressSupported(Class<? extends TransportAddress> address) {
            return this.transport.addressSupported(address);
        }

        public boolean nodeConnected(DiscoveryNode node) {
            return this.transport.nodeConnected(node);
        }

        public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
            this.transport.connectToNode(node, connectionProfile);
        }

        public void disconnectFromNode(DiscoveryNode node) {
            this.transport.disconnectFromNode(node);
        }

        public long serverOpen() {
            return this.transport.serverOpen();
        }

        public List<String> getLocalAddresses() {
            return this.transport.getLocalAddresses();
        }

        public long newRequestId() {
            return this.transport.newRequestId();
        }

        public Transport.Connection getConnection(DiscoveryNode node) {
            return new FilteredConnection(this.transport.getConnection(node)){

                @Override
                public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
                    this.sendRequest(this.connection, requestId, action, request, options);
                }
            };
        }

        public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) throws IOException {
            return new FilteredConnection(this.transport.openConnection(node, profile)){

                @Override
                public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
                    this.sendRequest(this.connection, requestId, action, request, options);
                }
            };
        }

        public Lifecycle.State lifecycleState() {
            return this.transport.lifecycleState();
        }

        public void addLifecycleListener(LifecycleListener listener) {
            this.transport.addLifecycleListener(listener);
        }

        public void removeLifecycleListener(LifecycleListener listener) {
            this.transport.removeLifecycleListener(listener);
        }

        public void start() {
            this.transport.start();
        }

        public void stop() {
            this.transport.stop();
        }

        public void close() {
            this.transport.close();
        }

        public Map<String, BoundTransportAddress> profileBoundAddresses() {
            return this.transport.profileBoundAddresses();
        }

        protected void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException {
            connection.sendRequest(requestId, action, request, options);
        }
    }

    private static class LookupTestTransport
    extends DelegateTransport {
        final ConcurrentMap<TransportAddress, Transport> transports = ConcurrentCollections.newConcurrentMap();

        LookupTestTransport(Transport transport) {
            super(transport);
        }

        private Transport getTransport(DiscoveryNode node) {
            Transport transport = (Transport)this.transports.get(node.getAddress());
            if (transport != null) {
                return transport;
            }
            return this.transport;
        }

        @Override
        public boolean nodeConnected(DiscoveryNode node) {
            return this.getTransport(node).nodeConnected(node);
        }

        @Override
        public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) throws ConnectTransportException {
            this.getTransport(node).connectToNode(node, connectionProfile);
        }

        @Override
        public void disconnectFromNode(DiscoveryNode node) {
            this.getTransport(node).disconnectFromNode(node);
        }

        @Override
        public Transport.Connection getConnection(DiscoveryNode node) {
            return this.getTransport(node).getConnection(node);
        }

        @Override
        public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) throws IOException {
            return this.getTransport(node).openConnection(node, profile);
        }
    }

    public static class TestPlugin
    extends Plugin {
        public List<Setting<?>> getSettings() {
            return Arrays.asList(MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING);
        }
    }
}

