/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;

public class MockSecureSettings
implements SecureSettings {
    private Map<String, SecureString> secureStrings = new HashMap<String, SecureString>();
    private Map<String, byte[]> files = new HashMap<String, byte[]>();
    private Set<String> settingNames = new HashSet<String>();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public boolean isLoaded() {
        return true;
    }

    public Set<String> getSettingNames() {
        return this.settingNames;
    }

    public SecureString getString(String setting) {
        this.ensureOpen();
        return this.secureStrings.get(setting);
    }

    public InputStream getFile(String setting) {
        this.ensureOpen();
        return new ByteArrayInputStream(this.files.get(setting));
    }

    public void setString(String setting, String value) {
        this.ensureOpen();
        this.secureStrings.put(setting, new SecureString(value.toCharArray()));
        this.settingNames.add(setting);
    }

    public void setFile(String setting, byte[] value) {
        this.ensureOpen();
        this.files.put(setting, value);
        this.settingNames.add(setting);
    }

    public void merge(MockSecureSettings secureSettings) {
        for (String setting : secureSettings.getSettingNames()) {
            if (!this.settingNames.contains(setting)) continue;
            throw new IllegalArgumentException("Cannot overwrite existing secure setting " + setting);
        }
        this.settingNames.addAll(secureSettings.settingNames);
        this.secureStrings.putAll(secureSettings.secureStrings);
        this.files.putAll(secureSettings.files);
    }

    public void close() throws IOException {
        this.closed.set(true);
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new IllegalStateException("secure settings are already closed");
        }
    }
}

