/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.RescoreBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.test.ESTestCase;

public class RandomSearchRequestGenerator {
    private RandomSearchRequestGenerator() {
    }

    public static SearchRequest randomSearchRequest(Supplier<SearchSourceBuilder> randomSearchSourceBuilder) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        if (ESTestCase.randomBoolean()) {
            searchRequest.indices(ESTestCase.generateRandomStringArray(10, 10, false, false));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)ESTestCase.randomBoolean(), (boolean)ESTestCase.randomBoolean(), (boolean)ESTestCase.randomBoolean(), (boolean)ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.types(ESTestCase.generateRandomStringArray(10, 10, false, false));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.preference(ESTestCase.randomAlphaOfLengthBetween(3, 10));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.requestCache(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.routing(ESTestCase.randomAlphaOfLengthBetween(3, 10));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.scroll(ESTestCase.randomPositiveTimeValue());
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.searchType(ESTestCase.randomFrom(SearchType.DFS_QUERY_THEN_FETCH, SearchType.QUERY_THEN_FETCH));
        }
        if (ESTestCase.randomBoolean()) {
            searchRequest.source(randomSearchSourceBuilder.get());
        }
        return searchRequest;
    }

    public static SearchSourceBuilder randomSearchSourceBuilder(Supplier<HighlightBuilder> randomHighlightBuilder, Supplier<SuggestBuilder> randomSuggestBuilder, Supplier<RescoreBuilder<?>> randomRescoreBuilder, Supplier<List<SearchExtBuilder>> randomExtBuilders, Supplier<CollapseBuilder> randomCollapseBuilder) {
        int i;
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (ESTestCase.randomBoolean()) {
            builder.from(ESTestCase.randomIntBetween(0, 10000));
        }
        if (ESTestCase.randomBoolean()) {
            builder.size(ESTestCase.randomIntBetween(0, 10000));
        }
        if (ESTestCase.randomBoolean()) {
            builder.explain(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            builder.version(Boolean.valueOf(ESTestCase.randomBoolean()));
        }
        if (ESTestCase.randomBoolean()) {
            builder.trackScores(ESTestCase.randomBoolean());
        }
        if (ESTestCase.randomBoolean()) {
            builder.minScore(ESTestCase.randomFloat() * 1000.0f);
        }
        if (ESTestCase.randomBoolean()) {
            builder.timeout(TimeValue.parseTimeValue((String)ESTestCase.randomTimeValue(), null, (String)"timeout"));
        }
        if (ESTestCase.randomBoolean()) {
            builder.terminateAfter(ESTestCase.randomIntBetween(1, 100000));
        }
        switch (ESTestCase.randomInt(2)) {
            case 0: {
                builder.storedFields();
                break;
            }
            case 1: {
                builder.storedField("_none_");
                break;
            }
            case 2: {
                int fieldsSize = ESTestCase.randomInt(25);
                ArrayList<String> fields = new ArrayList<String>(fieldsSize);
                for (i = 0; i < fieldsSize; ++i) {
                    fields.add(ESTestCase.randomAlphaOfLengthBetween(5, 50));
                }
                builder.storedFields(fields);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (ESTestCase.randomBoolean()) {
            int scriptFieldsSize = ESTestCase.randomInt(25);
            for (int i2 = 0; i2 < scriptFieldsSize; ++i2) {
                if (ESTestCase.randomBoolean()) {
                    builder.scriptField(ESTestCase.randomAlphaOfLengthBetween(5, 50), ESTestCase.mockScript("foo"), ESTestCase.randomBoolean());
                    continue;
                }
                builder.scriptField(ESTestCase.randomAlphaOfLengthBetween(5, 50), ESTestCase.mockScript("foo"));
            }
        }
        if (ESTestCase.randomBoolean()) {
            FetchSourceContext fetchSourceContext;
            int branch = ESTestCase.randomInt(5);
            String[] includes = new String[ESTestCase.randomIntBetween(0, 20)];
            for (int i3 = 0; i3 < includes.length; ++i3) {
                includes[i3] = ESTestCase.randomAlphaOfLengthBetween(5, 20);
            }
            String[] excludes = new String[ESTestCase.randomIntBetween(0, 20)];
            for (int i4 = 0; i4 < excludes.length; ++i4) {
                excludes[i4] = ESTestCase.randomAlphaOfLengthBetween(5, 20);
            }
            switch (branch) {
                case 0: {
                    fetchSourceContext = new FetchSourceContext(ESTestCase.randomBoolean());
                    break;
                }
                case 1: {
                    fetchSourceContext = new FetchSourceContext(true, includes, excludes);
                    break;
                }
                case 2: {
                    fetchSourceContext = new FetchSourceContext(true, new String[]{ESTestCase.randomAlphaOfLengthBetween(5, 20)}, new String[]{ESTestCase.randomAlphaOfLengthBetween(5, 20)});
                    break;
                }
                case 3: {
                    fetchSourceContext = new FetchSourceContext(true, includes, excludes);
                    break;
                }
                case 4: {
                    fetchSourceContext = new FetchSourceContext(true, includes, null);
                    break;
                }
                case 5: {
                    fetchSourceContext = new FetchSourceContext(true, new String[]{ESTestCase.randomAlphaOfLengthBetween(5, 20)}, null);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            builder.fetchSource(fetchSourceContext);
        }
        if (ESTestCase.randomBoolean()) {
            int size = ESTestCase.randomIntBetween(0, 20);
            ArrayList<String> statsGroups = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                statsGroups.add(ESTestCase.randomAlphaOfLengthBetween(5, 20));
            }
            builder.stats(statsGroups);
        }
        if (ESTestCase.randomBoolean()) {
            int indexBoostSize = ESTestCase.randomIntBetween(1, 10);
            for (int i5 = 0; i5 < indexBoostSize; ++i5) {
                builder.indexBoost(ESTestCase.randomAlphaOfLengthBetween(5, 20), ESTestCase.randomFloat() * 10.0f);
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.query((QueryBuilder)QueryBuilders.termQuery((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String)ESTestCase.randomAlphaOfLengthBetween(5, 20)));
        }
        if (ESTestCase.randomBoolean()) {
            builder.postFilter((QueryBuilder)QueryBuilders.termQuery((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String)ESTestCase.randomAlphaOfLengthBetween(5, 20)));
        }
        if (ESTestCase.randomBoolean()) {
            int numSorts = ESTestCase.randomIntBetween(1, 5);
            block40: for (int i6 = 0; i6 < numSorts; ++i6) {
                int branch = ESTestCase.randomInt(5);
                switch (branch) {
                    case 0: {
                        builder.sort(SortBuilders.fieldSort((String)ESTestCase.randomAlphaOfLengthBetween(5, 20)).order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block40;
                    }
                    case 1: {
                        builder.sort(SortBuilders.geoDistanceSort((String)ESTestCase.randomAlphaOfLengthBetween(5, 20), (String[])new String[]{AbstractQueryTestCase.randomGeohash(1, 12)}).order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block40;
                    }
                    case 2: {
                        builder.sort(SortBuilders.scoreSort().order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block40;
                    }
                    case 3: {
                        builder.sort(SortBuilders.scriptSort((Script)new Script(ScriptType.INLINE, "painless", "foo", Collections.emptyMap()), (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.NUMBER).order(ESTestCase.randomFrom(SortOrder.values())));
                        continue block40;
                    }
                    case 4: {
                        builder.sort(ESTestCase.randomAlphaOfLengthBetween(5, 20));
                        continue block40;
                    }
                    case 5: {
                        builder.sort(ESTestCase.randomAlphaOfLengthBetween(5, 20), ESTestCase.randomFrom(SortOrder.values()));
                    }
                }
            }
        }
        if (ESTestCase.randomBoolean()) {
            int numSearchFrom = ESTestCase.randomIntBetween(1, 5);
            try {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
                jsonBuilder.startObject();
                jsonBuilder.startArray("search_from");
                block41: for (i = 0; i < numSearchFrom; ++i) {
                    int branch = ESTestCase.randomInt(8);
                    switch (branch) {
                        case 0: {
                            jsonBuilder.value(ESTestCase.randomInt());
                            continue block41;
                        }
                        case 1: {
                            jsonBuilder.value(ESTestCase.randomFloat());
                            continue block41;
                        }
                        case 2: {
                            jsonBuilder.value(ESTestCase.randomLong());
                            continue block41;
                        }
                        case 3: {
                            jsonBuilder.value(ESTestCase.randomDouble());
                            continue block41;
                        }
                        case 4: {
                            jsonBuilder.value(ESTestCase.randomAlphaOfLengthBetween(5, 20));
                            continue block41;
                        }
                        case 5: {
                            jsonBuilder.value(ESTestCase.randomBoolean());
                            continue block41;
                        }
                        case 6: {
                            jsonBuilder.value(ESTestCase.randomByte());
                            continue block41;
                        }
                        case 7: {
                            jsonBuilder.value(ESTestCase.randomShort());
                            continue block41;
                        }
                        case 8: {
                            jsonBuilder.value(new Text(ESTestCase.randomAlphaOfLengthBetween(5, 20)));
                        }
                    }
                }
                jsonBuilder.endArray();
                jsonBuilder.endObject();
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, jsonBuilder.bytes());
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                builder.searchAfter(SearchAfterBuilder.fromXContent((XContentParser)parser).getSortValues());
            }
            catch (IOException e) {
                throw new RuntimeException("Error building search_from", e);
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.highlighter(randomHighlightBuilder.get());
        }
        if (ESTestCase.randomBoolean()) {
            builder.suggest(randomSuggestBuilder.get());
        }
        if (ESTestCase.randomBoolean()) {
            int numRescores = ESTestCase.randomIntBetween(1, 5);
            for (int i7 = 0; i7 < numRescores; ++i7) {
                builder.addRescorer(randomRescoreBuilder.get());
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)ESTestCase.randomAlphaOfLengthBetween(5, 20)));
        }
        if (ESTestCase.randomBoolean()) {
            builder.ext(randomExtBuilders.get());
        }
        if (ESTestCase.randomBoolean()) {
            String field = ESTestCase.randomBoolean() ? null : ESTestCase.randomAlphaOfLengthBetween(5, 20);
            int max = ESTestCase.between(2, 1000);
            int id = ESTestCase.randomInt(max - 1);
            if (field == null) {
                builder.slice(new SliceBuilder(id, max));
            } else {
                builder.slice(new SliceBuilder(field, id, max));
            }
        }
        if (ESTestCase.randomBoolean()) {
            builder.collapse(randomCollapseBuilder.get());
        }
        return builder;
    }
}

