/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.ParsedSingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.metrics.min.InternalMin;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class InternalSingleBucketAggregationTestCase<T extends InternalSingleBucketAggregation>
extends InternalAggregationTestCase<T> {
    private boolean hasInternalMax;
    private boolean hasInternalMin;
    public Supplier<InternalAggregations> subAggregationsSupplier;

    public void setUp() throws Exception {
        super.setUp();
        this.hasInternalMax = InternalSingleBucketAggregationTestCase.randomBoolean();
        this.hasInternalMin = InternalSingleBucketAggregationTestCase.randomBoolean();
        this.subAggregationsSupplier = () -> {
            ArrayList<Object> aggs = new ArrayList<Object>();
            if (this.hasInternalMax) {
                aggs.add(new InternalMax("max", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyList(), Collections.emptyMap()));
            }
            if (this.hasInternalMin) {
                aggs.add(new InternalMin("min", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyList(), Collections.emptyMap()));
            }
            return new InternalAggregations(aggs);
        };
    }

    protected abstract T createTestInstance(String var1, long var2, InternalAggregations var4, List<PipelineAggregator> var5, Map<String, Object> var6);

    @Override
    protected final T createTestInstance(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        long docCount = InternalSingleBucketAggregationTestCase.between(0, Integer.MAX_VALUE);
        return this.createTestInstance(name, docCount, this.subAggregationsSupplier.get(), pipelineAggregators, metaData);
    }

    @Override
    protected void assertFromXContent(T aggregation, ParsedAggregation parsedAggregation) throws IOException {
        InternalSingleBucketAggregationTestCase.assertTrue((boolean)(parsedAggregation instanceof ParsedSingleBucketAggregation));
        ParsedSingleBucketAggregation parsed = (ParsedSingleBucketAggregation)parsedAggregation;
        InternalSingleBucketAggregationTestCase.assertEquals((long)aggregation.getDocCount(), (long)parsed.getDocCount());
        InternalAggregations aggregations = aggregation.getAggregations();
        HashMap<String, Object> expectedAggregations = new HashMap<String, Object>();
        int expectedNumberOfAggregations = 0;
        for (Object expectedAggregation : aggregations) {
            InternalSingleBucketAggregationTestCase.assertTrue((boolean)(expectedAggregation instanceof InternalAggregation));
            expectedAggregations.put(expectedAggregation.getName(), expectedAggregation);
            ++expectedNumberOfAggregations;
        }
        int parsedNumberOfAggregations = 0;
        for (Aggregation parsedAgg : parsed.getAggregations()) {
            InternalSingleBucketAggregationTestCase.assertTrue((boolean)(parsedAgg instanceof ParsedAggregation));
            InternalSingleBucketAggregationTestCase.assertTrue((boolean)expectedAggregations.keySet().contains(parsedAgg.getName()));
            Aggregation expectedInternalAggregation = (Aggregation)expectedAggregations.get(parsedAgg.getName());
            XContentType xContentType = InternalSingleBucketAggregationTestCase.randomFrom(XContentType.values());
            ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("typed_keys", "true"));
            BytesReference expectedBytes = XContentHelper.toXContent((ToXContent)expectedInternalAggregation, (XContentType)xContentType, (ToXContent.Params)params, (boolean)false);
            BytesReference actualBytes = XContentHelper.toXContent((ToXContent)parsedAgg, (XContentType)xContentType, (ToXContent.Params)params, (boolean)false);
            ElasticsearchAssertions.assertToXContentEquivalent(expectedBytes, actualBytes, xContentType);
            ++parsedNumberOfAggregations;
        }
        InternalSingleBucketAggregationTestCase.assertEquals((long)expectedNumberOfAggregations, (long)parsedNumberOfAggregations);
        Class<ParsedSingleBucketAggregation> parsedClass = this.implementationClass();
        InternalSingleBucketAggregationTestCase.assertTrue((parsedClass != null && parsedClass.isInstance(parsedAggregation) ? 1 : 0) != 0);
    }

    protected abstract Class<? extends ParsedSingleBucketAggregation> implementationClass();
}

