/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorFactory;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class AbstractTermsTestCase
extends ESIntegTestCase {
    public String randomExecutionHint() {
        return AbstractTermsTestCase.randomBoolean() ? null : AbstractTermsTestCase.randomFrom(TermsAggregatorFactory.ExecutionMode.values()).toString();
    }

    private static long sumOfDocCounts(Terms terms) {
        long sumOfDocCounts = terms.getSumOfOtherDocCounts();
        for (Terms.Bucket b : terms.getBuckets()) {
            sumOfDocCounts += b.getDocCount();
        }
        return sumOfDocCounts;
    }

    public void testOtherDocCount(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            SearchResponse allTerms = (SearchResponse)AbstractTermsTestCase.client().prepareSearch(new String[]{"idx"}).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"terms").executionHint(this.randomExecutionHint()).field(fieldName)).size(10000).collectMode(AbstractTermsTestCase.randomFrom(Aggregator.SubAggCollectionMode.values()))).get();
            ElasticsearchAssertions.assertSearchResponse(allTerms);
            Terms terms = (Terms)allTerms.getAggregations().get("terms");
            AbstractTermsTestCase.assertEquals((long)0L, (long)terms.getSumOfOtherDocCounts());
            long sumOfDocCounts = AbstractTermsTestCase.sumOfDocCounts(terms);
            int totalNumTerms = terms.getBuckets().size();
            for (int size = 1; size < totalNumTerms + 2; size += AbstractTermsTestCase.randomIntBetween(1, 5)) {
                for (int shardSize = size; shardSize <= totalNumTerms + 2; shardSize += AbstractTermsTestCase.randomIntBetween(1, 5)) {
                    SearchResponse resp = (SearchResponse)AbstractTermsTestCase.client().prepareSearch(new String[]{"idx"}).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"terms").executionHint(this.randomExecutionHint()).field(fieldName)).size(size).shardSize(shardSize).collectMode(AbstractTermsTestCase.randomFrom(Aggregator.SubAggCollectionMode.values()))).get();
                    ElasticsearchAssertions.assertSearchResponse(resp);
                    terms = (Terms)resp.getAggregations().get("terms");
                    AbstractTermsTestCase.assertEquals((long)Math.min(size, totalNumTerms), (long)terms.getBuckets().size());
                    AbstractTermsTestCase.assertEquals((long)sumOfDocCounts, (long)AbstractTermsTestCase.sumOfDocCounts(terms));
                }
            }
        }
    }
}

