/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractStreamableTestCase<T extends Streamable>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    protected abstract T createTestInstance();

    protected abstract T createBlankInstance();

    public void testEqualsAndHashcode() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            T firstInstance = this.createTestInstance();
            AbstractStreamableTestCase.assertFalse((String)"instance is equal to null", (boolean)firstInstance.equals(null));
            AbstractStreamableTestCase.assertFalse((String)"instance is equal to incompatible type", (boolean)firstInstance.equals(""));
            AbstractStreamableTestCase.assertEquals((String)"instance is not equal to self", firstInstance, firstInstance);
            AbstractStreamableTestCase.assertThat((String)"same instance's hashcode returns different values if called multiple times", (Object)firstInstance.hashCode(), (Matcher)Matchers.equalTo((Object)firstInstance.hashCode()));
            T secondInstance = this.copyInstance(firstInstance, Version.CURRENT);
            AbstractStreamableTestCase.assertEquals((String)"instance is not equal to self", secondInstance, secondInstance);
            AbstractStreamableTestCase.assertEquals((String)"instance is not equal to its copy", firstInstance, secondInstance);
            AbstractStreamableTestCase.assertEquals((String)"equals is not symmetric", secondInstance, firstInstance);
            AbstractStreamableTestCase.assertThat((String)"instance copy's hashcode is different from original hashcode", (Object)secondInstance.hashCode(), (Matcher)Matchers.equalTo((Object)firstInstance.hashCode()));
            T thirdInstance = this.copyInstance(secondInstance, Version.CURRENT);
            AbstractStreamableTestCase.assertEquals((String)"instance is not equal to self", thirdInstance, thirdInstance);
            AbstractStreamableTestCase.assertEquals((String)"instance is not equal to its copy", secondInstance, thirdInstance);
            AbstractStreamableTestCase.assertThat((String)"instance copy's hashcode is different from original hashcode", (Object)secondInstance.hashCode(), (Matcher)Matchers.equalTo((Object)thirdInstance.hashCode()));
            AbstractStreamableTestCase.assertEquals((String)"equals is not transitive", firstInstance, thirdInstance);
            AbstractStreamableTestCase.assertThat((String)"instance copy's hashcode is different from original hashcode", (Object)firstInstance.hashCode(), (Matcher)Matchers.equalTo((Object)thirdInstance.hashCode()));
            AbstractStreamableTestCase.assertEquals((String)"equals is not symmetric", thirdInstance, secondInstance);
            AbstractStreamableTestCase.assertEquals((String)"equals is not symmetric", thirdInstance, firstInstance);
        }
    }

    public void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            T testInstance = this.createTestInstance();
            this.assertSerialization(testInstance);
        }
    }

    protected T assertSerialization(T testInstance) throws IOException {
        T deserializedInstance = this.copyInstance(testInstance, Version.CURRENT);
        AbstractStreamableTestCase.assertEquals(testInstance, deserializedInstance);
        AbstractStreamableTestCase.assertEquals((long)testInstance.hashCode(), (long)deserializedInstance.hashCode());
        AbstractStreamableTestCase.assertNotSame(testInstance, deserializedInstance);
        return deserializedInstance;
    }

    /*
     * Exception decompiling
     */
    protected T copyInstance(T instance, Version version) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected NamedWriteableRegistry getNamedWriteableRegistry() {
        return new NamedWriteableRegistry(Collections.emptyList());
    }
}

