/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public final class FakeRestChannel
extends AbstractRestChannel {
    private final CountDownLatch latch;
    private final AtomicInteger responses = new AtomicInteger();
    private final AtomicInteger errors = new AtomicInteger();

    public FakeRestChannel(RestRequest request, boolean detailedErrorsEnabled, int responseCount) {
        super(request, detailedErrorsEnabled);
        this.latch = new CountDownLatch(responseCount);
    }

    public XContentBuilder newBuilder() throws IOException {
        return super.newBuilder();
    }

    public XContentBuilder newErrorBuilder() throws IOException {
        return super.newErrorBuilder();
    }

    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, boolean useFiltering) throws IOException {
        return super.newBuilder(requestContentType, useFiltering);
    }

    protected BytesStreamOutput newBytesOutput() {
        return super.newBytesOutput();
    }

    public RestRequest request() {
        return super.request();
    }

    public void sendResponse(RestResponse response) {
        if (response.status() == RestStatus.OK) {
            this.responses.incrementAndGet();
        } else {
            this.errors.incrementAndGet();
        }
        this.latch.countDown();
    }

    public boolean await() throws InterruptedException {
        return this.latch.await(10L, TimeUnit.SECONDS);
    }

    public AtomicInteger responses() {
        return this.responses;
    }

    public AtomicInteger errors() {
        return this.errors;
    }
}

