/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.elasticsearch.Version;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.test.rest.yaml.BlacklistedPathPatternMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestCandidate;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSection;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSuite;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class ESClientYamlSuiteTestCase
extends ESRestTestCase {
    public static final String REST_TESTS_SUITE = "tests.rest.suite";
    public static final String REST_TESTS_BLACKLIST = "tests.rest.blacklist";
    private static final String REST_TESTS_VALIDATE_SPEC = "tests.rest.validate_spec";
    private static final String TESTS_PATH = "/rest-api-spec/test";
    private static final String SPEC_PATH = "/rest-api-spec/api";
    private static final String PATHS_SEPARATOR = "(?<!\\\\),";
    private static List<BlacklistedPathPatternMatcher> blacklistPathMatchers;
    private static ClientYamlTestExecutionContext restTestExecutionContext;
    private static ClientYamlTestExecutionContext adminExecutionContext;
    private final ClientYamlTestCandidate testCandidate;

    protected ESClientYamlSuiteTestCase(ClientYamlTestCandidate testCandidate) {
        this.testCandidate = testCandidate;
    }

    @Before
    public void initAndResetContext() throws Exception {
        if (restTestExecutionContext == null) {
            Version esVersion;
            assert (adminExecutionContext == null);
            assert (blacklistPathMatchers == null);
            ClientYamlSuiteRestSpec restSpec = ClientYamlSuiteRestSpec.load(SPEC_PATH);
            ESClientYamlSuiteTestCase.validateSpec(restSpec);
            List<HttpHost> hosts = this.getClusterHosts();
            RestClient restClient = ESClientYamlSuiteTestCase.client();
            Tuple<Version, Map<HttpHost, Version>> versionMapTuple = ESClientYamlSuiteTestCase.readVersionsFromInfo(restClient, hosts.size());
            try {
                Tuple<Version, Version> versionVersionTuple = ESClientYamlSuiteTestCase.readVersionsFromCatNodes(restClient);
                esVersion = (Version)versionVersionTuple.v1();
                Version masterVersion = (Version)versionVersionTuple.v2();
                this.logger.info("initializing yaml client, minimum es version: [{}] master version: [{}] hosts: {}", (Object)esVersion, (Object)masterVersion, hosts);
            }
            catch (ResponseException ex) {
                if (ex.getResponse().getStatusLine().getStatusCode() == 403) {
                    this.logger.warn("Fallback to simple info '/' request, _cat/nodes is not authorized");
                    esVersion = (Version)versionMapTuple.v1();
                    this.logger.info("initializing yaml client, minimum es version: [{}] hosts: {}", (Object)esVersion, hosts);
                }
                throw ex;
            }
            ClientYamlTestClient clientYamlTestClient = this.initClientYamlTestClient(restSpec, restClient, hosts, esVersion, (Map)versionMapTuple.v2());
            restTestExecutionContext = new ClientYamlTestExecutionContext(clientYamlTestClient, this.randomizeContentType());
            adminExecutionContext = new ClientYamlTestExecutionContext(clientYamlTestClient, false);
            String[] blacklist = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST, null);
            blacklistPathMatchers = new ArrayList<BlacklistedPathPatternMatcher>();
            for (String entry : blacklist) {
                blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
            }
        }
        assert (restTestExecutionContext != null);
        assert (adminExecutionContext != null);
        assert (blacklistPathMatchers != null);
        adminExecutionContext.clear();
        restTestExecutionContext.clear();
    }

    protected ClientYamlTestClient initClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Map<HttpHost, Version> hostVersionMap) throws IOException {
        return new ClientYamlTestClient(restSpec, restClient, hosts, esVersion, hostVersionMap);
    }

    @Override
    protected void afterIfFailed(List<Throwable> errors) {
        this.logger.info("Stash dump on failure [{}]", (Object)XContentHelper.toString((ToXContent)restTestExecutionContext.stash()).replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t"));
        super.afterIfFailed(errors);
    }

    public static Iterable<Object[]> createParameters() throws Exception {
        String[] paths = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SUITE, "");
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        Map<String, Set<Path>> yamlSuites = ESClientYamlSuiteTestCase.loadYamlSuites(paths);
        for (String api : yamlSuites.keySet()) {
            ArrayList yamlFiles = new ArrayList(yamlSuites.get(api));
            for (Path yamlFile : yamlFiles) {
                ClientYamlTestSuite restTestSuite = ClientYamlTestSuite.parse(api, yamlFile);
                for (ClientYamlTestSection testSection : restTestSuite.getTestSections()) {
                    tests.add(new Object[]{new ClientYamlTestCandidate(restTestSuite, testSection)});
                }
            }
        }
        Collections.sort(tests, (o1, o2) -> ((ClientYamlTestCandidate)o1[0]).getTestPath().compareTo(((ClientYamlTestCandidate)o2[0]).getTestPath()));
        return tests;
    }

    static Map<String, Set<Path>> loadYamlSuites(String ... paths) throws Exception {
        HashMap<String, Set<Path>> files = new HashMap<String, Set<Path>>();
        Path root = PathUtils.get((URI)ESClientYamlSuiteTestCase.class.getResource(TESTS_PATH).toURI());
        for (String strPath : paths) {
            Path path = root.resolve(strPath);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walk(path, new FileVisitOption[0]).forEach(file -> {
                    if (file.toString().endsWith(".yaml")) {
                        ESClientYamlSuiteTestCase.addYamlSuite(root, file, files);
                    }
                });
                continue;
            }
            path = root.resolve(strPath + ".yaml");
            assert (Files.exists(path, new LinkOption[0]));
            ESClientYamlSuiteTestCase.addYamlSuite(root, path, files);
        }
        return files;
    }

    private static void addYamlSuite(Path root, Path file, Map<String, Set<Path>> files) {
        String groupName = root.relativize(file.getParent()).toString();
        Set<Path> filesSet = files.get(groupName);
        if (filesSet == null) {
            filesSet = new HashSet<Path>();
            files.put(groupName, filesSet);
        }
        filesSet.add(file);
    }

    private static String[] resolvePathsProperty(String propertyName, String defaultValue) {
        String property = System.getProperty(propertyName);
        if (!Strings.hasLength((String)property)) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = Strings.EMPTY_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            return stringArray;
        }
        return property.split(PATHS_SEPARATOR);
    }

    protected ClientYamlTestExecutionContext getAdminExecutionContext() {
        return adminExecutionContext;
    }

    private static void validateSpec(ClientYamlSuiteRestSpec restSpec) {
        boolean validateSpec = RandomizedTest.systemPropertyAsBoolean((String)REST_TESTS_VALIDATE_SPEC, (boolean)true);
        if (validateSpec) {
            StringBuilder errorMessage = new StringBuilder();
            for (ClientYamlSuiteRestApi restApi : restSpec.getApis()) {
                if (!restApi.getMethods().contains("GET") || !restApi.isBodySupported() || restApi.getMethods().contains("POST")) continue;
                errorMessage.append("\n- ").append(restApi.getName()).append(" supports GET with a body but doesn't support POST");
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }
    }

    @AfterClass
    public static void clearStatic() {
        blacklistPathMatchers = null;
        restTestExecutionContext = null;
        adminExecutionContext = null;
    }

    private static Tuple<Version, Version> readVersionsFromCatNodes(RestClient restClient) throws IOException {
        Response response = restClient.performRequest("GET", "/_cat/nodes", Collections.singletonMap("h", "version,master"), new Header[0]);
        ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response, Version.CURRENT);
        String nodesCatResponse = restTestResponse.getBodyAsString();
        String[] split = nodesCatResponse.split("\n");
        Version version = null;
        Version masterVersion = null;
        for (String perNode : split) {
            String[] versionAndMaster = perNode.split("\\s+");
            assert (versionAndMaster.length == 2) : "invalid line: " + perNode + " length: " + versionAndMaster.length;
            Version currentVersion = Version.fromString((String)versionAndMaster[0]);
            boolean master = versionAndMaster[1].trim().equals("*");
            if (master) {
                assert (masterVersion == null);
                masterVersion = currentVersion;
            }
            if (version == null) {
                version = currentVersion;
                continue;
            }
            if (!version.onOrAfter(currentVersion)) continue;
            version = currentVersion;
        }
        return new Tuple(version, masterVersion);
    }

    private static Tuple<Version, Map<HttpHost, Version>> readVersionsFromInfo(RestClient restClient, int numHosts) throws IOException {
        Version version = null;
        HashMap<HttpHost, Version> hostVersionMap = new HashMap<HttpHost, Version>();
        for (int i = 0; i < numHosts; ++i) {
            Response response = restClient.performRequest("GET", "/", new Header[0]);
            ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response, Version.CURRENT);
            Object latestVersion = restTestResponse.evaluate("version.number");
            if (latestVersion == null) {
                throw new RuntimeException("elasticsearch version not found in the response");
            }
            Version currentVersion = Version.fromString((String)latestVersion.toString());
            if (version == null) {
                version = currentVersion;
            } else if (version.onOrAfter(currentVersion)) {
                version = currentVersion;
            }
            hostVersionMap.put(response.getHost(), currentVersion);
        }
        return new Tuple(version, Collections.unmodifiableMap(hostVersionMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws IOException {
        for (BlacklistedPathPatternMatcher blacklistedPathMatcher : blacklistPathMatchers) {
            String testPath = this.testCandidate.getSuitePath() + "/" + this.testCandidate.getTestSection().getName();
            ESClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: blacklisted"), (boolean)blacklistedPathMatcher.isSuffixMatch(testPath));
        }
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getSetupSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getSetupSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTeardownSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getTeardownSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTestSection().getSkipSection().getSkipMessage(this.testCandidate.getTestPath()), (boolean)this.testCandidate.getTestSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        if (this.testCandidate.getTestSection().getExecutableSections().size() == 0) {
            throw new IllegalArgumentException("No executable sections loaded for [" + this.testCandidate.getTestPath() + "]");
        }
        if (!this.testCandidate.getSetupSection().isEmpty()) {
            this.logger.debug("start setup test [{}]", (Object)this.testCandidate.getTestPath());
            for (DoSection doSection : this.testCandidate.getSetupSection().getDoSections()) {
                this.executeSection(doSection);
            }
            this.logger.debug("end setup test [{}]", (Object)this.testCandidate.getTestPath());
        }
        restTestExecutionContext.clear();
        try {
            for (ExecutableSection executableSection : this.testCandidate.getTestSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
        }
        catch (Throwable throwable) {
            this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
            for (DoSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
                this.executeSection(doSection);
            }
            this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
            throw throwable;
        }
        this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
        for (DoSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
            this.executeSection(doSection);
        }
        this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
    }

    private void executeSection(ExecutableSection executableSection) {
        try {
            executableSection.execute(restTestExecutionContext);
        }
        catch (Exception e) {
            throw new RuntimeException(this.errorMessage(executableSection, e), e);
        }
        catch (AssertionError e) {
            throw new AssertionError(this.errorMessage(executableSection, (Throwable)((Object)e)), (Throwable)((Object)e));
        }
    }

    private String errorMessage(ExecutableSection executableSection, Throwable t) {
        return "Failure at [" + this.testCandidate.getSuitePath() + ":" + executableSection.getLocation().lineNumber + "]: " + t.getMessage();
    }

    protected boolean randomizeContentType() {
        return true;
    }
}

