/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import java.util.function.ToLongBiFunction;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.engine.TranslogHandler;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicies;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.test.DummyShardLock;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;

public abstract class EngineTestCase
extends ESTestCase {
    protected final ShardId shardId = new ShardId(new Index("index", "_na_"), 0);
    protected final AllocationId allocationId = AllocationId.newInitializing();
    protected static final IndexSettings INDEX_SETTINGS = IndexSettingsModule.newIndexSettings("index", Settings.EMPTY, new Setting[0]);
    protected ThreadPool threadPool;
    protected Store store;
    protected Store storeReplica;
    protected InternalEngine engine;
    protected InternalEngine replicaEngine;
    protected IndexSettings defaultSettings;
    protected String codecName;
    protected Path primaryTranslogDir;
    protected Path replicaTranslogDir;
    protected AtomicLong primaryTerm = new AtomicLong();
    protected static final BytesReference B_1 = new BytesArray(new byte[]{1});
    protected static final BytesReference B_2 = new BytesArray(new byte[]{2});
    protected static final BytesReference B_3 = new BytesArray(new byte[]{3});
    protected static final BytesArray SOURCE = EngineTestCase.bytesArray("{}");

    protected static void assertVisibleCount(Engine engine, int numDocs) throws IOException {
        EngineTestCase.assertVisibleCount(engine, numDocs, true);
    }

    protected static void assertVisibleCount(Engine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            TotalHitCountCollector collector = new TotalHitCountCollector();
            searcher.searcher().search((Query)new MatchAllDocsQuery(), (Collector)collector);
            EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)numDocs));
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.primaryTerm.set(EngineTestCase.randomLongBetween(1L, Long.MAX_VALUE));
        CodecService codecService = new CodecService(null, this.logger);
        String name = Codec.getDefault().getName();
        this.codecName = Arrays.asList(codecService.availableCodecs()).contains(name) ? name : "default";
        this.defaultSettings = IndexSettingsModule.newIndexSettings("test", Settings.builder().put(IndexSettings.INDEX_GC_DELETES_SETTING.getKey(), "1h").put(EngineConfig.INDEX_CODEC_SETTING.getKey(), this.codecName).put("index.version.created", Version.CURRENT).put(IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.getKey(), EngineTestCase.between(10, 10 * (Integer)IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.get(Settings.EMPTY))).build(), new Setting[0]);
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName());
        this.store = this.createStore();
        this.storeReplica = this.createStore();
        Lucene.cleanLuceneIndex((Directory)this.store.directory());
        Lucene.cleanLuceneIndex((Directory)this.storeReplica.directory());
        this.primaryTranslogDir = EngineTestCase.createTempDir((String)"translog-primary");
        this.engine = this.createEngine(this.store, this.primaryTranslogDir);
        LiveIndexWriterConfig currentIndexWriterConfig = this.engine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.engine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
        this.replicaTranslogDir = EngineTestCase.createTempDir((String)"translog-replica");
        this.replicaEngine = this.createEngine(this.storeReplica, this.replicaTranslogDir);
        currentIndexWriterConfig = this.replicaEngine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.replicaEngine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
    }

    public EngineConfig copy(EngineConfig config, LongSupplier globalCheckpointSupplier) {
        return new EngineConfig(config.getShardId(), config.getAllocationId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), config.getMergePolicy(), config.getAnalyzer(), config.getSimilarity(), new CodecService(null, this.logger), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getTranslogRecoveryRunner(), config.getCircuitBreakerService(), globalCheckpointSupplier, config.getPrimaryTermSupplier());
    }

    public EngineConfig copy(EngineConfig config, Analyzer analyzer) {
        return new EngineConfig(config.getShardId(), config.getAllocationId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), config.getMergePolicy(), analyzer, config.getSimilarity(), new CodecService(null, this.logger), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getTranslogRecoveryRunner(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.getPrimaryTermSupplier());
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.engine != null && !this.engine.isClosed.get()) {
            this.engine.getTranslog().getDeletionPolicy().assertNoOpenTranslogRefs();
        }
        if (this.replicaEngine != null && !this.replicaEngine.isClosed.get()) {
            this.replicaEngine.getTranslog().getDeletionPolicy().assertNoOpenTranslogRefs();
        }
        IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store});
        EngineTestCase.terminate(this.threadPool);
    }

    protected static ParseContext.Document testDocumentWithTextField() {
        return EngineTestCase.testDocumentWithTextField("test");
    }

    protected static ParseContext.Document testDocumentWithTextField(String value) {
        ParseContext.Document document = EngineTestCase.testDocument();
        document.add((IndexableField)new TextField("value", value, Field.Store.YES));
        return document;
    }

    protected static ParseContext.Document testDocument() {
        return new ParseContext.Document();
    }

    public static ParsedDocument createParsedDoc(String id, String routing) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null);
    }

    protected static ParsedDocument testParsedDocument(String id, String routing, ParseContext.Document document, BytesReference source, Mapping mappingUpdate) {
        Field uidField = new Field("_id", Uid.encodeId((String)id), (IndexableFieldType)IdFieldMapper.Defaults.FIELD_TYPE);
        NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
        SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
        document.add((IndexableField)uidField);
        document.add((IndexableField)versionField);
        document.add((IndexableField)seqID.seqNo);
        document.add((IndexableField)seqID.seqNoDocValue);
        document.add((IndexableField)seqID.primaryTerm);
        BytesRef ref = source.toBytesRef();
        document.add((IndexableField)new StoredField("_source", ref.bytes, ref.offset, ref.length));
        return new ParsedDocument((Field)versionField, seqID, id, "test", routing, Arrays.asList(document), source, XContentType.JSON, mappingUpdate);
    }

    protected Store createStore() throws IOException {
        return this.createStore((Directory)EngineTestCase.newDirectory());
    }

    protected Store createStore(Directory directory) throws IOException {
        return this.createStore(INDEX_SETTINGS, directory);
    }

    protected Store createStore(IndexSettings indexSettings, final Directory directory) throws IOException {
        DirectoryService directoryService = new DirectoryService(this.shardId, indexSettings){

            public Directory newDirectory() throws IOException {
                return directory;
            }
        };
        return new Store(this.shardId, indexSettings, directoryService, (ShardLock)new DummyShardLock(this.shardId));
    }

    protected Translog createTranslog(LongSupplier primaryTermSupplier) throws IOException {
        return this.createTranslog(this.primaryTranslogDir, primaryTermSupplier);
    }

    protected Translog createTranslog(Path translogPath, LongSupplier primaryTermSupplier) throws IOException {
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, INDEX_SETTINGS, BigArrays.NON_RECYCLING_INSTANCE);
        String translogUUID = Translog.createEmptyTranslog((Path)translogPath, (long)-1L, (ShardId)this.shardId, (long)primaryTermSupplier.getAsLong());
        return new Translog(translogConfig, translogUUID, TranslogDeletionPolicies.createTranslogDeletionPolicy(INDEX_SETTINGS), () -> -1L, primaryTermSupplier);
    }

    protected InternalEngine createEngine(Store store, Path translogPath) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null, seqNoForOperation);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, null, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, @Nullable Sort indexSort, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        EngineConfig config = this.config(indexSettings, store, translogPath, mergePolicy, null, indexSort, globalCheckpointSupplier);
        return this.createEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
    }

    protected InternalEngine createEngine(EngineConfig config) throws IOException {
        return this.createEngine(null, null, null, config);
    }

    private InternalEngine createEngine(@Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) throws IOException {
        Store store = config.getStore();
        Directory directory = store.directory();
        if (!Lucene.indexExists((Directory)directory)) {
            store.createEmpty();
            String translogUuid = Translog.createEmptyTranslog((Path)config.getTranslogConfig().getTranslogPath(), (long)-1L, (ShardId)this.shardId, (long)this.primaryTerm.get());
            store.associateIndexWithNewTranslog(translogUuid);
        }
        InternalEngine internalEngine = EngineTestCase.createInternalEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
        internalEngine.recoverFromTranslog();
        return internalEngine;
    }

    public static InternalEngine createInternalEngine(final @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, final @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) {
        if (localCheckpointTrackerSupplier == null) {
            return new InternalEngine(config){

                IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                    return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
                }

                protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                    return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
                }
            };
        }
        return new InternalEngine(config, localCheckpointTrackerSupplier){

            IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
            }

            protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
            }
        };
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, () -> -1L);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier) {
        IndexWriterConfig iwc = EngineTestCase.newIndexWriterConfig();
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE);
        Engine.EventListener listener = new Engine.EventListener(){

            public void onFailedEngine(String reason, @Nullable Exception e) {
            }
        };
        TranslogHandler handler = new TranslogHandler(this.xContentRegistry(), IndexSettingsModule.newIndexSettings(this.shardId.getIndexName(), indexSettings.getSettings(), new Setting[0]));
        List<Object> refreshListenerList = refreshListener == null ? Collections.emptyList() : Collections.singletonList(refreshListener);
        EngineConfig config = new EngineConfig(this.shardId, this.allocationId.getId(), this.threadPool, indexSettings, null, store, mergePolicy, iwc.getAnalyzer(), iwc.getSimilarity(), new CodecService(null, this.logger), listener, IndexSearcher.getDefaultQueryCache(), IndexSearcher.getDefaultQueryCachingPolicy(), translogConfig, TimeValue.timeValueMinutes((long)5L), refreshListenerList, Collections.emptyList(), indexSort, (EngineConfig.TranslogRecoveryRunner)handler, (CircuitBreakerService)new NoneCircuitBreakerService(), (LongSupplier)(globalCheckpointSupplier == null ? new ReplicationTracker(this.shardId, this.allocationId.getId(), indexSettings, -1L) : globalCheckpointSupplier), this.primaryTerm::get);
        return config;
    }

    protected static BytesArray bytesArray(String string) {
        return new BytesArray(string.getBytes(Charset.defaultCharset()));
    }

    protected Term newUid(String id) {
        return new Term("_id", Uid.encodeId((String)id));
    }

    protected Term newUid(ParsedDocument doc) {
        return this.newUid(doc.id());
    }

    protected Engine.Get newGet(boolean realtime, ParsedDocument doc) {
        return new Engine.Get(realtime, false, doc.type(), doc.id(), this.newUid(doc));
    }

    protected Engine.Index indexForDoc(ParsedDocument doc) {
        return new Engine.Index(this.newUid(doc), this.primaryTerm.get(), doc);
    }

    protected Engine.Index replicaIndexForDoc(ParsedDocument doc, long version, long seqNo, boolean isRetry) {
        return new Engine.Index(this.newUid(doc), doc, seqNo, this.primaryTerm.get(), version, VersionType.EXTERNAL, Engine.Operation.Origin.REPLICA, System.nanoTime(), -1L, isRetry);
    }

    protected Engine.Delete replicaDeleteForDoc(String id, long version, long seqNo, long startTime) {
        return new Engine.Delete("test", id, this.newUid(id), seqNo, 1L, version, VersionType.EXTERNAL, Engine.Operation.Origin.REPLICA, startTime);
    }

    public static Translog getTranslog(Engine engine) {
        return engine.getTranslog();
    }

    @FunctionalInterface
    public static interface IndexWriterFactory {
        public IndexWriter createWriter(Directory var1, IndexWriterConfig var2) throws IOException;
    }
}

