/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.threadpool.ThreadPool;

public class TestSearchContext
extends SearchContext {
    final BigArrays bigArrays;
    final IndexService indexService;
    final BitsetFilterCache fixedBitSetFilterCache;
    final ThreadPool threadPool;
    final Map<Class<?>, Collector> queryCollectors = new HashMap();
    final IndexShard indexShard;
    final Counter timeEstimateCounter = Counter.newCounter();
    final QuerySearchResult queryResult = new QuerySearchResult();
    final QueryShardContext queryShardContext;
    ParsedQuery originalQuery;
    ParsedQuery postFilter;
    Query query;
    Float minScore;
    SearchTask task;
    SortAndFormats sort;
    boolean trackScores = false;
    boolean trackTotalHits = true;
    ContextIndexSearcher searcher;
    int size;
    private int terminateAfter = 0;
    private SearchContextAggregations aggregations;
    private ScrollContext scrollContext;
    private final long originNanoTime = System.nanoTime();
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();

    public TestSearchContext(ThreadPool threadPool, BigArrays bigArrays, IndexService indexService) {
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.indexService = indexService;
        this.fixedBitSetFilterCache = indexService.cache().bitsetFilterCache();
        this.threadPool = threadPool;
        this.indexShard = indexService.getShardOrNull(0);
        this.queryShardContext = indexService.newQueryShardContext(0, null, () -> 0L, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext) {
        this(queryShardContext, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext, IndexShard indexShard) {
        this.bigArrays = null;
        this.indexService = null;
        this.threadPool = null;
        this.fixedBitSetFilterCache = null;
        this.indexShard = indexShard;
        this.queryShardContext = queryShardContext;
    }

    public void preProcess(boolean rewrite) {
    }

    public Query buildFilteredQuery(Query query) {
        return null;
    }

    public long id() {
        return 0L;
    }

    public String source() {
        return null;
    }

    public ShardSearchRequest request() {
        return null;
    }

    public SearchType searchType() {
        return null;
    }

    public SearchShardTarget shardTarget() {
        return null;
    }

    public int numberOfShards() {
        return 1;
    }

    public float queryBoost() {
        return 0.0f;
    }

    public long getOriginNanoTime() {
        return this.originNanoTime;
    }

    public ScrollContext scrollContext() {
        return this.scrollContext;
    }

    public SearchContext scrollContext(ScrollContext scrollContext) {
        this.scrollContext = scrollContext;
        return this;
    }

    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    public SearchContextHighlight highlight() {
        return null;
    }

    public void highlight(SearchContextHighlight highlight) {
    }

    public SuggestionSearchContext suggest() {
        return null;
    }

    public void suggest(SuggestionSearchContext suggest) {
    }

    public List<RescoreContext> rescore() {
        return Collections.emptyList();
    }

    public void addRescore(RescoreContext rescore) {
    }

    public boolean hasScriptFields() {
        return false;
    }

    public ScriptFieldsContext scriptFields() {
        return null;
    }

    public boolean sourceRequested() {
        return false;
    }

    public boolean hasFetchSourceContext() {
        return false;
    }

    public FetchSourceContext fetchSourceContext() {
        return null;
    }

    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        return null;
    }

    public DocValueFieldsContext docValueFieldsContext() {
        return null;
    }

    public SearchContext docValueFieldsContext(DocValueFieldsContext docValueFieldsContext) {
        return null;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public void setSearcher(Engine.Searcher searcher) {
        this.searcher = new ContextIndexSearcher(searcher, (QueryCache)this.indexService.cache().query(), this.indexShard.getQueryCachingPolicy());
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public MapperService mapperService() {
        if (this.indexService != null) {
            return this.indexService.mapperService();
        }
        return null;
    }

    public SimilarityService similarityService() {
        return null;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.fixedBitSetFilterCache;
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        return (IFD)this.queryShardContext.getForField(fieldType);
    }

    public TimeValue timeout() {
        return TimeValue.ZERO;
    }

    public void timeout(TimeValue timeout) {
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    public boolean lowLevelCancellation() {
        return false;
    }

    public SearchContext minimumScore(float minimumScore) {
        this.minScore = Float.valueOf(minimumScore);
        return this;
    }

    public Float minimumScore() {
        return this.minScore;
    }

    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    public SortAndFormats sort() {
        return this.sort;
    }

    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchContext trackTotalHits(boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
        return this;
    }

    public boolean trackTotalHits() {
        return this.trackTotalHits;
    }

    public SearchContext searchAfter(FieldDoc searchAfter) {
        return null;
    }

    public FieldDoc searchAfter() {
        return null;
    }

    public SearchContext collapse(CollapseContext collapse) {
        return null;
    }

    public CollapseContext collapse() {
        return null;
    }

    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    public Query aliasFilter() {
        return null;
    }

    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public int from() {
        return 0;
    }

    public SearchContext from(int from) {
        return null;
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SearchContext size(int size) {
        return null;
    }

    public boolean hasStoredFields() {
        return false;
    }

    public boolean hasStoredFieldsContext() {
        return false;
    }

    public boolean storedFieldsRequested() {
        return false;
    }

    public StoredFieldsContext storedFieldsContext() {
        return null;
    }

    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        return null;
    }

    public boolean explain() {
        return false;
    }

    public void explain(boolean explain) {
    }

    public List<String> groupStats() {
        return null;
    }

    public void groupStats(List<String> groupStats) {
    }

    public boolean version() {
        return false;
    }

    public void version(boolean version) {
    }

    public int[] docIdsToLoad() {
        return new int[0];
    }

    public int docIdsToLoadFrom() {
        return 0;
    }

    public int docIdsToLoadSize() {
        return 0;
    }

    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        return null;
    }

    public void accessed(long accessTime) {
    }

    public long lastAccessTime() {
        return 0L;
    }

    public long keepAlive() {
        return 0L;
    }

    public void keepAlive(long keepAlive) {
    }

    public DfsSearchResult dfsResult() {
        return null;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    public FetchPhase fetchPhase() {
        return null;
    }

    public MappedFieldType smartNameFieldType(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().fullName(name);
        }
        return null;
    }

    public ObjectMapper getObjectMapper(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().getObjectMapper(name);
        }
        return null;
    }

    public void doClose() {
    }

    public Counter timeEstimateCounter() {
        return this.timeEstimateCounter;
    }

    public Profilers getProfilers() {
        return null;
    }

    public Map<Class<?>, Collector> queryCollectors() {
        return this.queryCollectors;
    }

    public QueryShardContext getQueryShardContext() {
        return this.queryShardContext;
    }

    public void setTask(SearchTask task) {
        this.task = task;
    }

    public SearchTask getTask() {
        return this.task;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }
}

