/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.SkipSection;

public class ClientYamlTestSection
implements Comparable<ClientYamlTestSection> {
    private final XContentLocation location;
    private final String name;
    private SkipSection skipSection;
    private final List<ExecutableSection> executableSections;

    public static ClientYamlTestSection parse(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        ClientYamlTestSection testSection = new ClientYamlTestSection(parser.getTokenLocation(), parser.currentName());
        try {
            parser.nextToken();
            testSection.setSkipSection(SkipSection.parseIfNext(parser));
            while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
                ParserUtils.advanceToFieldName(parser);
                testSection.addExecutableSection(ExecutableSection.parse(parser));
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new IllegalArgumentException("malformed section [" + testSection.getName() + "] expected [" + XContentParser.Token.END_OBJECT + "] but was [" + parser.currentToken() + "]");
            }
            parser.nextToken();
            return testSection;
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), "Error parsing test named [" + testSection.getName() + "]", (Throwable)e, new Object[0]);
        }
    }

    public ClientYamlTestSection(XContentLocation location, String name) {
        this.location = location;
        this.name = name;
        this.executableSections = new ArrayList<ExecutableSection>();
    }

    public XContentLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public SkipSection getSkipSection() {
        return this.skipSection;
    }

    public void setSkipSection(SkipSection skipSection) {
        this.skipSection = skipSection;
    }

    public List<ExecutableSection> getExecutableSections() {
        return this.executableSections;
    }

    public void addExecutableSection(ExecutableSection executableSection) {
        DoSection doSection;
        if (executableSection instanceof DoSection && !(doSection = (DoSection)executableSection).getExpectedWarningHeaders().isEmpty() && !this.skipSection.getFeatures().contains("warnings")) {
            throw new IllegalArgumentException("Attempted to add a [do] with a [warnings] section without a corresponding [skip] so runners that do not support the [warnings] section can skip the test at line [" + doSection.getLocation().lineNumber + "]");
        }
        this.executableSections.add(executableSection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientYamlTestSection that = (ClientYamlTestSection)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public int compareTo(ClientYamlTestSection o) {
        return this.name.compareTo(o.getName());
    }
}

