/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.SetupSection;
import org.elasticsearch.test.rest.yaml.section.TeardownSection;

public class ClientYamlTestSuite {
    private final String api;
    private final String name;
    private SetupSection setupSection;
    private TeardownSection teardownSection;
    private Set<ClientYamlTestSection> testSections = new TreeSet<ClientYamlTestSection>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientYamlTestSuite parse(String api, Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException(file.toAbsolutePath() + " is not a file");
        }
        String filename = file.getFileName().toString();
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            filename = filename.substring(0, i);
        }
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
            ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
            if (channel.size() == 0L) {
                throw new IllegalArgumentException("test suite file " + file.toString() + " is empty");
            }
            channel.read(bb, channel.size() - 1L);
            if (bb.get(0) != 10) {
                throw new IOException("test suite [" + api + "/" + filename + "] doesn't end with line feed (\\n)");
            }
        }
        try {
            var5_6 = null;
            try (XContentParser parser = YamlXContent.yamlXContent.createParser(ExecutableSection.XCONTENT_REGISTRY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Files.newInputStream(file, new OpenOption[0]));){
                ClientYamlTestSuite clientYamlTestSuite = ClientYamlTestSuite.parse(api, filename, parser);
                return clientYamlTestSuite;
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + api + "/" + filename, e);
        }
    }

    public static ClientYamlTestSuite parse(String api, String suiteName, XContentParser parser) throws IOException {
        parser.nextToken();
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT) : "expected token to be START_OBJECT but was " + parser.currentToken();
        ClientYamlTestSuite restTestSuite = new ClientYamlTestSuite(api, suiteName);
        restTestSuite.setSetupSection(SetupSection.parseIfNext(parser));
        restTestSuite.setTeardownSection(TeardownSection.parseIfNext(parser));
        while (parser.currentToken() != null || parser.nextToken() != null) {
            ClientYamlTestSection testSection = ClientYamlTestSection.parse(parser);
            if (restTestSuite.addTestSection(testSection)) continue;
            throw new ParsingException(testSection.getLocation(), "duplicate test section [" + testSection.getName() + "]", new Object[0]);
        }
        return restTestSuite;
    }

    public ClientYamlTestSuite(String api, String name) {
        this.api = api;
        this.name = name;
    }

    public String getApi() {
        return this.api;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.api + "/" + this.name;
    }

    public SetupSection getSetupSection() {
        return this.setupSection;
    }

    public void setSetupSection(SetupSection setupSection) {
        this.setupSection = setupSection;
    }

    public TeardownSection getTeardownSection() {
        return this.teardownSection;
    }

    public void setTeardownSection(TeardownSection teardownSection) {
        this.teardownSection = teardownSection;
    }

    public boolean addTestSection(ClientYamlTestSection testSection) {
        return this.testSections.add(testSection);
    }

    public List<ClientYamlTestSection> getTestSections() {
        return new ArrayList<ClientYamlTestSection>(this.testSections);
    }
}

