/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.transport.nio.AcceptingSelector;
import org.elasticsearch.transport.nio.AcceptorEventHandler;
import org.elasticsearch.transport.nio.ESSelector;
import org.elasticsearch.transport.nio.RoundRobinSupplier;
import org.elasticsearch.transport.nio.SocketEventHandler;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.channel.ChannelFactory;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;

public class NioGroup
implements AutoCloseable {
    private final ArrayList<AcceptingSelector> acceptors;
    private final RoundRobinSupplier<AcceptingSelector> acceptorSupplier;
    private final ArrayList<SocketSelector> socketSelectors;
    private final RoundRobinSupplier<SocketSelector> socketSelectorSupplier;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);

    public NioGroup(Logger logger, ThreadFactory acceptorThreadFactory, int acceptorCount, BiFunction<Logger, Supplier<SocketSelector>, AcceptorEventHandler> acceptorEventHandlerFunction, ThreadFactory socketSelectorThreadFactory, int socketSelectorCount, Function<Logger, SocketEventHandler> socketEventHandlerFunction) throws IOException {
        this.acceptors = new ArrayList(acceptorCount);
        this.socketSelectors = new ArrayList(socketSelectorCount);
        try {
            int i;
            for (i = 0; i < socketSelectorCount; ++i) {
                SocketSelector selector = new SocketSelector(socketEventHandlerFunction.apply(logger));
                this.socketSelectors.add(selector);
            }
            NioGroup.startSelectors(this.socketSelectors, socketSelectorThreadFactory);
            for (i = 0; i < acceptorCount; ++i) {
                SocketSelector[] childSelectors = this.socketSelectors.toArray(new SocketSelector[this.socketSelectors.size()]);
                RoundRobinSupplier<SocketSelector> selectorSupplier = new RoundRobinSupplier<SocketSelector>(childSelectors);
                AcceptingSelector acceptor = new AcceptingSelector(acceptorEventHandlerFunction.apply(logger, selectorSupplier));
                this.acceptors.add(acceptor);
            }
            NioGroup.startSelectors(this.acceptors, acceptorThreadFactory);
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
        this.socketSelectorSupplier = new RoundRobinSupplier<SocketSelector>(this.socketSelectors.toArray(new SocketSelector[this.socketSelectors.size()]));
        this.acceptorSupplier = new RoundRobinSupplier<AcceptingSelector>(this.acceptors.toArray(new AcceptingSelector[this.acceptors.size()]));
    }

    public <S extends NioServerSocketChannel> S bindServerChannel(InetSocketAddress address, ChannelFactory<S, ?> factory) throws IOException {
        this.ensureOpen();
        if (this.acceptors.isEmpty()) {
            throw new IllegalArgumentException("There are no acceptors configured. Without acceptors, server channels are not supported.");
        }
        return factory.openNioServerSocketChannel(address, this.acceptorSupplier.get());
    }

    public <S extends NioSocketChannel> S openChannel(InetSocketAddress address, ChannelFactory<?, S> factory) throws IOException {
        this.ensureOpen();
        return factory.openNioChannel(address, this.socketSelectorSupplier.get());
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen.compareAndSet(true, false)) {
            IOUtils.close((Iterable)Stream.concat(this.acceptors.stream(), this.socketSelectors.stream()).collect(Collectors.toList()));
        }
    }

    private static <S extends ESSelector> void startSelectors(Iterable<S> selectors, ThreadFactory threadFactory) {
        for (ESSelector acceptor : selectors) {
            if (acceptor.isRunning()) continue;
            threadFactory.newThread(acceptor::runLoop).start();
            acceptor.isRunningFuture().actionGet();
        }
    }

    private void ensureOpen() {
        if (!this.isOpen.get()) {
            throw new IllegalStateException("NioGroup is closed.");
        }
    }
}

