/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsearch.common.bytes.ByteBufferReference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.transport.nio.InboundChannelBuffer;
import org.elasticsearch.transport.nio.TcpReadHandler;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.ReadContext;
import org.elasticsearch.transport.nio.channel.TcpFrameDecoder;
import org.elasticsearch.transport.nio.channel.TcpNioSocketChannel;

public class TcpReadContext
implements ReadContext {
    private final TcpReadHandler handler;
    private final TcpNioSocketChannel channel;
    private final InboundChannelBuffer channelBuffer;
    private final TcpFrameDecoder frameDecoder = new TcpFrameDecoder();

    public TcpReadContext(NioSocketChannel channel, TcpReadHandler handler, InboundChannelBuffer channelBuffer) {
        this.handler = handler;
        this.channel = (TcpNioSocketChannel)channel;
        this.channelBuffer = channelBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        BytesReference message;
        int bytesRead;
        if (this.channelBuffer.getRemaining() == 0L) {
            this.channelBuffer.ensureCapacity(this.channelBuffer.getCapacity() + 1L);
        }
        if ((bytesRead = this.channel.read(this.channelBuffer)) == -1) {
            return bytesRead;
        }
        while ((message = this.frameDecoder.decode(TcpReadContext.toBytesReference(this.channelBuffer))) != null) {
            int messageLengthWithHeader = message.length();
            try {
                BytesReference messageWithoutHeader = message.slice(6, message.length() - 6);
                if (messageLengthWithHeader == 6) continue;
                this.handler.handleMessage(messageWithoutHeader, this.channel, messageWithoutHeader.length());
            }
            catch (Exception e) {
                this.handler.handleException(this.channel, e);
            }
            finally {
                this.channelBuffer.release(messageLengthWithHeader);
            }
        }
        return bytesRead;
    }

    @Override
    public void close() {
        this.channelBuffer.close();
    }

    private static BytesReference toBytesReference(InboundChannelBuffer channelBuffer) {
        ByteBuffer[] writtenToBuffers = channelBuffer.sliceBuffersTo(channelBuffer.getIndex());
        ByteBufferReference[] references = new ByteBufferReference[writtenToBuffers.length];
        for (int i = 0; i < references.length; ++i) {
            references[i] = new ByteBufferReference(writtenToBuffers[i]);
        }
        return new CompositeBytesReference((BytesReference[])references);
    }
}

