/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.WriteOperation;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.WriteContext;

public class TcpWriteContext
implements WriteContext {
    private final NioSocketChannel channel;
    private final LinkedList<WriteOperation> queued = new LinkedList();

    public TcpWriteContext(NioSocketChannel channel) {
        this.channel = channel;
    }

    @Override
    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        if (!this.channel.isWritable()) {
            listener.onFailure((Exception)new ClosedChannelException());
            return;
        }
        WriteOperation writeOperation = new WriteOperation(this.channel, reference, listener);
        SocketSelector selector = this.channel.getSelector();
        if (!selector.isOnCurrentThread()) {
            selector.queueWrite(writeOperation);
            return;
        }
        selector.queueWriteInChannelBuffer(writeOperation);
    }

    @Override
    public void queueWriteOperations(WriteOperation writeOperation) {
        assert (this.channel.getSelector().isOnCurrentThread()) : "Must be on selector thread to queue writes";
        this.queued.add(writeOperation);
    }

    @Override
    public void flushChannel() throws IOException {
        assert (this.channel.getSelector().isOnCurrentThread()) : "Must be on selector thread to flush writes";
        int ops = this.queued.size();
        if (ops == 1) {
            this.singleFlush(this.queued.pop());
        } else if (ops > 1) {
            this.multiFlush();
        }
    }

    @Override
    public boolean hasQueuedWriteOps() {
        assert (this.channel.getSelector().isOnCurrentThread()) : "Must be on selector thread to access queued writes";
        return !this.queued.isEmpty();
    }

    @Override
    public void clearQueuedWriteOps(Exception e) {
        assert (this.channel.getSelector().isOnCurrentThread()) : "Must be on selector thread to clear queued writes";
        for (WriteOperation op : this.queued) {
            this.channel.getSelector().executeFailedListener(op.getListener(), e);
        }
        this.queued.clear();
    }

    private void singleFlush(WriteOperation headOp) throws IOException {
        try {
            headOp.flush();
        }
        catch (IOException e) {
            this.channel.getSelector().executeFailedListener(headOp.getListener(), e);
            throw e;
        }
        if (headOp.isFullyFlushed()) {
            this.channel.getSelector().executeListener(headOp.getListener(), null);
        } else {
            this.queued.push(headOp);
        }
    }

    private void multiFlush() throws IOException {
        boolean lastOpCompleted = true;
        while (lastOpCompleted && !this.queued.isEmpty()) {
            WriteOperation op = this.queued.pop();
            this.singleFlush(op);
            lastOpCompleted = op.isFullyFlushed();
        }
    }
}

