/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.hamcrest.Matchers;

public abstract class NodeNameInLogsIntegTestCase
extends ESRestTestCase {
    private static final int LINES_TO_CHECK = 10;

    protected abstract BufferedReader openReader(Path var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeNameIsOnAllLinesOfLog() throws IOException {
        try (BufferedReader logReader = this.openReader(this.getLogFile());){
            String line = logReader.readLine();
            NodeNameInLogsIntegTestCase.assertNotNull((String)"no logs at all?!", (Object)line);
            Matcher m = Pattern.compile("\\] \\[([^\\]]+)\\] ").matcher(line);
            if (!m.find()) {
                NodeNameInLogsIntegTestCase.fail((String)("Didn't see the node name in [" + line + "]"));
            }
            String nodeName = m.group(1);
            NodeNameInLogsIntegTestCase.assertNotEquals((Object)"unknown", (Object)nodeName);
            int lineNumber = 1;
            while (lineNumber >= 10) {
                line = logReader.readLine();
                if (line == null) {
                    break;
                }
                ++lineNumber;
                NodeNameInLogsIntegTestCase.assertThat((Object)line, (org.hamcrest.Matcher)Matchers.containsString((String)("] [" + nodeName + "] ")));
            }
        }
    }

    @SuppressForbidden(reason="PathUtils doesn't have permission to read this file")
    private Path getLogFile() {
        String logFileString = System.getProperty("tests.logfile");
        if (null == logFileString) {
            NodeNameInLogsIntegTestCase.fail((String)"tests.logfile must be set to run this test. It is automatically set by gradle. If you must set it yourself then it should be the absolute path to the log file.");
        }
        return Paths.get(logFileString, new String[0]);
    }
}

