/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;

public class ClientYamlSuiteRestApiParser {
    private static final ObjectParser<Parameter, Void> PARAMETER_PARSER = new ObjectParser("parameter", true, () -> new Parameter());

    public ClientYamlSuiteRestApi parse(String location, XContentParser parser) throws IOException {
        while (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
        }
        String apiName = parser.currentName();
        if (!location.endsWith(apiName + ".json")) {
            throw new IllegalArgumentException("API [" + apiName + "] should have the same name as its file [" + location + "]");
        }
        ClientYamlSuiteRestApi restApi = new ClientYamlSuiteRestApi(location, apiName);
        int level = -1;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT || level >= 0) {
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                if ("methods".equals(parser.currentName())) {
                    parser.nextToken();
                    while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                        String method = parser.text();
                        if (restApi.getMethods().contains(method)) {
                            throw new IllegalArgumentException("Found duplicate method [" + method + "]");
                        }
                        restApi.addMethod(method);
                    }
                }
                if ("url".equals(parser.currentName())) {
                    String currentFieldName = "url";
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                        }
                        if (parser.currentToken() == XContentParser.Token.START_ARRAY && "paths".equals(currentFieldName)) {
                            while (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                                String path = parser.text();
                                if (restApi.getPaths().contains(path)) {
                                    throw new IllegalArgumentException("Found duplicate path [" + path + "]");
                                }
                                restApi.addPath(path);
                            }
                        }
                        if (parser.currentToken() == XContentParser.Token.START_OBJECT && "parts".equals(currentFieldName)) {
                            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                                String part = parser.currentName();
                                if (restApi.getPathParts().containsKey(part)) {
                                    throw new IllegalArgumentException("Found duplicate part [" + part + "]");
                                }
                                parser.nextToken();
                                if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                                    throw new IllegalArgumentException("Expected parts field in rest api definition to contain an object");
                                }
                                restApi.addPathPart(part, ((Parameter)PARAMETER_PARSER.parse(parser, null)).isRequired());
                            }
                        }
                        if (parser.currentToken() != XContentParser.Token.START_OBJECT || !"params".equals(currentFieldName)) continue;
                        while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                            String param = parser.currentName();
                            if (restApi.getParams().containsKey(param)) {
                                throw new IllegalArgumentException("Found duplicate param [" + param + "]");
                            }
                            parser.nextToken();
                            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                                throw new IllegalArgumentException("Expected params field in rest api definition to contain an object");
                            }
                            restApi.addParam(param, ((Parameter)PARAMETER_PARSER.parse(parser, null)).isRequired());
                        }
                    }
                }
                if ("body".equals(parser.currentName())) {
                    parser.nextToken();
                    if (parser.currentToken() != XContentParser.Token.VALUE_NULL) {
                        boolean requiredFound = false;
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (parser.currentToken() != XContentParser.Token.FIELD_NAME || !"required".equals(parser.currentName())) continue;
                            requiredFound = true;
                            parser.nextToken();
                            if (parser.booleanValue()) {
                                restApi.setBodyRequired();
                                continue;
                            }
                            restApi.setBodyOptional();
                        }
                        if (!requiredFound) {
                            restApi.setBodyOptional();
                        }
                    }
                }
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                ++level;
            }
            if (parser.currentToken() != XContentParser.Token.END_OBJECT) continue;
            --level;
        }
        parser.nextToken();
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT) : "Expected [END_OBJECT] but was [" + parser.currentToken() + "]";
        parser.nextToken();
        return restApi;
    }

    static {
        PARAMETER_PARSER.declareBoolean(Parameter::setRequired, new ParseField("required", new String[0]));
    }

    private static class Parameter {
        private boolean required;

        private Parameter() {
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }
}

