/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportStats;

public final class StubbableTransport
implements Transport {
    private final ConcurrentHashMap<TransportAddress, SendRequestBehavior> sendBehaviors = new ConcurrentHashMap();
    private final ConcurrentHashMap<TransportAddress, OpenConnectionBehavior> connectBehaviors = new ConcurrentHashMap();
    private volatile SendRequestBehavior defaultSendRequest = null;
    private volatile OpenConnectionBehavior defaultConnectBehavior = null;
    private final Transport delegate;

    public StubbableTransport(Transport transport) {
        this.delegate = transport;
    }

    boolean setDefaultSendBehavior(SendRequestBehavior sendBehavior) {
        SendRequestBehavior prior = this.defaultSendRequest;
        this.defaultSendRequest = sendBehavior;
        return prior == null;
    }

    public boolean setDefaultConnectBehavior(OpenConnectionBehavior openConnectionBehavior) {
        OpenConnectionBehavior prior = this.defaultConnectBehavior;
        this.defaultConnectBehavior = openConnectionBehavior;
        return prior == null;
    }

    boolean addSendBehavior(TransportAddress transportAddress, SendRequestBehavior sendBehavior) {
        return this.sendBehaviors.put(transportAddress, sendBehavior) == null;
    }

    boolean addConnectBehavior(TransportAddress transportAddress, OpenConnectionBehavior connectBehavior) {
        return this.connectBehaviors.put(transportAddress, connectBehavior) == null;
    }

    void clearBehaviors() {
        this.defaultSendRequest = null;
        this.sendBehaviors.clear();
        this.defaultConnectBehavior = null;
        this.connectBehaviors.clear();
    }

    void clearBehavior(TransportAddress transportAddress) {
        SendRequestBehavior behavior = this.sendBehaviors.remove(transportAddress);
        if (behavior != null) {
            behavior.clearCallback();
        }
        this.connectBehaviors.remove(transportAddress);
    }

    Transport getDelegate() {
        return this.delegate;
    }

    public void addMessageListener(TransportMessageListener listener) {
        this.delegate.addMessageListener(listener);
    }

    public boolean removeMessageListener(TransportMessageListener listener) {
        return this.delegate.removeMessageListener(listener);
    }

    public <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        this.delegate.registerRequestHandler(reg);
    }

    public RequestHandlerRegistry getRequestHandler(String action) {
        return this.delegate.getRequestHandler(action);
    }

    public BoundTransportAddress boundAddress() {
        return this.delegate.boundAddress();
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws UnknownHostException {
        return this.delegate.addressesFromString(address, perAddressLimit);
    }

    public List<String> getLocalAddresses() {
        return this.delegate.getLocalAddresses();
    }

    public Releasable openConnection(DiscoveryNode node, ConnectionProfile profile, final ActionListener<Transport.Connection> listener) {
        TransportAddress address = node.getAddress();
        OpenConnectionBehavior behavior = this.connectBehaviors.getOrDefault(address, this.defaultConnectBehavior);
        ActionListener<Transport.Connection> wrappedListener = new ActionListener<Transport.Connection>(){

            public void onResponse(Transport.Connection connection) {
                listener.onResponse((Object)new WrappedConnection(connection));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        if (behavior == null) {
            return this.delegate.openConnection(node, profile, (ActionListener)wrappedListener);
        }
        return behavior.openConnection(this.delegate, node, profile, wrappedListener);
    }

    public TransportStats getStats() {
        return this.delegate.getStats();
    }

    public Transport.ResponseHandlers getResponseHandlers() {
        return this.delegate.getResponseHandlers();
    }

    public Lifecycle.State lifecycleState() {
        return this.delegate.lifecycleState();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.delegate.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.delegate.removeLifecycleListener(listener);
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void close() {
        this.delegate.close();
    }

    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return this.delegate.profileBoundAddresses();
    }

    @FunctionalInterface
    public static interface SendRequestBehavior {
        public void sendRequest(Transport.Connection var1, long var2, String var4, TransportRequest var5, TransportRequestOptions var6) throws IOException;

        default public void clearCallback() {
        }
    }

    @FunctionalInterface
    public static interface OpenConnectionBehavior {
        public Releasable openConnection(Transport var1, DiscoveryNode var2, ConnectionProfile var3, ActionListener<Transport.Connection> var4);
    }

    public class WrappedConnection
    implements Transport.Connection {
        private final Transport.Connection connection;

        private WrappedConnection(Transport.Connection connection) {
            this.connection = connection;
        }

        public DiscoveryNode getNode() {
            return this.connection.getNode();
        }

        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            TransportAddress address = this.connection.getNode().getAddress();
            SendRequestBehavior behavior = StubbableTransport.this.sendBehaviors.getOrDefault(address, StubbableTransport.this.defaultSendRequest);
            if (behavior == null) {
                this.connection.sendRequest(requestId, action, request, options);
            } else {
                behavior.sendRequest(this.connection, requestId, action, request, options);
            }
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        public boolean isClosed() {
            return this.connection.isClosed();
        }

        public Version getVersion() {
            return this.connection.getVersion();
        }

        public Object getCacheKey() {
            return this.connection.getCacheKey();
        }

        public void close() {
            this.connection.close();
        }

        public Transport.Connection getConnection() {
            return this.connection;
        }
    }
}

