/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MapperTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractNumericFieldMapperTestCase
extends MapperTestCase {
    protected abstract Set<String> types();

    protected abstract Set<String> wholeTypes();

    public final void testTypesAndWholeTypes() {
        for (String wholeType : this.wholeTypes()) {
            AbstractNumericFieldMapperTestCase.assertThat(this.types(), (Matcher)Matchers.hasItem((Object)wholeType));
        }
    }

    public final void testDefaults() throws Exception {
        for (String type : this.types()) {
            this.doTestDefaults(type);
        }
    }

    protected abstract void doTestDefaults(String var1) throws Exception;

    public final void testNotIndexed() throws Exception {
        for (String type : this.types()) {
            this.doTestNotIndexed(type);
        }
    }

    protected abstract void doTestNotIndexed(String var1) throws Exception;

    public final void testNoDocValues() throws Exception {
        for (String type : this.types()) {
            this.doTestNoDocValues(type);
        }
    }

    protected abstract void doTestNoDocValues(String var1) throws Exception;

    public final void testStore() throws Exception {
        for (String type : this.types()) {
            this.doTestStore(type);
        }
    }

    protected abstract void doTestStore(String var1) throws Exception;

    public final void testCoerce() throws Exception {
        for (String type : this.types()) {
            this.doTestCoerce(type);
        }
    }

    protected abstract void doTestCoerce(String var1) throws IOException;

    public final void testDecimalCoerce() throws Exception {
        for (String type : this.wholeTypes()) {
            this.doTestDecimalCoerce(type);
        }
    }

    protected abstract void doTestDecimalCoerce(String var1) throws IOException;

    public final void testNullValue() throws IOException {
        for (String type : this.types()) {
            this.doTestNullValue(type);
        }
    }

    protected abstract void doTestNullValue(String var1) throws IOException;

    @Override
    protected void randomFetchTestFieldConfig(XContentBuilder b) throws IOException {
        b.field("type", AbstractNumericFieldMapperTestCase.randomFrom(this.types()));
    }
}

