/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Set;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.test.ESTestCase;
import org.mockito.Mockito;

public abstract class FieldTypeTestCase
extends ESTestCase {
    public static final SearchExecutionContext MOCK_CONTEXT = FieldTypeTestCase.createMockSearchExecutionContext(true);
    public static final SearchExecutionContext MOCK_CONTEXT_DISALLOW_EXPENSIVE = FieldTypeTestCase.createMockSearchExecutionContext(false);

    protected SearchExecutionContext randomMockContext() {
        return FieldTypeTestCase.randomFrom(MOCK_CONTEXT, MOCK_CONTEXT_DISALLOW_EXPENSIVE);
    }

    private static SearchExecutionContext createMockSearchExecutionContext(boolean allowExpensiveQueries) {
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.allowExpensiveQueries()).thenReturn((Object)allowExpensiveQueries);
        Mockito.when((Object)searchExecutionContext.isSourceEnabled()).thenReturn((Object)true);
        SourceLookup sourceLookup = (SourceLookup)Mockito.mock(SourceLookup.class);
        SearchLookup searchLookup = (SearchLookup)Mockito.mock(SearchLookup.class);
        Mockito.when((Object)searchLookup.source()).thenReturn((Object)sourceLookup);
        Mockito.when((Object)searchExecutionContext.lookup()).thenReturn((Object)searchLookup);
        return searchExecutionContext;
    }

    public static java.util.List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue) throws IOException {
        return FieldTypeTestCase.fetchSourceValue(fieldType, sourceValue, null);
    }

    public static java.util.List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue, String format) throws IOException {
        String field = fieldType.name();
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn((Object)Set.of((Object)field));
        ValueFetcher fetcher = fieldType.valueFetcher(searchExecutionContext, format);
        SourceLookup lookup = new SourceLookup();
        lookup.setSource(Collections.singletonMap(field, sourceValue));
        return fetcher.fetchValues(lookup);
    }

    public static java.util.List<?> fetchSourceValues(MappedFieldType fieldType, Object ... values) throws IOException {
        String field = fieldType.name();
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn(Collections.singleton(field));
        ValueFetcher fetcher = fieldType.valueFetcher(searchExecutionContext, null);
        SourceLookup lookup = new SourceLookup();
        lookup.setSource(Collections.singletonMap(field, List.of((Object[])values)));
        return fetcher.fetchValues(lookup);
    }
}

