/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Set;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentLeafReader;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.mockito.Mockito;

public abstract class MapperTestCase
extends MapperServiceTestCase {
    protected abstract void minimalMapping(XContentBuilder var1) throws IOException;

    protected void writeField(XContentBuilder builder) throws IOException {
        builder.field("field");
        builder.value(this.getSampleValueForDocument());
    }

    protected abstract Object getSampleValueForDocument();

    protected Object getSampleValueForQuery() {
        return this.getSampleValueForDocument();
    }

    public final void testExistsQueryMinimalMapping() throws IOException {
        MapperService mapperService = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertExistsQuery(mapperService);
        this.assertParseMinimalWarnings();
    }

    protected void assertExistsQuery(MapperService mapperService) throws IOException {
        LuceneDocument fields = mapperService.documentMapper().parse(this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField))).rootDoc();
        SearchExecutionContext searchExecutionContext = this.createSearchExecutionContext(mapperService);
        MappedFieldType fieldType = mapperService.fieldType("field");
        Query query = fieldType.existsQuery(searchExecutionContext);
        this.assertExistsQuery(fieldType, query, fields);
    }

    protected void assertExistsQuery(MappedFieldType fieldType, Query query, LuceneDocument fields) {
        if (fieldType.hasDocValues()) {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(DocValuesFieldExistsQuery.class));
            DocValuesFieldExistsQuery fieldExistsQuery = (DocValuesFieldExistsQuery)query;
            MapperTestCase.assertEquals((Object)"field", (Object)fieldExistsQuery.getField());
            MapperTestCase.assertDocValuesField(fields, "field");
            MapperTestCase.assertNoFieldNamesField(fields);
        } else if (fieldType.getTextSearchInfo().hasNorms()) {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(NormsFieldExistsQuery.class));
            NormsFieldExistsQuery normsFieldExistsQuery = (NormsFieldExistsQuery)query;
            MapperTestCase.assertEquals((Object)"field", (Object)normsFieldExistsQuery.getField());
            MapperTestCase.assertHasNorms(fields, "field");
            MapperTestCase.assertNoDocValuesField(fields, "field");
            MapperTestCase.assertNoFieldNamesField(fields);
        } else {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(TermQuery.class));
            TermQuery termQuery = (TermQuery)query;
            MapperTestCase.assertEquals((Object)"_field_names", (Object)termQuery.getTerm().field());
            MapperTestCase.assertEquals((Object)"field", (Object)termQuery.getTerm().text());
            MapperTestCase.assertNoDocValuesField(fields, "field");
            if (fieldType.isSearchable() || fieldType.isStored()) {
                MapperTestCase.assertNotNull((Object)fields.getField("_field_names"));
            } else {
                MapperTestCase.assertNoFieldNamesField(fields);
            }
        }
    }

    protected static void assertNoFieldNamesField(LuceneDocument fields) {
        MapperTestCase.assertNull((Object)fields.getField("_field_names"));
    }

    protected static void assertHasNorms(LuceneDocument doc, String field) {
        IndexableField[] fields;
        for (IndexableField indexableField : fields = doc.getFields(field)) {
            IndexableFieldType indexableFieldType = indexableField.fieldType();
            if (indexableFieldType.indexOptions() == IndexOptions.NONE) continue;
            MapperTestCase.assertFalse((boolean)indexableFieldType.omitNorms());
            return;
        }
        MapperTestCase.fail((String)("field [" + field + "] should be indexed but it isn't"));
    }

    protected static void assertDocValuesField(LuceneDocument doc, String field) {
        IndexableField[] fields;
        for (IndexableField indexableField : fields = doc.getFields(field)) {
            if (indexableField.fieldType().docValuesType().equals((Object)DocValuesType.NONE)) continue;
            return;
        }
        MapperTestCase.fail((String)("doc_values not present for field [" + field + "]"));
    }

    protected static void assertNoDocValuesField(LuceneDocument doc, String field) {
        IndexableField[] fields;
        for (IndexableField indexableField : fields = doc.getFields(field)) {
            MapperTestCase.assertEquals((Object)DocValuesType.NONE, (Object)indexableField.fieldType().docValuesType());
        }
    }

    public final void testEmptyName() {
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("");
            this.minimalMapping((XContentBuilder)b);
            b.endObject();
        }))));
        MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"name cannot be empty string"));
        this.assertParseMinimalWarnings();
    }

    public final void testMinimalSerializesToItself() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, ToXContent.EMPTY_PARAMS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, ToXContent.EMPTY_PARAMS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
        this.assertParseMinimalWarnings();
    }

    public void testMinimalToMaximal() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, INCLUDE_DEFAULTS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, INCLUDE_DEFAULTS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
        this.assertParseMaximalWarnings();
    }

    protected final void assertParseMinimalWarnings() {
        String[] warnings = this.getParseMinimalWarnings();
        if (warnings.length > 0) {
            this.assertWarnings(warnings);
        }
    }

    protected final void assertParseMaximalWarnings() {
        String[] warnings = this.getParseMaximalWarnings();
        if (warnings.length > 0) {
            this.assertWarnings(warnings);
        }
    }

    protected String[] getParseMinimalWarnings() {
        return Strings.EMPTY_ARRAY;
    }

    protected String[] getParseMaximalWarnings() {
        return Strings.EMPTY_ARRAY;
    }

    protected boolean supportsMeta() {
        return true;
    }

    protected void metaMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    public void testMeta() throws IOException {
        MapperTestCase.assumeTrue((String)"Field doesn't support meta", (boolean)this.supportsMeta());
        XContentBuilder mapping = this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("foo", "bar"));
        }));
        MapperService mapperService = this.createMapperService(mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::metaMapping));
        this.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("baz", "quux"));
        }));
        this.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
    }

    protected String typeName() throws IOException {
        MapperService ms = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        return ms.fieldType("field").typeName();
    }

    public final void testDeprecatedBoost() throws IOException {
        MapperService ms = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("boost", 2.0);
        })));
        String type = this.typeName();
        String[] warnings = Strings.concatStringArrays((String[])this.getParseMinimalWarnings(), (String[])new String[]{"Parameter [boost] on field [field] is deprecated and will be removed in 8.0", "Parameter [boost] has no effect on type [" + type + "] and will be removed in future"});
        this.allowedWarnings(warnings);
    }

    protected final List<?> fetchFromDocValues(MapperService mapperService, MappedFieldType ft, DocValueFormat format, Object sourceValue) throws IOException {
        SetOnce result = new SetOnce();
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentMapper().parse(this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), sourceValue)))).rootDoc())), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)iw -> {
            SearchLookup lookup = new SearchLookup(arg_0 -> ((MapperService)mapperService).fieldType(arg_0), this.fieldDataLookup());
            DocValueFetcher valueFetcher = new DocValueFetcher(format, lookup.getForField(ft));
            IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)iw);
            LeafReaderContext context = (LeafReaderContext)searcher.getIndexReader().leaves().get(0);
            lookup.source().setSegmentAndDocument(context, 0);
            valueFetcher.setNextReader(context);
            result.set((Object)valueFetcher.fetchValues(lookup.source()));
        }));
        return (List)result.get();
    }

    protected abstract void registerParameters(ParameterChecker var1) throws IOException;

    public void testUpdates() throws IOException {
        MapperService mapperService;
        ParameterChecker checker = new ParameterChecker();
        this.registerParameters(checker);
        for (UpdateCheck updateCheck : checker.updateChecks) {
            mapperService = this.createMapperService(updateCheck.init);
            this.merge(mapperService, updateCheck.update);
            FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
            this.merge(mapperService, updateCheck.update);
            mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
        }
        for (String param : checker.conflictChecks.keySet()) {
            mapperService = this.createMapperService(checker.conflictChecks.get((Object)param).init);
            this.merge(mapperService, checker.conflictChecks.get((Object)param).init);
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, (String)("No conflict when updating parameter [" + param + "]"), () -> this.merge(mapperService, checker.conflictChecks.get((Object)param).update));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)("Cannot update parameter [" + param + "]")), (Matcher)Matchers.containsString((String)("different [" + param + "]"))));
        }
        this.assertParseMaximalWarnings();
    }

    public final void testTextSearchInfoConsistency() throws IOException {
        MapperService mapperService = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        MappedFieldType fieldType = mapperService.fieldType("field");
        if (fieldType.getTextSearchInfo() == TextSearchInfo.NONE) {
            MapperTestCase.expectThrows(IllegalArgumentException.class, () -> fieldType.termQuery(null, null));
        } else {
            SearchExecutionContext searchExecutionContext = this.createSearchExecutionContext(mapperService);
            MapperTestCase.assertNotNull((Object)fieldType.termQuery(this.getSampleValueForQuery(), searchExecutionContext));
        }
        this.assertSearchable(fieldType);
        this.assertParseMinimalWarnings();
    }

    protected void assertSearchable(MappedFieldType fieldType) {
        MapperTestCase.assertEquals((Object)fieldType.isSearchable(), (Object)(fieldType.getTextSearchInfo() != TextSearchInfo.NONE ? 1 : 0));
    }

    public final void testFetch() throws IOException {
        MapperService mapperService = this.randomFetchTestMapper();
        try {
            MappedFieldType ft = mapperService.fieldType("field");
            this.assertFetch(mapperService, "field", this.generateRandomInputValue(ft), this.randomFetchTestFormat());
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testFetchMany() throws IOException {
        MapperService mapperService = this.randomFetchTestMapper();
        try {
            MappedFieldType ft = mapperService.fieldType("field");
            int count = MapperTestCase.between(2, 10);
            ArrayList<Object> values = new ArrayList<Object>(count);
            while (values.size() < count) {
                values.add(this.generateRandomInputValue(ft));
            }
            this.assertFetch(mapperService, "field", values, this.randomFetchTestFormat());
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    protected final MapperService randomFetchTestMapper() throws IOException {
        return this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            this.randomFetchTestFieldConfig((XContentBuilder)b);
            b.endObject();
        })));
    }

    protected void randomFetchTestFieldConfig(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    protected String randomFetchTestFormat() {
        return null;
    }

    protected abstract Object generateRandomInputValue(MappedFieldType var1);

    protected void assertFetch(MapperService mapperService, String field, Object value, String format) throws IOException {
        MappedFieldType ft = mapperService.fieldType(field);
        SourceToParse source = this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), value)));
        DocValueFetcher docValueFetcher = new DocValueFetcher(ft.docValueFormat(format, null), ft.fielddataBuilder("test", () -> null).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()));
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn((Object)Set.of((Object)field));
        Mockito.when((Object)searchExecutionContext.getForField(ft)).thenAnswer(inv -> this.fieldDataLookup().apply(ft, () -> {
            throw new UnsupportedOperationException();
        }));
        ValueFetcher nativeFetcher = ft.valueFetcher(searchExecutionContext, format);
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocuments((Iterable)doc.docs())), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)arg_0 -> this.lambda$assertFetch$17((ValueFetcher)docValueFetcher, nativeFetcher, value, arg_0)));
    }

    protected boolean dedupAfterFetch() {
        return false;
    }

    protected boolean supportsSearchLookup() {
        return true;
    }

    public final void testIndexTimeFieldData() throws IOException {
        MapperTestCase.assumeTrue((String)"Field type does not support access via search lookup", (boolean)this.supportsSearchLookup());
        MapperService mapperService = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertParseMinimalWarnings();
        MappedFieldType fieldType = mapperService.fieldType("field");
        if (!fieldType.isAggregatable()) {
            return;
        }
        SourceToParse source = this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField));
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)ir -> {
            LeafReaderContext ctx = (LeafReaderContext)ir.leaves().get(0);
            ScriptDocValues fieldData = fieldType.fielddataBuilder("test", () -> {
                throw new UnsupportedOperationException();
            }).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()).load(ctx).getScriptValues();
            fieldData.setNextDocId(0);
            DocumentLeafReader reader = new DocumentLeafReader(doc.rootDoc(), Collections.emptyMap());
            ScriptDocValues indexData = fieldType.fielddataBuilder("test", () -> {
                throw new UnsupportedOperationException();
            }).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()).load(reader.getContext()).getScriptValues();
            indexData.setNextDocId(0);
            MapperTestCase.assertThat((Object)fieldData, (Matcher)Matchers.equalTo((Object)indexData));
        }));
    }

    protected boolean supportsStoredFields() {
        return true;
    }

    protected void minimalStoreMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
        b.field("store", true);
    }

    public final void testIndexTimeStoredFieldsAccess() throws IOException {
        MapperTestCase.assumeTrue((String)"Field type does not support stored fields", (boolean)this.supportsStoredFields());
        MapperService mapperService = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalStoreMapping)));
        this.assertParseMinimalWarnings();
        MappedFieldType fieldType = mapperService.fieldType("field");
        SourceToParse source = this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField));
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        SearchLookup lookup = new SearchLookup(f -> fieldType, (f, s) -> {
            throw new UnsupportedOperationException();
        });
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)ir -> {
            LeafReaderContext ctx = (LeafReaderContext)ir.leaves().get(0);
            LeafStoredFieldsLookup storedFields = lookup.getLeafSearchLookup(ctx).fields();
            storedFields.setDocument(0);
            DocumentLeafReader reader = new DocumentLeafReader(doc.rootDoc(), Collections.emptyMap());
            LeafStoredFieldsLookup indexStoredFields = lookup.getLeafSearchLookup(reader.getContext()).fields();
            indexStoredFields.setDocument(0);
            MapperTestCase.assertThat((Object)storedFields.get((Object)"field").getValues(), (Matcher)Matchers.equalTo((Object)indexStoredFields.get((Object)"field").getValues()));
        }));
    }

    private BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup() {
        return (mft, lookupSource) -> mft.fielddataBuilder("test", lookupSource).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
    }

    public final void testNullInput() throws Exception {
        DocumentMapper mapper = this.createDocumentMapper(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        if (this.allowsNullValues()) {
            ParsedDocument doc = mapper.parse(this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field"))));
            MapperTestCase.assertThat((Object)((LuceneDocument)doc.docs().get(0)).getFields("field").length, (Matcher)Matchers.equalTo((Object)0));
            MapperTestCase.assertThat((Object)((LuceneDocument)doc.docs().get(0)).getFields("_field_names").length, (Matcher)Matchers.equalTo((Object)0));
        } else {
            MapperTestCase.expectThrows(MapperParsingException.class, () -> mapper.parse(this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field")))));
        }
        this.assertWarnings(this.getParseMinimalWarnings());
    }

    protected boolean allowsNullValues() {
        return true;
    }

    private /* synthetic */ void lambda$assertFetch$17(ValueFetcher docValueFetcher, ValueFetcher nativeFetcher, Object value, IndexReader ir) throws IOException {
        SourceLookup sourceLookup = new SourceLookup();
        sourceLookup.setSegmentAndDocument((LeafReaderContext)ir.leaves().get(0), 0);
        docValueFetcher.setNextReader((LeafReaderContext)ir.leaves().get(0));
        nativeFetcher.setNextReader((LeafReaderContext)ir.leaves().get(0));
        List fromDocValues = docValueFetcher.fetchValues(sourceLookup);
        List fromNative = nativeFetcher.fetchValues(sourceLookup);
        fromNative = fromNative.stream().map(o -> {
            if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                return ((Number)o).longValue();
            }
            if (o instanceof Float) {
                return ((Float)o).doubleValue();
            }
            return o;
        }).collect(Collectors.toList());
        if (this.dedupAfterFetch()) {
            fromNative = fromNative.stream().distinct().collect(Collectors.toList());
        }
        MapperTestCase.assertThat((String)("fetching " + value), fromNative, (Matcher)Matchers.containsInAnyOrder((Object[])fromDocValues.toArray()));
    }

    public class ParameterChecker {
        List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
        Map<String, ConflictCheck> conflictChecks = new HashMap<String, ConflictCheck>();

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(update, check));
        }

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(init, update, check));
        }

        public void registerConflictCheck(String param, CheckedConsumer<XContentBuilder, IOException> update) throws IOException {
            this.conflictChecks.put(param, new ConflictCheck(MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping)), MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }))));
        }

        public void registerConflictCheck(String param, XContentBuilder init, XContentBuilder update) {
            this.conflictChecks.put(param, new ConflictCheck(init, update));
        }
    }

    private class UpdateCheck {
        final XContentBuilder init;
        final XContentBuilder update;
        final Consumer<FieldMapper> check;

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping));
            this.update = MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }));
            this.check = check;
        }

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperTestCase.this.fieldMapping(init);
            this.update = MapperTestCase.this.fieldMapping(update);
            this.check = check;
        }
    }

    private static class ConflictCheck {
        final XContentBuilder init;
        final XContentBuilder update;

        private ConflictCheck(XContentBuilder init, XContentBuilder update) {
            this.init = init;
            this.update = update;
        }
    }
}

