/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.HalfFloatPoint;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.AssertingDirectoryReader;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.search.AssertingIndexSearcher;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Set;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MockFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.MultiValueAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesPhase;
import org.elasticsearch.search.fetch.subphase.FetchSourcePhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class AggregatorTestCase
extends ESTestCase {
    private java.util.List<AggregationContext> releasables = new ArrayList<AggregationContext>();
    protected ValuesSourceRegistry valuesSourceRegistry;
    private static final java.util.List<String> TYPE_TEST_BLACKLIST;

    @Before
    public void initValuesSourceRegistry() {
        ArrayList<SearchPlugin> plugins = new ArrayList<SearchPlugin>(this.getSearchPlugins());
        plugins.add(new AggCardinalityPlugin());
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, plugins);
        this.valuesSourceRegistry = searchModule.getValuesSourceRegistry();
    }

    protected java.util.List<SearchPlugin> getSearchPlugins() {
        return Collections.emptyList();
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher searcher, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(aggregationBuilder, this.createAggregationContext(searcher, (Query)new MatchAllDocsQuery(), fieldTypes));
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder builder, AggregationContext context) throws IOException {
        QueryRewriteContext rewriteContext = new QueryRewriteContext(this.xContentRegistry(), new NamedWriteableRegistry(List.of()), null, () -> ((AggregationContext)context).nowInMillis());
        Aggregator aggregator = ((AggregationBuilder)Rewriteable.rewrite((Rewriteable)builder, (QueryRewriteContext)rewriteContext, (boolean)true)).build(context, null).create(null, CardinalityUpperBound.ONE);
        return (A)aggregator;
    }

    protected AggregationContext createAggregationContext(IndexSearcher indexSearcher, Query query, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregationContext(indexSearcher, this.createIndexSettings(), query, (CircuitBreakerService)new NoneCircuitBreakerService(), 30720L, 100000, fieldTypes);
    }

    protected AggregationContext createAggregationContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, CircuitBreakerService breakerService, long bytesToPreallocate, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        MappingLookup mappingLookup = MappingLookup.fromMappers((Mapping)Mapping.EMPTY, (Collection)Arrays.stream(fieldTypes).map(this::buildMockFieldMapper).collect(Collectors.toList()), this.objectMappers(), (Collection)Arrays.stream(fieldTypes).map(ft -> new FieldAliasMapper(ft.name() + "-alias", ft.name() + "-alias", ft.name())).collect(Collectors.toList()));
        TriFunction fieldDataBuilder = (fieldType, s, searchLookup) -> fieldType.fielddataBuilder(indexSettings.getIndex().getName(), searchLookup).build((IndexFieldDataCache)new IndexFieldDataCache.None(), breakerService);
        BitsetFilterCache bitsetFilterCache = new BitsetFilterCache(indexSettings, new BitsetFilterCache.Listener(){

            public void onRemoval(ShardId shardId, Accountable accountable) {
            }

            public void onCache(ShardId shardId, Accountable accountable) {
            }
        });
        SearchExecutionContext searchExecutionContext = new SearchExecutionContext(0, -1, indexSettings, bitsetFilterCache, fieldDataBuilder, null, mappingLookup, null, this.getMockScriptService(), this.xContentRegistry(), this.writableRegistry(), null, indexSearcher, System::currentTimeMillis, null, null, () -> true, this.valuesSourceRegistry, Collections.emptyMap());
        MultiBucketConsumerService.MultiBucketConsumer consumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, breakerService.getBreaker("request"));
        AggregationContext.ProductionAggregationContext context = new AggregationContext.ProductionAggregationContext(searchExecutionContext, (BigArrays)new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), breakerService), bytesToPreallocate, () -> query, null, consumer, () -> this.buildSubSearchContext(indexSettings, searchExecutionContext, bitsetFilterCache), bitsetFilterCache, AggregatorTestCase.randomInt(), () -> 0L, () -> false, q -> q, true);
        this.releasables.add((AggregationContext)context);
        return context;
    }

    protected FieldMapper buildMockFieldMapper(MappedFieldType ft) {
        return new MockFieldMapper(ft);
    }

    protected java.util.List<ObjectMapper> objectMappers() {
        return List.of();
    }

    private SubSearchContext buildSubSearchContext(IndexSettings indexSettings, SearchExecutionContext searchExecutionContext, BitsetFilterCache bitsetFilterCache) {
        SearchContext ctx = (SearchContext)Mockito.mock(SearchContext.class);
        DisabledQueryCache queryCache = new DisabledQueryCache(indexSettings);
        QueryCachingPolicy queryCachingPolicy = new QueryCachingPolicy(){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) {
                return false;
            }
        };
        try {
            Mockito.when((Object)ctx.searcher()).thenReturn((Object)new ContextIndexSearcher(searchExecutionContext.searcher().getIndexReader(), searchExecutionContext.searcher().getSimilarity(), (QueryCache)queryCache, queryCachingPolicy, false));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Mockito.when((Object)ctx.fetchPhase()).thenReturn((Object)new FetchPhase(Arrays.asList(new FetchSourcePhase(), new FetchDocValuesPhase())));
        SearchExecutionContext subContext = (SearchExecutionContext)Mockito.spy((Object)searchExecutionContext);
        MappingLookup disableNestedLookup = MappingLookup.fromMappers((Mapping)Mapping.EMPTY, (Collection)Set.of(), (Collection)Set.of(), (Collection)Set.of());
        ((SearchExecutionContext)Mockito.doReturn((Object)new NestedDocuments(disableNestedLookup, Version.CURRENT, arg_0 -> ((BitsetFilterCache)bitsetFilterCache).getBitSetProducer(arg_0))).when((Object)subContext)).getNestedDocuments();
        Mockito.when((Object)ctx.getSearchExecutionContext()).thenReturn((Object)subContext);
        IndexShard indexShard = (IndexShard)Mockito.mock(IndexShard.class);
        Mockito.when((Object)indexShard.shardId()).thenReturn((Object)new ShardId("test", "test", 0));
        Mockito.when((Object)ctx.indexShard()).thenReturn((Object)indexShard);
        return new SubSearchContext(ctx);
    }

    protected IndexSettings createIndexSettings() {
        return new IndexSettings(IndexMetadata.builder((String)"_index").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).creationDate(System.currentTimeMillis()).build(), Settings.EMPTY);
    }

    protected ScriptService getMockScriptService() {
        return null;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, 100000, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(indexSettings, searcher, query, builder, 100000, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, maxBucket, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(indexSettings, searcher, query, builder, maxBucket, AggregatorTestCase.randomBoolean(), fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, boolean splitLeavesIntoSeparateAggregators, MappedFieldType ... fieldTypes) throws IOException {
        IndexReaderContext ctx = searcher.getTopReaderContext();
        PipelineAggregator.PipelineTree pipelines = builder.buildPipelineTree();
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        Query rewritten = searcher.rewrite(query);
        NoneCircuitBreakerService breakerService = new NoneCircuitBreakerService();
        AggregationContext context = this.createAggregationContext(searcher, indexSettings, query, (CircuitBreakerService)breakerService, AggregatorTestCase.randomBoolean() ? 0L : builder.bytesToPreallocate(), maxBucket, fieldTypes);
        A root = this.createAggregator(builder, context);
        if (splitLeavesIntoSeparateAggregators && searcher.getIndexReader().leaves().size() > 0) {
            AggregatorTestCase.assertThat((Object)ctx, (Matcher)Matchers.instanceOf(CompositeReaderContext.class));
            CompositeReaderContext compCTX = (CompositeReaderContext)ctx;
            int size = compCTX.leaves().size();
            ShardSearcher[] subSearchers = new ShardSearcher[size];
            for (int searcherIDX = 0; searcherIDX < subSearchers.length; ++searcherIDX) {
                LeafReaderContext leave = (LeafReaderContext)compCTX.leaves().get(searcherIDX);
                subSearchers[searcherIDX] = new ShardSearcher(leave, (IndexReaderContext)compCTX);
            }
            for (ShardSearcher subSearcher : subSearchers) {
                A a = this.createAggregator(builder, context);
                a.preCollection();
                Weight weight = subSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                subSearcher.search(weight, (Collector)a);
                a.postCollection();
                aggs.add(a.buildTopLevel());
            }
        } else {
            root.preCollection();
            searcher.search(rewritten, (Collector)MultiBucketCollector.wrap((boolean)true, (Iterable)List.of(root)));
            root.postCollection();
            aggs.add(root.buildTopLevel());
        }
        if (AggregatorTestCase.randomBoolean() && aggs.size() > 1) {
            int toReduceSize = aggs.size();
            Collections.shuffle(aggs, AggregatorTestCase.random());
            int r = AggregatorTestCase.randomIntBetween(1, toReduceSize);
            java.util.List toReduce = aggs.subList(0, r);
            InternalAggregation.ReduceContext reduceContext = InternalAggregation.ReduceContext.forPartialReduction((BigArrays)context.bigArrays(), (ScriptService)this.getMockScriptService(), () -> PipelineAggregator.PipelineTree.EMPTY);
            InternalAggregation reduced = ((InternalAggregation)aggs.get(0)).reduce(toReduce, reduceContext);
            aggs = new ArrayList(aggs.subList(r, toReduceSize));
            aggs.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        InternalAggregation.ReduceContext reduceContext = InternalAggregation.ReduceContext.forFinalReduction((BigArrays)context.bigArrays(), (ScriptService)this.getMockScriptService(), (IntConsumer)reduceBucketConsumer, (PipelineAggregator.PipelineTree)pipelines);
        InternalAggregation internalAgg = ((InternalAggregation)aggs.get(0)).reduce(aggs, reduceContext);
        internalAgg = internalAgg.reducePipelines(internalAgg, reduceContext, pipelines);
        for (PipelineAggregator pipelineAggregator : pipelines.aggregators()) {
            internalAgg = pipelineAggregator.reduce(internalAgg, reduceContext);
        }
        this.doAssertReducedMultiBucketConsumer((Aggregation)internalAgg, reduceBucketConsumer);
        return (A)internalAgg;
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected <T extends AggregationBuilder, V extends InternalAggregation> void testCase(T aggregationBuilder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, Consumer<V> verify, MappedFieldType ... fieldTypes) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)indexWriter);
            indexWriter.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher(indexReader);
                Object agg = this.searchAndReduce(indexSearcher, query, aggregationBuilder, fieldTypes);
                verify.accept(agg);
                this.verifyOutputFieldNames(aggregationBuilder, (V)agg);
            }
        }
    }

    protected void withIndex(CheckedConsumer<RandomIndexWriter, IOException> buildIndex, CheckedConsumer<IndexSearcher, IOException> consume) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)iw);
            iw.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                consume.accept((Object)AggregatorTestCase.newIndexSearcher(indexReader));
            }
        }
    }

    protected void withNonMergingIndex(CheckedConsumer<RandomIndexWriter, IOException> buildIndex, CheckedConsumer<IndexSearcher, IOException> consume) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory, LuceneTestCase.newIndexWriterConfig((Random)AggregatorTestCase.random(), (Analyzer)new StandardAnalyzer()).setMergePolicy(NoMergePolicy.INSTANCE));
            buildIndex.accept((Object)iw);
            iw.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                consume.accept((Object)AggregatorTestCase.newIndexSearcher(indexReader));
            }
        }
    }

    protected <R extends InternalAggregation> void debugTestCase(AggregationBuilder builder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, TriConsumer<R, Class<? extends Aggregator>, Map<String, Map<String, Object>>> verify, MappedFieldType ... fieldTypes) throws IOException {
        this.withIndex(buildIndex, (CheckedConsumer<IndexSearcher, IOException>)((CheckedConsumer)searcher -> this.debugTestCase(builder, query, (IndexSearcher)searcher, verify, fieldTypes)));
    }

    protected <R extends InternalAggregation> void debugTestCase(AggregationBuilder builder, Query query, IndexSearcher searcher, TriConsumer<R, Class<? extends Aggregator>, Map<String, Map<String, Object>>> verify, MappedFieldType ... fieldTypes) throws IOException {
        NoneCircuitBreakerService breakerService = new NoneCircuitBreakerService();
        AggregationContext context = this.createAggregationContext(searcher, this.createIndexSettings(), searcher.rewrite(query), (CircuitBreakerService)breakerService, builder.bytesToPreallocate(), 100000, fieldTypes);
        Object aggregator = this.createAggregator(builder, context);
        aggregator.preCollection();
        searcher.search(context.query(), aggregator);
        aggregator.postCollection();
        InternalAggregation r = aggregator.buildTopLevel();
        InternalAggregation result = r = r.reduce(List.of((Object)r), InternalAggregation.ReduceContext.forFinalReduction((BigArrays)context.bigArrays(), (ScriptService)this.getMockScriptService(), (IntConsumer)context.multiBucketConsumer(), (PipelineAggregator.PipelineTree)builder.buildPipelineTree()));
        HashMap<String, Map<String, Object>> debug = new HashMap<String, Map<String, Object>>();
        this.collectDebugInfo("", (Aggregator)aggregator, (Map<String, Map<String, Object>>)debug);
        verify.apply((Object)result, aggregator.getClass(), debug);
        this.verifyOutputFieldNames(builder, result);
    }

    private void collectDebugInfo(String prefix, Aggregator aggregator, Map<String, Map<String, Object>> allDebug) {
        HashMap debug = new HashMap();
        aggregator.collectDebugInfo((key, value) -> {
            Object old = debug.put(key, value);
            AggregatorTestCase.assertNull((String)("debug info duplicate key [" + key + "] was [" + old + "] is [" + value + "]"), (Object)old);
        });
        allDebug.put(prefix + aggregator.name(), debug);
        for (Aggregator sub : aggregator.subAggregators()) {
            this.collectDebugInfo(aggregator.name() + ".", sub, allDebug);
        }
    }

    protected void withAggregator(AggregationBuilder aggregationBuilder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, CheckedBiConsumer<IndexSearcher, Aggregator, IOException> verify, MappedFieldType ... fieldTypes) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)indexWriter);
            indexWriter.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                IndexSearcher searcher = AggregatorTestCase.newIndexSearcher(indexReader);
                AggregationContext context = this.createAggregationContext(searcher, query, fieldTypes);
                verify.accept((Object)searcher, this.createAggregator(aggregationBuilder, context));
            }
        }
    }

    protected <T extends AggregationBuilder, V extends InternalAggregation> void verifyOutputFieldNames(T aggregationBuilder, V agg) throws IOException {
        if (!aggregationBuilder.getOutputFieldNames().isPresent()) {
            return;
        }
        HashSet<String> valueNames = new HashSet<String>();
        if (agg instanceof NumericMetricsAggregation.MultiValue) {
            NumericMetricsAggregation.MultiValue multiValueAgg = (NumericMetricsAggregation.MultiValue)agg;
            for (String name : multiValueAgg.valueNames()) {
                valueNames.add(name);
            }
        } else if (agg instanceof MultiValueAggregation) {
            MultiValueAggregation multiValueAgg = (MultiValueAggregation)agg;
            for (String name : multiValueAgg.valueNames()) {
                valueNames.add(name);
            }
        } else assert (false) : "only multi value aggs are supported";
        AggregatorTestCase.assertEquals(aggregationBuilder.getOutputFieldNames().get(), valueNames);
    }

    protected IndexReader wrapDirectoryReader(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected static DirectoryReader wrapInMockESDirectoryReader(DirectoryReader directoryReader) throws IOException {
        return ElasticsearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("_index", "_na_"), 0));
    }

    protected static IndexSearcher newIndexSearcher(IndexReader indexReader) {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingIndexSearcher(AggregatorTestCase.random(), indexReader);
        }
        return new IndexSearcher(indexReader);
    }

    protected static IndexReader maybeWrapReaderEs(DirectoryReader reader) throws IOException {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingDirectoryReader(reader);
        }
        return reader;
    }

    protected java.util.List<ValuesSourceType> getSupportedValuesSourceTypes() {
        return Collections.emptyList();
    }

    protected AggregationBuilder createAggBuilderForTypeTest(MappedFieldType fieldType, String fieldName) {
        throw new UnsupportedOperationException("If getSupportedValuesSourceTypes() is implemented, createAggBuilderForTypeTest() must be implemented as well.");
    }

    protected java.util.List<String> unsupportedMappedFieldTypes() {
        return Collections.emptyList();
    }

    public void testSupportedFieldTypes() throws IOException {
        MapperRegistry mapperRegistry = new IndicesModule(Collections.emptyList()).getMapperRegistry();
        String fieldName = "typeTestFieldName";
        java.util.List<ValuesSourceType> supportedVSTypes = this.getSupportedValuesSourceTypes();
        java.util.List<String> unsupportedMappedFieldTypes = this.unsupportedMappedFieldTypes();
        if (supportedVSTypes.isEmpty()) {
            return;
        }
        for (Map.Entry mappedType : mapperRegistry.getMapperParsers().entrySet()) {
            Mapper.Builder builder;
            FieldMapper mapper;
            MappedFieldType fieldType;
            if (TYPE_TEST_BLACKLIST.contains(mappedType.getKey())) continue;
            HashMap source = new HashMap();
            source.put("type", mappedType.getKey());
            if (!((String)mappedType.getKey()).equals("text")) {
                source.put("doc_values", "true");
            }
            if (!(fieldType = (mapper = (FieldMapper)(builder = ((Mapper.TypeParser)mappedType.getValue()).parse(fieldName, source, (MappingParserContext)new MockParserContext())).build(new ContentPath())).fieldType()).isAggregatable()) continue;
            BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();
            try {
                RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
                this.writeTestDoc(fieldType, fieldName, indexWriter);
                indexWriter.close();
                DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
                try {
                    AssertionError failure;
                    block16: {
                        IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher((IndexReader)indexReader);
                        AggregationBuilder aggregationBuilder = this.createAggBuilderForTypeTest(fieldType, fieldName);
                        ValuesSourceType vst = this.fieldToVST(fieldType);
                        failure = null;
                        try {
                            this.searchAndReduce(indexSearcher, (Query)new MatchAllDocsQuery(), aggregationBuilder, fieldType);
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) {
                                failure = new AssertionError((Object)("Aggregator [" + aggregationBuilder.getType() + "] should not support field type [" + fieldType.typeName() + "] but executing against the field did not throw an exception"));
                            }
                        }
                        catch (AssertionError | Exception e) {
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) break block16;
                            failure = new AssertionError("Aggregator [" + aggregationBuilder.getType() + "] supports field type [" + fieldType.typeName() + "] but executing against the field threw an exception: [" + ((Throwable)e).getMessage() + "]", (Throwable)e);
                        }
                    }
                    if (failure == null) continue;
                    throw failure;
                }
                finally {
                    if (indexReader == null) continue;
                    indexReader.close();
                }
            }
            finally {
                if (directory == null) continue;
                directory.close();
            }
        }
    }

    private ValuesSourceType fieldToVST(MappedFieldType fieldType) {
        return fieldType.fielddataBuilder("", () -> {
            throw new UnsupportedOperationException();
        }).build(null, null).getValuesSourceType();
    }

    private void writeTestDoc(MappedFieldType fieldType, String fieldName, RandomIndexWriter iw) throws IOException {
        String json;
        String typeName = fieldType.typeName();
        ValuesSourceType vst = this.fieldToVST(fieldType);
        Document doc = new Document();
        if (vst.equals(CoreValuesSourceType.NUMERIC)) {
            long v;
            if (typeName.equals(NumberFieldMapper.NumberType.DOUBLE.typeName())) {
                double d = Math.abs(AggregatorTestCase.randomDouble());
                v = NumericUtils.doubleToSortableLong((double)d);
                json = "{ \"" + fieldName + "\" : \"" + d + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.FLOAT.typeName())) {
                float f = Math.abs(AggregatorTestCase.randomFloat());
                v = NumericUtils.floatToSortableInt((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.HALF_FLOAT.typeName())) {
                float f = Math.abs((AggregatorTestCase.randomFloat() * 2.0f - 1.0f) * 65504.0f);
                v = HalfFloatPoint.halfFloatToSortableShort((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else {
                v = Math.abs(AggregatorTestCase.randomByte());
                json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
            }
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
        } else if (vst.equals(CoreValuesSourceType.KEYWORD)) {
            if (typeName.equals("binary")) {
                doc.add((IndexableField)new BinaryFieldMapper.CustomBinaryDocValuesField(fieldName, new BytesRef((CharSequence)"a").bytes));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            } else {
                doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef((CharSequence)"a")));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            }
        } else if (vst.equals(CoreValuesSourceType.DATE)) {
            long v = Math.abs(AggregatorTestCase.randomInt());
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
        } else if (vst.equals(CoreValuesSourceType.BOOLEAN)) {
            long v = AggregatorTestCase.randomBoolean() ? 0L : 1L;
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + (v == 0L ? "false" : "true") + "\" }";
        } else if (vst.equals(CoreValuesSourceType.IP)) {
            InetAddress ip = AggregatorTestCase.randomIp(AggregatorTestCase.randomBoolean());
            json = "{ \"" + fieldName + "\" : \"" + NetworkAddress.format((InetAddress)ip) + "\" }";
            doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef(InetAddressPoint.encode((InetAddress)ip))));
        } else if (vst.equals(CoreValuesSourceType.RANGE)) {
            RangeType rangeType;
            Object end;
            Serializable start;
            if (typeName.equals(RangeType.DOUBLE.typeName())) {
                start = AggregatorTestCase.randomDouble();
                end = RangeType.DOUBLE.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.FLOAT.typeName())) {
                start = Float.valueOf(AggregatorTestCase.randomFloat());
                end = RangeType.FLOAT.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.IP.typeName())) {
                boolean v4 = AggregatorTestCase.randomBoolean();
                start = AggregatorTestCase.randomIp(v4);
                end = RangeType.IP.nextUp((Object)start);
                rangeType = RangeType.IP;
            } else if (typeName.equals(RangeType.LONG.typeName())) {
                start = AggregatorTestCase.randomLong();
                end = RangeType.LONG.nextUp((Object)start);
                rangeType = RangeType.LONG;
            } else if (typeName.equals(RangeType.INTEGER.typeName())) {
                start = AggregatorTestCase.randomInt();
                end = RangeType.INTEGER.nextUp((Object)start);
                rangeType = RangeType.INTEGER;
            } else if (typeName.equals(RangeType.DATE.typeName())) {
                start = AggregatorTestCase.randomNonNegativeLong();
                end = RangeType.DATE.nextUp((Object)start);
                rangeType = RangeType.DATE;
            } else {
                throw new IllegalStateException("Unknown type of range [" + typeName + "]");
            }
            RangeFieldMapper.Range range = new RangeFieldMapper.Range(rangeType, (Object)start, end, true, true);
            doc.add((IndexableField)new BinaryDocValuesField(fieldName, rangeType.encodeRanges(Collections.singleton(range))));
            json = "{ \"" + fieldName + "\" : { \n        \"gte\" : \"" + start + "\",\n        \"lte\" : \"" + end + "\"\n      }}";
        } else if (vst.equals(CoreValuesSourceType.GEOPOINT)) {
            double lat = AggregatorTestCase.randomDouble();
            double lon = AggregatorTestCase.randomDouble();
            doc.add((IndexableField)new LatLonDocValuesField(fieldName, lat, lon));
            json = "{ \"" + fieldName + "\" : \"[" + lon + "," + lat + "]\" }";
        } else {
            throw new IllegalStateException("Unknown field type [" + typeName + "]");
        }
        doc.add((IndexableField)new StoredField("_source", new BytesRef((CharSequence)json)));
        iw.addDocument((Iterable)doc);
    }

    @After
    public void cleanupReleasables() {
        Releasables.close(this.releasables);
        this.releasables.clear();
    }

    protected void afterClose() {
    }

    protected DateFieldMapper.DateFieldType dateField(String name, DateFieldMapper.Resolution resolution) {
        return new DateFieldMapper.DateFieldType(name, resolution);
    }

    protected NumberFieldMapper.NumberFieldType doubleField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.DOUBLE);
    }

    protected GeoPointFieldMapper.GeoPointFieldType geoPointField(String name) {
        return new GeoPointFieldMapper.GeoPointFieldType(name);
    }

    protected KeywordFieldMapper.KeywordFieldType keywordField(String name) {
        return new KeywordFieldMapper.KeywordFieldType(name);
    }

    protected NumberFieldMapper.NumberFieldType longField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.LONG);
    }

    protected RangeFieldMapper.RangeFieldType rangeField(String name, RangeType rangeType) {
        if (rangeType == RangeType.DATE) {
            return new RangeFieldMapper.RangeFieldType(name, RangeFieldMapper.Defaults.DATE_FORMATTER);
        }
        return new RangeFieldMapper.RangeFieldType(name, rangeType);
    }

    public static AggregationBuilder aggCardinality(String name) {
        return new AggCardinalityAggregationBuilder(name);
    }

    static {
        ArrayList<String> blacklist = new ArrayList<String>();
        blacklist.add("object");
        blacklist.add("geo_shape");
        blacklist.add("nested");
        blacklist.add("completion");
        blacklist.add("alias");
        TYPE_TEST_BLACKLIST = blacklist;
    }

    private static class AggCardinalityPlugin
    implements SearchPlugin {
        private AggCardinalityPlugin() {
        }

        public java.util.List<SearchPlugin.AggregationSpec> getAggregations() {
            return Collections.singletonList(new SearchPlugin.AggregationSpec("agg_cardinality", in -> null, (p, c) -> null));
        }
    }

    private static class ShardSearcher
    extends IndexSearcher {
        private final java.util.List<LeafReaderContext> ctx;

        ShardSearcher(LeafReaderContext ctx, IndexReaderContext parent) {
            super(parent);
            this.ctx = Collections.singletonList(ctx);
        }

        public void search(Weight weight, Collector collector) throws IOException {
            this.search(this.ctx, weight, collector);
        }

        public String toString() {
            return "ShardSearcher(" + this.ctx.get(0) + ")";
        }
    }

    private static class MockParserContext
    extends MappingParserContext {
        MockParserContext() {
            super(null, null, null, Version.CURRENT, null, null, ScriptCompiler.NONE, null, null, null);
        }

        public Settings getSettings() {
            return Settings.EMPTY;
        }

        public IndexAnalyzers getIndexAnalyzers() {
            NamedAnalyzer defaultAnalyzer = new NamedAnalyzer("default", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
            return new IndexAnalyzers(Collections.singletonMap("default", defaultAnalyzer), Collections.emptyMap(), Collections.emptyMap());
        }
    }

    private static class AggCardinalityAggregationBuilder
    extends AbstractAggregationBuilder<AggCardinalityAggregationBuilder> {
        AggCardinalityAggregationBuilder(String name) {
            super(name);
        }

        protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
            return new AggregatorFactory(this.name, context, parent, subfactoriesBuilder, this.metadata){

                protected Aggregator createInternal(Aggregator parent, final CardinalityUpperBound cardinality, final Map<String, Object> metadata) throws IOException {
                    return new MetricsAggregator(this.name, this.context, parent, metadata){

                        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
                            return LeafBucketCollector.NO_OP_COLLECTOR;
                        }

                        public InternalAggregation buildAggregation(long owningBucketOrd) throws IOException {
                            return new InternalAggCardinality(this.name, cardinality, metadata);
                        }

                        public InternalAggregation buildEmptyAggregation() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }

        public AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.ONE;
        }

        public String getType() {
            return "agg_cardinality";
        }

        protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class InternalAggCardinality
    extends InternalAggregation {
        private final CardinalityUpperBound cardinality;

        protected InternalAggCardinality(String name, CardinalityUpperBound cardinality, Map<String, Object> metadata) {
            super(name, metadata);
            this.cardinality = cardinality;
        }

        public CardinalityUpperBound cardinality() {
            return this.cardinality;
        }

        public InternalAggregation reduce(java.util.List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
            aggregations.forEach(ia -> Assert.assertThat((Object)((InternalAggCardinality)ia).cardinality, (Matcher)Matchers.equalTo((Object)this.cardinality)));
            return new InternalAggCardinality(this.name, this.cardinality, this.metadata);
        }

        protected boolean mustReduceOnSingleInternalAgg() {
            return true;
        }

        public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.array("cardinality", new Object[]{this.cardinality});
        }

        public Object getProperty(java.util.List<String> path) {
            throw new UnsupportedOperationException();
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

