/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.geo.GeoTestUtil;
import org.apache.lucene.geo.Polygon;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.List;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.geo.GeoPointShapeQueryTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class GeoShapeQueryTestCase
extends GeoPointShapeQueryTestCase {
    public void testShapeFetchingPath() throws Exception {
        this.createIndex("shapes");
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        String geo = "\"geo\" : {\"type\":\"polygon\", \"coordinates\":[[[-10,-10],[10,-10],[10,10],[-10,10],[-10,-10]]]}";
        ((IndexRequestBuilder)this.client().prepareIndex("shapes", "_doc").setId("1").setSource(String.format(Locale.ROOT, "{ %s, \"1\" : { %s, \"2\" : { %s, \"3\" : { %s } }} }", geo, geo, geo, geo), XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(XContentFactory.jsonBuilder().startObject().startObject("geo").field("type", "polygon").startArray("coordinates").startArray().startArray().value(-20).value(-20).endArray().startArray().value(20).value(-20).endArray().startArray().value(20).value(20).endArray().startArray().value(-20).value(20).endArray().startArray().value(-20).value(-20).endArray().endArray().endArray().endObject().endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GeoShapeQueryBuilder filter = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes")).indexedShapePath("geo");
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        filter = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes")).indexedShapePath("1.geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        filter = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes")).indexedShapePath("1.2.geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        filter = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex("shapes")).indexedShapePath("1.2.3.geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        GeoShapeQueryBuilder query = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").indexedShapeIndex("shapes")).indexedShapePath("geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        query = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").indexedShapeIndex("shapes")).indexedShapePath("1.geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        query = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").indexedShapeIndex("shapes")).indexedShapePath("1.2.geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        query = (GeoShapeQueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"1").indexedShapeIndex("shapes")).indexedShapePath("1.2.3.geo");
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)query).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }

    public void testRandomGeoCollectionQuery() throws Exception {
        GeometryCollection<Geometry> randomIndexCollection = GeometryTestUtils.randomGeometryCollectionWithoutCircle(false);
        Polygon randomPoly = GeoTestUtil.nextPolygon();
        GeoShapeQueryTestCase.assumeTrue((String)"Skipping the check for the polygon with a degenerated dimension", (randomPoly.maxLat - randomPoly.minLat > 8.4E-8 && randomPoly.maxLon - randomPoly.minLon > 8.4E-8 ? 1 : 0) != 0);
        org.elasticsearch.geometry.Polygon polygon = new org.elasticsearch.geometry.Polygon(new LinearRing(randomPoly.getPolyLons(), randomPoly.getPolyLats()));
        ArrayList<Object> indexGeometries = new ArrayList<Object>();
        for (Geometry geometry : randomIndexCollection) {
            indexGeometries.add(geometry);
        }
        indexGeometries.add(polygon);
        GeometryCollection gcb = new GeometryCollection(indexGeometries);
        this.logger.info("Created Random GeometryCollection containing {} shapes", (Object)gcb.size());
        this.createMapping("test", "_doc", "geo", Settings.builder().put("index.number_of_shards", 1).build());
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = GeoJson.toXContent((Geometry)gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GeometryCollection<Geometry> randomQueryCollection = GeometryTestUtils.randomGeometryCollection(false);
        ArrayList<Object> queryGeometries = new ArrayList<Object>();
        for (Geometry geometry : randomQueryCollection) {
            queryGeometries.add(geometry);
        }
        queryGeometries.add(polygon);
        GeometryCollection queryCollection = new GeometryCollection(queryGeometries);
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)queryCollection);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        GeoShapeQueryTestCase.assertTrue((String)("query: " + geoShapeQueryBuilder + " doc: " + Strings.toString((XContentBuilder)docSource)), (result.getHits().getTotalHits().value > 0L ? 1 : 0) != 0);
    }

    public void testEnvelopeSpanningDateline() throws Exception {
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        String doc1 = "{\"geo\": {\r\n\"coordinates\": [\r\n-33.918711,\r\n18.847685\r\n],\r\n\"type\": \"Point\"\r\n}}";
        this.client().index((IndexRequest)new IndexRequest("test").id("1").source(doc1, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        String doc2 = "{\"geo\": {\r\n\"coordinates\": [\r\n-49.0,\r\n18.847685\r\n],\r\n\"type\": \"Point\"\r\n}}";
        this.client().index((IndexRequest)new IndexRequest("test").id("2").source(doc2, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        String doc3 = "{\"geo\": {\r\n\"coordinates\": [\r\n49.0,\r\n18.847685\r\n],\r\n\"type\": \"Point\"\r\n}}";
        this.client().index((IndexRequest)new IndexRequest("test").id("3").source(doc3, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        CheckedSupplier querySupplier = GeoShapeQueryTestCase.randomFrom(() -> QueryBuilders.geoShapeQuery((String)"geo", (Geometry)new Rectangle(-21.0, -39.0, 44.0, 9.0)).relation(ShapeRelation.WITHIN), () -> {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("geo").startObject("shape").field("type", "envelope").startArray("coordinates").startArray().value(-21).value(44).endArray().startArray().value(-39).value(9).endArray().endArray().endObject().field("relation", "within").endObject().endObject();
            try (XContentParser parser = this.createParser(builder);){
                parser.nextToken();
                GeoShapeQueryBuilder geoShapeQueryBuilder = GeoShapeQueryBuilder.fromXContent((XContentParser)parser);
                return geoShapeQueryBuilder;
            }
        }, () -> {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("geo").field("shape", "BBOX (-21, -39, 44, 9)").field("relation", "within").endObject().endObject();
            try (XContentParser parser = this.createParser(builder);){
                parser.nextToken();
                GeoShapeQueryBuilder geoShapeQueryBuilder = GeoShapeQueryBuilder.fromXContent((XContentParser)parser);
                return geoShapeQueryBuilder;
            }
        });
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)querySupplier.get()).get();
        GeoShapeQueryTestCase.assertEquals((long)2L, (long)response.getHits().getTotalHits().value);
        GeoShapeQueryTestCase.assertNotEquals((Object)"1", (Object)response.getHits().getAt(0).getId());
        GeoShapeQueryTestCase.assertNotEquals((Object)"1", (Object)response.getHits().getAt(1).getId());
    }

    public void testGeometryCollectionRelations() throws Exception {
        Settings settings = Settings.builder().put("index.number_of_shards", 1).build();
        this.createMapping("test", "_doc", "geo", settings);
        this.ensureGreen(new String[0]);
        Rectangle envelope = new Rectangle(-10.0, 10.0, 10.0, -10.0);
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)envelope)).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        ArrayList<Point> geometries = new ArrayList<Point>();
        geometries.add(new Point(1.0, 2.0));
        geometries.add(new Point(-2.0, -1.0));
        GeometryCollection collection = new GeometryCollection(geometries);
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.CONTAINS)).get();
        GeoShapeQueryTestCase.assertEquals((long)1L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.INTERSECTS)).get();
        GeoShapeQueryTestCase.assertEquals((long)1L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.DISJOINT)).get();
        GeoShapeQueryTestCase.assertEquals((long)0L, (long)response.getHits().getTotalHits().value);
        geometries = new ArrayList();
        geometries.add(new Point(1.0, 2.0));
        geometries.add(new Point(20.0, 30.0));
        collection = new GeometryCollection(geometries);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.CONTAINS)).get();
        GeoShapeQueryTestCase.assertEquals((long)0L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.INTERSECTS)).get();
        GeoShapeQueryTestCase.assertEquals((long)1L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.DISJOINT)).get();
        GeoShapeQueryTestCase.assertEquals((long)0L, (long)response.getHits().getTotalHits().value);
        geometries = new ArrayList();
        geometries.add(new Point(-20.0, -30.0));
        geometries.add(new Point(20.0, 30.0));
        collection = new GeometryCollection(geometries);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.CONTAINS)).get();
        GeoShapeQueryTestCase.assertEquals((long)0L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.INTERSECTS)).get();
        GeoShapeQueryTestCase.assertEquals((long)0L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)collection).relation(ShapeRelation.DISJOINT)).get();
        GeoShapeQueryTestCase.assertEquals((long)1L, (long)response.getHits().getTotalHits().value);
    }

    public void testEdgeCases() throws Exception {
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("blakely").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Blakely Island").startObject("geo").field("type", "polygon").startArray("coordinates").startArray().startArray().value(-122.83).value(48.57).endArray().startArray().value(-122.77).value(48.56).endArray().startArray().value(-122.79).value(48.53).endArray().startArray().value(-122.83).value(48.57).endArray().endArray().endArray().endObject().endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Rectangle query = new Rectangle(-122.88, -122.82, 48.62, 48.54);
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"geo", (Geometry)query)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"blakely"));
    }

    public void testIndexedShapeReferenceSourceDisabled() throws Exception {
        this.createMapping("test", "_doc", "geo", Settings.builder().put("index.number_of_shards", 1).build());
        this.createIndex("shapes", Settings.EMPTY, "shape_type", "_source", "enabled=false");
        this.ensureGreen(new String[0]);
        Rectangle shape = new Rectangle(-45.0, 45.0, 45.0, -45.0);
        ((IndexRequestBuilder)this.client().prepareIndex("shapes", "_doc").setId("Big_Rectangle").setSource(XContentFactory.jsonBuilder().startObject().field("shape", WellKnownText.toWKT((Geometry)shape)).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        IllegalArgumentException e = (IllegalArgumentException)GeoShapeQueryTestCase.expectThrows(IllegalArgumentException.class, () -> this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"geo", (String)"Big_Rectangle")).get());
        GeoShapeQueryTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"source disabled"));
    }

    public void testPointQuery() throws Exception {
        GeometryCollection<Geometry> randomCollection = GeometryTestUtils.randomGeometryCollectionWithoutCircle(false);
        Point point = GeometryTestUtils.randomPoint(false);
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Geometry geometry : randomCollection) {
            geometries.add(geometry);
        }
        geometries.add(point);
        GeometryCollection gcb = new GeometryCollection(geometries);
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = GeoJson.toXContent((Geometry)gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), (ToXContent.Params)ToXContent.EMPTY_PARAMS).endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)point);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }

    public void testContainsShapeQuery() throws Exception {
        org.elasticsearch.geometry.Polygon polygon = new org.elasticsearch.geometry.Polygon(new LinearRing(new double[]{-30.0, 30.0, 30.0, -30.0, -30.0}, new double[]{-30.0, -30.0, 30.0, 30.0, -30.0}));
        org.elasticsearch.geometry.Polygon innerPolygon = new org.elasticsearch.geometry.Polygon(new LinearRing(new double[]{-5.0, 5.0, 5.0, -5.0, -5.0}, new double[]{-5.0, -5.0, 5.0, 5.0, -5.0}));
        this.createMapping("test", "_doc", "geo");
        XContentBuilder docSource = GeoJson.toXContent((Geometry)polygon, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GeoShapeQueryBuilder filter = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)innerPolygon).relation(ShapeRelation.CONTAINS);
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(response);
        GeoShapeQueryTestCase.assertThat((Object)response.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    public void testExistsQuery() throws Exception {
        GeometryCollection<Geometry> gcb = GeometryTestUtils.randomGeometryCollectionWithoutCircle(false);
        this.logger.info("Created Random GeometryCollection containing {} shapes", (Object)gcb.size());
        this.createMapping("test", "_doc", "geo");
        XContentBuilder docSource = GeoJson.toXContent(gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ExistsQueryBuilder eqb = QueryBuilders.existsQuery((String)"geo");
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)eqb).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }

    public void testIndexedShapeReference() throws Exception {
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        Rectangle shape = new Rectangle(-45.0, 45.0, 45.0, -45.0);
        ((IndexRequestBuilder)this.client().prepareIndex("shapes", "_doc").setId("Big_Rectangle").setSource(GeoJson.toXContent((Geometry)shape, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("shape"), null).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").startObject("geo").field("type", "point").startArray("coordinates").value(-30).value(-30).endArray().endObject().endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"geo", (String)"Big_Rectangle")).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
        searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (String)"Big_Rectangle")).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        GeoShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testQueryRandomGeoCollection() throws Exception {
        GeometryCollection<Geometry> randomCollection = GeometryTestUtils.randomGeometryCollectionWithoutCircle(false);
        Polygon randomPoly = GeoTestUtil.nextPolygon();
        org.elasticsearch.geometry.Polygon polygon = new org.elasticsearch.geometry.Polygon(new LinearRing(randomPoly.getPolyLons(), randomPoly.getPolyLats()));
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Geometry geometry : randomCollection) {
            geometries.add(geometry);
        }
        geometries.add(polygon);
        GeometryCollection gcb = new GeometryCollection(geometries);
        this.logger.info("Created Random GeometryCollection containing {} shapes", (Object)gcb.size());
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = GeoJson.toXContent((Geometry)gcb, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)polygon);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        GeoShapeQueryTestCase.assumeTrue((String)"Skipping the check for the polygon with a degenerated dimension until  https://issues.apache.org/jira/browse/LUCENE-8634 is fixed", (randomPoly.maxLat - randomPoly.minLat > 8.4E-8 && randomPoly.maxLon - randomPoly.minLon > 8.4E-8 ? 1 : 0) != 0);
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }

    public void testShapeFilterWithDefinedGeoCollection() throws Exception {
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        XContentBuilder docSource = XContentFactory.jsonBuilder().startObject().startObject("geo").field("type", "geometrycollection").startArray("geometries").startObject().field("type", "point").startArray("coordinates").value(100.0).value(0.0).endArray().endObject().startObject().field("type", "linestring").startArray("coordinates").startArray().value(101.0).value(0.0).endArray().startArray().value(102.0).value(1.0).endArray().endArray().endObject().endArray().endObject().endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        org.elasticsearch.geometry.Polygon polygon1 = new org.elasticsearch.geometry.Polygon(new LinearRing(new double[]{99.0, 99.0, 103.0, 103.0, 99.0}, new double[]{-1.0, 3.0, 3.0, -1.0, -1.0}));
        org.elasticsearch.geometry.Polygon polygon2 = new org.elasticsearch.geometry.Polygon(new LinearRing(new double[]{199.0, 199.0, 193.0, 193.0, 199.0}, new double[]{-11.0, 13.0, 13.0, -11.0, -11.0}));
        GeoShapeQueryBuilder filter = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)new GeometryCollection(List.of((Object)polygon1))).relation(ShapeRelation.INTERSECTS);
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        filter = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)new GeometryCollection(List.of((Object)polygon2))).relation(ShapeRelation.INTERSECTS);
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 0L);
        filter = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)new GeometryCollection(List.of((Object)polygon1, (Object)polygon2))).relation(ShapeRelation.INTERSECTS);
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
        filter = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)GeometryCollection.EMPTY);
        result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)filter).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 0L);
    }

    public void testDistanceQuery() throws Exception {
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        Circle circle = new Circle(1.0, 0.0, 350000.0);
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(2.0, 2.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(3.0, 1.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(-20.0, -30.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        this.client().index((IndexRequest)new IndexRequest("test").source(XContentFactory.jsonBuilder().startObject().field("geo", WellKnownText.toWKT((Geometry)new Point(20.0, 30.0))).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)circle).relation(ShapeRelation.WITHIN)).get();
        GeoShapeQueryTestCase.assertEquals((long)2L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)circle).relation(ShapeRelation.INTERSECTS)).get();
        GeoShapeQueryTestCase.assertEquals((long)2L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)circle).relation(ShapeRelation.DISJOINT)).get();
        GeoShapeQueryTestCase.assertEquals((long)2L, (long)response.getHits().getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"geo", (Geometry)circle).relation(ShapeRelation.CONTAINS)).get();
        GeoShapeQueryTestCase.assertEquals((long)0L, (long)response.getHits().getTotalHits().value);
    }

    public void testIndexRectangleSpanningDateLine() throws Exception {
        this.createMapping("test", "_doc", "geo");
        this.ensureGreen(new String[0]);
        Rectangle envelope = new Rectangle(178.0, -178.0, 10.0, -10.0);
        XContentBuilder docSource = GeoJson.toXContent((Geometry)envelope, (XContentBuilder)XContentFactory.jsonBuilder().startObject().field("geo"), null).endObject();
        ((IndexRequestBuilder)this.client().prepareIndex("test", "_doc").setId("1").setSource(docSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Point filterShape = new Point(179.0, 0.0);
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)"geo", (Geometry)filterShape);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        SearchResponse result = (SearchResponse)this.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        ElasticsearchAssertions.assertSearchResponse(result);
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }
}

