/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoAction;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoRequest;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.nio.MockNioTransportPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractMultiClustersTestCase
extends ESTestCase {
    public static final String LOCAL_CLUSTER = "";
    private static volatile ClusterGroup clusterGroup;

    protected Collection<String> remoteClusterAlias() {
        return AbstractMultiClustersTestCase.randomSubsetOf(Arrays.asList("cluster-a", "cluster-b"));
    }

    protected Collection<Class<? extends Plugin>> nodePlugins(String clusterAlias) {
        return Collections.emptyList();
    }

    protected final Client client() {
        return this.client(LOCAL_CLUSTER);
    }

    protected final Client client(String clusterAlias) {
        return this.cluster(clusterAlias).client();
    }

    protected final InternalTestCluster cluster(String clusterAlias) {
        return clusterGroup.getCluster(clusterAlias);
    }

    protected final Map<String, InternalTestCluster> clusters() {
        return Collections.unmodifiableMap(clusterGroup.clusters);
    }

    protected boolean reuseClusters() {
        return true;
    }

    @Before
    public final void startClusters() throws Exception {
        if (clusterGroup != null && this.reuseClusters()) {
            return;
        }
        AbstractMultiClustersTestCase.stopClusters();
        HashMap<String, InternalTestCluster> clusters = new HashMap<String, InternalTestCluster>();
        ArrayList<String> clusterAliases = new ArrayList<String>(this.remoteClusterAlias());
        clusterAliases.add(LOCAL_CLUSTER);
        for (String clusterAlias : clusterAliases) {
            String clusterName = clusterAlias.equals(LOCAL_CLUSTER) ? "main-cluster" : clusterAlias;
            int numberOfNodes = AbstractMultiClustersTestCase.randomIntBetween(1, 3);
            List<Class<? extends Plugin>> mockPlugins = Arrays.asList(MockHttpTransport.TestPlugin.class, MockTransportService.TestPlugin.class, MockNioTransportPlugin.class);
            Collection<Class<? extends Plugin>> nodePlugins = this.nodePlugins(clusterAlias);
            Settings nodeSettings = Settings.EMPTY;
            NodeConfigurationSource nodeConfigurationSource = AbstractMultiClustersTestCase.nodeConfigurationSource(nodeSettings, nodePlugins);
            InternalTestCluster cluster = new InternalTestCluster(AbstractMultiClustersTestCase.randomLong(), AbstractMultiClustersTestCase.createTempDir(), true, true, numberOfNodes, numberOfNodes, clusterName, nodeConfigurationSource, 0, clusterName + "-", mockPlugins, Function.identity());
            cluster.beforeTest(AbstractMultiClustersTestCase.random(), 0.0);
            clusters.put(clusterAlias, cluster);
        }
        clusterGroup = new ClusterGroup(clusters);
        this.configureAndConnectsToRemoteClusters();
    }

    @Override
    public List<String> filteredWarnings() {
        return Stream.concat(super.filteredWarnings().stream(), Stream.of("setting [path.shared_data] is deprecated and will be removed in a future release", "Configuring [path.data] with a list is deprecated. Instead specify as a string value.", "Configuring multiple [path.data] paths is deprecated. Use RAID or other system level features for utilizing multiple disks. This feature will be removed in 8.0.")).collect(Collectors.toList());
    }

    @After
    public void assertAfterTest() throws Exception {
        for (InternalTestCluster cluster : this.clusters().values()) {
            cluster.wipe(Collections.emptySet());
            cluster.assertAfterTest();
        }
    }

    @AfterClass
    public static void stopClusters() throws IOException {
        IOUtils.close((Closeable)clusterGroup);
        clusterGroup = null;
    }

    protected void disconnectFromRemoteClusters() throws Exception {
        Settings.Builder settings = Settings.builder();
        Set<String> clusterAliases = clusterGroup.clusterAliases();
        for (String clusterAlias : clusterAliases) {
            if (clusterAlias.equals(LOCAL_CLUSTER)) continue;
            settings.putNull("cluster.remote." + clusterAlias + ".seeds");
            settings.putNull("cluster.remote." + clusterAlias + ".mode");
            settings.putNull("cluster.remote." + clusterAlias + ".proxy_address");
        }
        this.client().admin().cluster().prepareUpdateSettings().setPersistentSettings(settings).get();
        AbstractMultiClustersTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (TransportService transportService : this.cluster(LOCAL_CLUSTER).getInstances(TransportService.class)) {
                AbstractMultiClustersTestCase.assertThat((Object)transportService.getRemoteClusterService().getRegisteredRemoteClusterNames(), (Matcher)Matchers.empty());
            }
        }));
    }

    protected void configureAndConnectsToRemoteClusters() throws Exception {
        for (String clusterAlias : clusterGroup.clusterAliases()) {
            if (clusterAlias.equals(LOCAL_CLUSTER)) continue;
            InternalTestCluster cluster = clusterGroup.getCluster(clusterAlias);
            String[] allNodes = cluster.getNodeNames();
            List<String> seedNodes = AbstractMultiClustersTestCase.randomSubsetOf(AbstractMultiClustersTestCase.randomIntBetween(1, Math.min(3, allNodes.length)), allNodes);
            this.configureRemoteCluster(clusterAlias, seedNodes);
        }
    }

    protected void configureRemoteCluster(String clusterAlias, Collection<String> seedNodes) throws Exception {
        Settings.Builder settings = Settings.builder();
        String seed = seedNodes.stream().map(node -> {
            TransportService transportService = this.cluster(clusterAlias).getInstance(TransportService.class, (String)node);
            return transportService.boundAddress().publishAddress().toString();
        }).collect(Collectors.joining(","));
        settings.put("cluster.remote." + clusterAlias + ".seeds", seed);
        this.client().admin().cluster().prepareUpdateSettings().setPersistentSettings(settings).get();
        AbstractMultiClustersTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            List remoteConnectionInfos = ((RemoteInfoResponse)this.client().execute((ActionType)RemoteInfoAction.INSTANCE, (ActionRequest)new RemoteInfoRequest()).actionGet()).getInfos().stream().filter(c -> c.isConnected() && c.getClusterAlias().equals(clusterAlias)).collect(Collectors.toList());
            AbstractMultiClustersTestCase.assertThat(remoteConnectionInfos, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }));
    }

    static NodeConfigurationSource nodeConfigurationSource(Settings nodeSettings, final Collection<Class<? extends Plugin>> nodePlugins) {
        final Settings.Builder builder = Settings.builder();
        builder.putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]);
        builder.putList(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey(), new String[]{"file"});
        builder.put("transport.type", AbstractMultiClustersTestCase.getTestTransportType());
        builder.put(nodeSettings);
        return new NodeConfigurationSource(){

            @Override
            public Settings nodeSettings(int nodeOrdinal, Settings otherSettings) {
                return builder.build();
            }

            @Override
            public Path nodeConfigPath(int nodeOrdinal) {
                return null;
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                return nodePlugins;
            }
        };
    }

    static class ClusterGroup
    implements Closeable {
        private final Map<String, InternalTestCluster> clusters;

        ClusterGroup(Map<String, InternalTestCluster> clusters) {
            this.clusters = Collections.unmodifiableMap(clusters);
        }

        InternalTestCluster getCluster(String clusterAlias) {
            Assert.assertThat(this.clusters, (Matcher)Matchers.hasKey((Object)clusterAlias));
            return this.clusters.get(clusterAlias);
        }

        Set<String> clusterAliases() {
            return this.clusters.keySet();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.clusters.values());
        }
    }
}

