/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.AdditionalPropertiesValidator;
import com.networknt.schema.ItemsValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.PropertiesValidator;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractSchemaValidationTestCase<T extends ToXContent>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    public final void testSchema() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        JsonSchemaFactory factory = this.initializeSchemaFactory();
        Path p = this.getDataPath(this.getSchemaLocation() + this.getJsonSchemaFileName());
        this.logger.debug("loading schema from: [{}]", (Object)p);
        JsonSchema jsonSchema = factory.getSchema(mapper.readTree(Files.newInputStream(p, new OpenOption[0])), config);
        AbstractSchemaValidationTestCase.assertTrue((String)"found empty schema", (jsonSchema.getValidators().size() > 0 ? 1 : 0) != 0);
        AbstractSchemaValidationTestCase.assertTrue((String)"schema lacks at least 1 required field", (boolean)jsonSchema.hasRequiredValidator());
        this.assertSchemaStrictness(jsonSchema.getValidators().values(), jsonSchema.getSchemaPath());
        for (int runs = 0; runs < 20; ++runs) {
            BytesReference xContent = XContentHelper.toXContent(this.createTestInstance(), (XContentType)XContentType.JSON, (ToXContent.Params)this.getToXContentParams(), (boolean)false);
            JsonNode jsonTree = mapper.readTree((InputStream)xContent.streamInput());
            Set errors = jsonSchema.validate(jsonTree);
            AbstractSchemaValidationTestCase.assertThat((String)("Schema validation failed for: " + jsonTree.toPrettyString()), (Object)errors, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }

    protected abstract T createTestInstance();

    protected abstract String getJsonSchemaFileName();

    protected ToXContent.Params getToXContentParams() {
        return ToXContent.EMPTY_PARAMS;
    }

    protected String getSchemaLocation() {
        return "/rest-api-spec/schema/";
    }

    protected SpecVersion.VersionFlag getSchemaVersion() {
        return SpecVersion.VersionFlag.V7;
    }

    private JsonSchemaFactory initializeSchemaFactory() {
        JsonSchemaFactory factory = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)this.getSchemaVersion())).uriFetcher(uri -> {
            String fileName = uri.toString().substring(uri.getScheme().length() + 1);
            Path path = this.getDataPath(this.getSchemaLocation() + fileName);
            this.logger.debug("loading sub-schema [{}] from: [{}]", (Object)uri, (Object)path);
            return Files.newInputStream(path, new OpenOption[0]);
        }, new String[]{"file"}).build();
        return factory;
    }

    private void assertSchemaStrictness(Collection<JsonValidator> validatorSet, String path) {
        boolean additionalPropertiesValidatorFound = false;
        boolean subSchemaFound = false;
        for (JsonValidator validator : validatorSet) {
            if (validator instanceof PropertiesValidator) {
                subSchemaFound = true;
                PropertiesValidator propertiesValidator = (PropertiesValidator)validator;
                for (Map.Entry entry : propertiesValidator.getSchemas().entrySet()) {
                    this.assertSchemaStrictness(((JsonSchema)entry.getValue()).getValidators().values(), propertiesValidator.getSchemaPath());
                }
                continue;
            }
            if (validator instanceof ItemsValidator) {
                ItemsValidator itemValidator = (ItemsValidator)validator;
                if (itemValidator.getSchema() != null) {
                    this.assertSchemaStrictness(itemValidator.getSchema().getValidators().values(), itemValidator.getSchemaPath());
                }
                if (itemValidator.getTupleSchema() == null) continue;
                for (JsonSchema jsonSchema : itemValidator.getTupleSchema()) {
                    this.assertSchemaStrictness(jsonSchema.getValidators().values(), itemValidator.getSchemaPath());
                }
                continue;
            }
            if (!(validator instanceof AdditionalPropertiesValidator)) continue;
            additionalPropertiesValidatorFound = true;
        }
        AbstractSchemaValidationTestCase.assertTrue((String)("the schema must have additional properties set to false (\"additionalProperties\": false) in all (sub) schemas, missing at least for path: " + path), (!subSchemaFound || additionalPropertiesValidatorFound ? 1 : 0) != 0);
    }
}

