/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.transport.MockTransportClient;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.nio.MockNioTransportPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class ExternalTestCluster
extends TestCluster {
    private static final Logger logger = LogManager.getLogger(ExternalTestCluster.class);
    private static final AtomicInteger counter = new AtomicInteger();
    public static final String EXTERNAL_CLUSTER_PREFIX = "external_";
    private final MockTransportClient client;
    private final InetSocketAddress[] httpAddresses;
    private final String clusterName;
    private final int numDataNodes;
    private final int numMasterAndDataNodes;

    public ExternalTestCluster(Path tempDir, Settings additionalSettings, Collection<Class<? extends Plugin>> pluginClasses, TransportAddress ... transportAddresses) {
        super(0L);
        boolean addMockTcpTransport;
        Settings.Builder clientSettingsBuilder = Settings.builder().put(additionalSettings).put("node.name", "transport_client_external_" + counter.getAndIncrement()).put("client.transport.ignore_cluster_name", true).put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange()).put(Environment.PATH_HOME_SETTING.getKey(), tempDir);
        boolean bl = addMockTcpTransport = additionalSettings.get("transport.type") == null;
        if (addMockTcpTransport) {
            String transport = ESTestCase.getTestTransportType();
            clientSettingsBuilder.put("transport.type", transport);
            if (!pluginClasses.contains(MockNioTransportPlugin.class)) {
                pluginClasses = new ArrayList<Class<? extends Plugin>>(pluginClasses);
                pluginClasses.add(MockNioTransportPlugin.class);
            }
        }
        Settings clientSettings = clientSettingsBuilder.build();
        MockTransportClient client = new MockTransportClient(clientSettings, pluginClasses);
        try {
            client.addTransportAddresses(transportAddresses);
            NodesInfoResponse nodeInfos = (NodesInfoResponse)client.admin().cluster().prepareNodesInfo(new String[0]).clear().addMetrics(new String[]{NodesInfoRequest.Metric.SETTINGS.metricName(), NodesInfoRequest.Metric.HTTP.metricName()}).get();
            this.httpAddresses = new InetSocketAddress[nodeInfos.getNodes().size()];
            this.clusterName = nodeInfos.getClusterName().value();
            int dataNodes = 0;
            int masterAndDataNodes = 0;
            for (int i = 0; i < nodeInfos.getNodes().size(); ++i) {
                NodeInfo nodeInfo = (NodeInfo)nodeInfos.getNodes().get(i);
                this.httpAddresses[i] = ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress().address();
                if (DiscoveryNode.canContainData((Settings)nodeInfo.getSettings())) {
                    ++dataNodes;
                    ++masterAndDataNodes;
                    continue;
                }
                if (!DiscoveryNode.isMasterNode((Settings)nodeInfo.getSettings())) continue;
                ++masterAndDataNodes;
            }
            this.numDataNodes = dataNodes;
            this.numMasterAndDataNodes = masterAndDataNodes;
            this.client = client;
            logger.info("Setup ExternalTestCluster [{}] made of [{}] nodes", (Object)nodeInfos.getClusterName().value(), (Object)this.size());
        }
        catch (Exception e) {
            client.close();
            throw e;
        }
    }

    @Override
    public void afterTest() {
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public int size() {
        return this.httpAddresses.length;
    }

    @Override
    public int numDataNodes() {
        return this.numDataNodes;
    }

    @Override
    public int numDataAndMasterNodes() {
        return this.numMasterAndDataNodes;
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        return this.httpAddresses;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            NodesStatsResponse nodeStats = (NodesStatsResponse)this.client().admin().cluster().prepareNodesStats(new String[0]).clear().setIndices(true).addMetric(NodesStatsRequest.Metric.BREAKER.metricName()).execute().actionGet();
            for (NodeStats stats : nodeStats.getNodes()) {
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + stats.getNode()), (Object)stats.getBreaker().getStats("fielddata").getEstimated(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Accounting breaker not reset to " + stats.getIndices().getSegments().getMemoryInBytes() + " on node: " + stats.getNode()), (Object)stats.getBreaker().getStats("accounting").getEstimated(), (Matcher)Matchers.equalTo((Object)stats.getIndices().getSegments().getMemoryInBytes()));
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public Iterable<Client> getClients() {
        return Collections.singleton(this.client);
    }

    @Override
    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.client.getNamedWriteableRegistry();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }
}

