/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.client;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;

public class NoOpNodeClient
extends NodeClient {
    public NoOpNodeClient(ThreadPool threadPool) {
        super(Settings.EMPTY, threadPool);
    }

    public NoOpNodeClient(String testName) {
        super(Settings.EMPTY, (ThreadPool)new TestThreadPool(testName, new ExecutorBuilder[0]));
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        listener.onResponse(null);
    }

    public void initialize(Map<ActionType<? extends ActionResponse>, TransportAction<? extends ActionRequest, ? extends ActionResponse>> actions, Supplier<String> localNodeId, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        throw new UnsupportedOperationException("cannot initialize " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        listener.onResponse(null);
        return null;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
        listener.onResponse(null, null);
        return null;
    }

    public String getLocalNodeId() {
        return null;
    }

    public Client getRemoteClusterClient(String clusterAlias) {
        return null;
    }

    public void close() {
        try {
            ThreadPool.terminate((ThreadPool)this.threadPool(), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new ElasticsearchException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }
}

