/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class BlockClusterStateProcessing
extends SingleNodeDisruption {
    private final AtomicReference<CountDownLatch> disruptionLatch = new AtomicReference();

    public BlockClusterStateProcessing(String disruptedNode, Random random) {
        super(random);
        this.disruptedNode = disruptedNode;
    }

    @Override
    public void startDisrupting() {
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return;
        }
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return;
        }
        this.logger.info("delaying cluster state updates on node [{}]", (Object)disruptionNodeCopy);
        boolean success = this.disruptionLatch.compareAndSet(null, new CountDownLatch(1));
        assert (success) : "startDisrupting called without waiting on stopDisrupting to complete";
        CountDownLatch started = new CountDownLatch(1);
        clusterService.getClusterApplierService().runOnApplierThread("service_disruption_block", currentState -> {
            started.countDown();
            CountDownLatch latch = this.disruptionLatch.get();
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Throwables.rethrow((Throwable)e);
                }
            }
        }, (source, e) -> this.logger.error("unexpected error during disruption", (Throwable)e), Priority.IMMEDIATE);
        try {
            started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stopDisrupting() {
        CountDownLatch latch = this.disruptionLatch.get();
        if (latch != null) {
            latch.countDown();
        }
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

