/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.elasticsearch.Version;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;

public final class ClientYamlDocsTestClient
extends ClientYamlTestClient {
    public ClientYamlDocsTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Version masterVersion, String os, CheckedSupplier<RestClientBuilder, IOException> clientBuilderWithSniffedNodes) {
        super(restSpec, restClient, hosts, esVersion, masterVersion, os, clientBuilderWithSniffedNodes);
    }

    @Override
    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        if ("raw".equals(apiName)) {
            HashMap<String, String> queryStringParams = new HashMap<String, String>(params);
            String method = Objects.requireNonNull((String)queryStringParams.remove("method"), "Method must be set to use raw request");
            String path = "/" + Objects.requireNonNull((String)queryStringParams.remove("path"), "Path must be set to use raw request");
            Request request = new Request(method, path);
            for (Map.Entry param : queryStringParams.entrySet()) {
                request.addParameter((String)param.getKey(), (String)param.getValue());
            }
            request.setEntity(entity);
            ClientYamlDocsTestClient.setOptions(request, headers);
            try {
                Response response = this.getRestClient(nodeSelector).performRequest(request);
                return new ClientYamlTestResponse(response);
            }
            catch (ResponseException e) {
                throw new ClientYamlTestResponseException(e);
            }
        }
        return super.callApi(apiName, params, entity, headers, nodeSelector);
    }
}

