/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import org.elasticsearch.core.Tuple;

public class ClientYamlSuiteRestApi {
    private final String location;
    private final String name;
    private Set<Path> paths = new LinkedHashSet<Path>();
    private Map<String, Boolean> params = new HashMap<String, Boolean>();
    private Body body = Body.NOT_SUPPORTED;
    private Stability stability;
    private Visibility visibility;
    private String featureFlag;
    private List<String> responseMimeTypes;
    private List<String> requestMimeTypes;

    ClientYamlSuiteRestApi(String location, String name) {
        this.location = location;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    void addPath(String path, String[] methods, Set<String> parts) {
        Objects.requireNonNull(path, this.name + " API: path must not be null");
        Objects.requireNonNull(methods, this.name + " API: methods must not be null");
        if (methods.length == 0) {
            throw new IllegalArgumentException(this.name + " API: methods is empty, at least one method is required");
        }
        Objects.requireNonNull(parts, this.name + " API: parts must not be null");
        for (String part : parts) {
            if (path.contains("{" + part + "}")) continue;
            throw new IllegalArgumentException(this.name + " API: part [" + part + "] not contained in path [" + path + "]");
        }
        boolean add = this.paths.add(new Path(path, methods, parts));
        if (!add) {
            throw new IllegalArgumentException(this.name + " API: found duplicate path [" + path + "]");
        }
    }

    public Collection<Path> getPaths() {
        return this.paths;
    }

    public Map<String, Boolean> getParams() {
        return this.params;
    }

    void addParam(String param, boolean required) {
        this.params.put(param, required);
    }

    void setBodyOptional() {
        this.body = Body.OPTIONAL;
    }

    void setBodyRequired() {
        this.body = Body.REQUIRED;
    }

    public boolean isBodySupported() {
        return this.body != Body.NOT_SUPPORTED;
    }

    public boolean isBodyRequired() {
        return this.body == Body.REQUIRED;
    }

    public void setStability(String stability) {
        this.stability = Stability.valueOf(stability.toUpperCase(Locale.ROOT));
    }

    public Stability getStability() {
        return this.stability;
    }

    public void setVisibility(String visibility) {
        this.visibility = Visibility.valueOf(visibility.toUpperCase(Locale.ROOT));
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setFeatureFlag(String featureFlag) {
        this.featureFlag = featureFlag;
    }

    public String getFeatureFlag() {
        return this.featureFlag;
    }

    public void setResponseMimeTypes(List<String> mimeTypes) {
        this.responseMimeTypes = mimeTypes;
    }

    public List<String> getResponseMimeTypes() {
        return this.responseMimeTypes;
    }

    public void setRequestMimeTypes(List<String> mimeTypes) {
        this.requestMimeTypes = mimeTypes;
    }

    public List<String> getRequestMimeTypes() {
        return this.requestMimeTypes;
    }

    public List<Path> getBestMatchingPaths(Set<String> params) {
        PriorityQueue<Tuple> queue = new PriorityQueue<Tuple>(Comparator.comparing(Tuple::v1, (a, b) -> Integer.compare(b, a)));
        for (Path path : this.paths) {
            int matches = 0;
            for (String actualParameter : params) {
                if (!path.getParts().contains(actualParameter)) continue;
                ++matches;
            }
            if (matches != path.parts.size()) continue;
            queue.add(Tuple.tuple((Object)matches, (Object)path));
        }
        if (queue.isEmpty()) {
            throw new IllegalStateException("Unable to find a matching path for api [" + this.name + "]" + params);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        Tuple poll = queue.poll();
        int maxMatches = (Integer)poll.v1();
        do {
            paths.add((Path)poll.v2());
        } while ((poll = queue.poll()) != null && (Integer)poll.v1() == maxMatches);
        return paths;
    }

    public static enum Body {
        NOT_SUPPORTED,
        OPTIONAL,
        REQUIRED;

    }

    public static class Path {
        private final String path;
        private final String[] methods;
        private final Set<String> parts;

        private Path(String path, String[] methods, Set<String> parts) {
            this.path = path;
            this.methods = methods;
            this.parts = parts;
        }

        public String getPath() {
            return this.path;
        }

        public String[] getMethods() {
            return this.methods;
        }

        public Set<String> getParts() {
            return this.parts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.path.equals(path.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }

    public static enum Stability {
        EXPERIMENTAL,
        BETA,
        STABLE;

    }

    public static enum Visibility {
        PRIVATE,
        FEATURE_FLAG,
        PUBLIC;

    }
}

