/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CloseToAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(CloseToAssertion.class);
    private final double error;

    public static CloseToAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> fieldValueTuple = ParserUtils.parseTuple(parser);
        if (fieldValueTuple.v2() instanceof Map) {
            Map map = (Map)fieldValueTuple.v2();
            if (map.size() != 2) {
                throw new IllegalArgumentException("expected a map with value and error but got a map with " + map.size() + " fields");
            }
            Object valObj = map.get("value");
            if (!(valObj instanceof Number)) {
                throw new IllegalArgumentException("value is missing or not a number");
            }
            Object errObj = map.get("error");
            if (!(errObj instanceof Number)) {
                throw new IllegalArgumentException("error is missing or not a number");
            }
            return new CloseToAssertion(location, (String)fieldValueTuple.v1(), ((Number)valObj).doubleValue(), ((Number)errObj).doubleValue());
        }
        throw new IllegalArgumentException("expected a map with value and error but got " + fieldValueTuple.v2().getClass().getSimpleName());
    }

    public CloseToAssertion(XContentLocation location, String field, Double expectedValue, Double error) {
        super(location, field, expectedValue);
        this.error = error;
    }

    public final double getError() {
        return this.error;
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] is close to [{}] with error [{}] (field [{}])", actualValue, expectedValue, (Object)this.error, (Object)this.getField());
        if (!(actualValue instanceof Number)) {
            throw new AssertionError((Object)("excpected a value close to " + expectedValue + " but got " + actualValue + ", which is not a number"));
        }
        Assert.assertThat((Object)((Number)actualValue).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedValue), (double)this.error));
    }
}

