/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import io.github.nik9000.mapmatcher.ListMatcher;
import io.github.nik9000.mapmatcher.MapMatcher;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MatchAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(MatchAssertion.class);

    public static MatchAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        return new MatchAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public MatchAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        String expValue;
        if (expectedValue instanceof String && (expValue = ((String)expectedValue).trim()).length() > 2 && expValue.startsWith("/") && expValue.endsWith("/")) {
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to be of type String but is an instanceof [" + this.safeClass(actualValue) + "]"), (Object)actualValue, (Matcher)Matchers.instanceOf(String.class));
            String stringValue = (String)actualValue;
            String regex = expValue.substring(1, expValue.length() - 1);
            logger.trace("assert that [{}] matches [{}]", (Object)stringValue, (Object)regex);
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to match the provided regex but didn't"), (Object)stringValue, (Matcher)RegexMatcher.matches(regex, 4));
            return;
        }
        logger.trace("assert that [{}] matches [{}] (field [{}])", actualValue, expectedValue, (Object)this.getField());
        if (expectedValue == null) {
            Assert.assertNull((String)("field [" + this.getField() + "] should be null but was [" + actualValue + "]"), (Object)actualValue);
            return;
        }
        Assert.assertNotNull((String)("field [" + this.getField() + "] is null"), (Object)actualValue);
        if (!actualValue.getClass().equals(this.safeClass(expectedValue)) && actualValue instanceof Number && expectedValue instanceof Number) {
            Assert.assertThat((String)("field [" + this.getField() + "] doesn't match the expected value"), (Object)((Number)actualValue).doubleValue(), (Matcher)Matchers.equalTo((Object)((Number)expectedValue).doubleValue()));
            return;
        }
        if (expectedValue instanceof Map) {
            Assert.assertThat((Object)actualValue, (Matcher)Matchers.instanceOf(Map.class));
            MapMatcher.assertMap((Object)((Map)actualValue), (Matcher)MapMatcher.matchesMap((Map)((Map)expectedValue)));
        } else if (expectedValue instanceof List) {
            Assert.assertThat((Object)actualValue, (Matcher)Matchers.instanceOf(List.class));
            MapMatcher.assertMap((Object)((List)actualValue), (Matcher)ListMatcher.matchesList((List)((List)expectedValue)));
        }
        Assert.assertThat((Object)expectedValue, (Matcher)Matchers.equalTo((Object)actualValue));
    }
}

