/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.FilterXContentParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractFilteringTestCase
extends ESTestCase {
    protected static final Builder SAMPLE = AbstractFilteringTestCase.builderFor("sample.json");

    protected abstract void testFilter(Builder var1, Builder var2, Set<String> var3, Set<String> var4) throws IOException;

    protected static Builder builderFor(String file) {
        return builder -> {
            try (InputStream stream = AbstractFilteringTestCase.class.getResourceAsStream(file);){
                XContentBuilder xContentBuilder;
                block12: {
                    AbstractFilteringTestCase.assertThat((String)("Couldn't find [" + file + "]"), (Object)stream, (Matcher)Matchers.notNullValue());
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);
                    try {
                        xContentBuilder = builder.copyCurrentStructure((XContentParser)new FilterXContentParser(parser){});
                        if (parser == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return xContentBuilder;
            }
        };
    }

    public final void testNoFiltering() throws Exception {
        Builder expected = SAMPLE;
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.singleton("*"), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.singleton("**"), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("xyz"));
    }

    public final void testNoMatch() throws Exception {
        Builder expected = builder -> builder.startObject().endObject();
        this.testFilter(expected, SAMPLE, Collections.singleton("xyz"), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("*"));
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("**"));
    }

    public final void testSimpleFieldInclusive() throws Exception {
        Builder expected = builder -> builder.startObject().field("title", "My awesome book").endObject();
        this.testFilter(expected, SAMPLE, Collections.singleton("title"), Collections.emptySet());
    }

    public final void testSimpleFieldExclusive() throws Exception {
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_no_title.json"), SAMPLE, Collections.emptySet(), Collections.singleton("title"));
    }

    public final void testSimpleFieldWithWildcardInclusive() throws Exception {
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_just_pr.json"), SAMPLE, Collections.singleton("pr*"), Collections.emptySet());
    }

    public final void testSimpleFieldWithWildcardExclusive() throws Exception {
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_no_pr.json"), SAMPLE, Collections.emptySet(), Collections.singleton("pr*"));
    }

    public final void testMultipleFieldsInclusive() throws Exception {
        Builder expected = builder -> builder.startObject().field("title", "My awesome book").field("pages", 456).endObject();
        this.testFilter(expected, SAMPLE, Sets.newHashSet((Object[])new String[]{"title", "pages"}), Collections.emptySet());
    }

    public final void testMultipleFieldsExclusive() throws Exception {
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_no_title_pages.json"), SAMPLE, Collections.emptySet(), Sets.newHashSet((Object[])new String[]{"title", "pages"}));
    }

    public final void testSimpleArrayInclusive() throws Exception {
        Builder expected = builder -> builder.startObject().startArray("tags").value("elasticsearch").value("java").endArray().endObject();
        this.testFilter(expected, SAMPLE, Collections.singleton("tags"), Collections.emptySet());
    }

    public final void testSimpleArrayExclusive() throws Exception {
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_no_tags.json"), SAMPLE, Collections.emptySet(), Collections.singleton("tags"));
    }

    public final void testSimpleArrayOfObjectsInclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_just_authors.json");
        this.testFilter(expected, SAMPLE, Collections.singleton("authors"), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.singleton("authors.*"), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.singleton("authors.*name"), Collections.emptySet());
    }

    public final void testSimpleArrayOfObjectsExclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_no_authors.json");
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("authors"));
        if (this.removesEmptyArrays()) {
            this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("authors.*"));
            this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("authors.*name"));
        }
    }

    protected abstract boolean removesEmptyArrays();

    public void testSimpleArrayOfObjectsPropertyInclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_just_authors_lastname.json");
        this.testFilter(expected, SAMPLE, Collections.singleton("authors.lastname"), Collections.emptySet());
        this.testFilter(expected, SAMPLE, Collections.singleton("authors.l*"), Collections.emptySet());
    }

    public void testSimpleArrayOfObjectsPropertyExclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_no_authors_lastname.json");
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("authors.lastname"));
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("authors.l*"));
    }

    public void testRecurseField1Inclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_just_names.json");
        this.testFilter(expected, SAMPLE, Collections.singleton("**.name"), Collections.emptySet());
    }

    public void testRecurseField1Exclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_no_names.json");
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("**.name"));
    }

    public void testRecurseField2Inclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_just_properties_names.json");
        this.testFilter(expected, SAMPLE, Collections.singleton("properties.**.name"), Collections.emptySet());
    }

    public void testRecurseField2Exclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_no_properties_names.json");
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("properties.**.name"));
    }

    public void testRecurseField3Inclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_just_properties_en_names.json");
        this.testFilter(expected, SAMPLE, Collections.singleton("properties.*.en.**.name"), Collections.emptySet());
    }

    public void testRecurseField3Exclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_no_properties_en_names.json");
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("properties.*.en.**.name"));
    }

    public void testRecurseField4Inclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_just_properties_distributors_names.json");
        this.testFilter(expected, SAMPLE, Collections.singleton("properties.**.distributors.name"), Collections.emptySet());
    }

    public void testRecurseField4Exclusive() throws Exception {
        Builder expected = AbstractFilteringTestCase.builderFor("sample_no_properties_distributors_names.json");
        this.testFilter(expected, SAMPLE, Collections.emptySet(), Collections.singleton("properties.**.distributors.name"));
    }

    public void testRawField() throws Exception {
        Builder expectedRawField = builder -> {
            builder.startObject();
            builder.field("foo", 0);
            builder.startObject("raw").field("content", "hello world!").endObject();
            return builder.endObject();
        };
        Builder expectedRawFieldRemoved = builder -> {
            builder.startObject();
            builder.field("foo", 0);
            return builder.endObject();
        };
        Builder expectedRawFieldIncluded = builder -> {
            builder.startObject();
            builder.startObject("raw").field("content", "hello world!").endObject();
            return builder.endObject();
        };
        Builder sampleWithRaw = builder -> {
            BytesReference raw = BytesReference.bytes((XContentBuilder)XContentBuilder.builder((XContent)builder.contentType().xContent()).startObject().field("content", "hello world!").endObject());
            return builder.startObject().field("foo", 0).rawField("raw", (InputStream)raw.streamInput()).endObject();
        };
        this.testFilter(expectedRawField, sampleWithRaw, Collections.emptySet(), Collections.emptySet());
        this.testFilter(expectedRawFieldRemoved, sampleWithRaw, Collections.singleton("f*"), Collections.emptySet());
        this.testFilter(expectedRawFieldRemoved, sampleWithRaw, Collections.emptySet(), Collections.singleton("r*"));
        this.testFilter(expectedRawFieldIncluded, sampleWithRaw, Collections.singleton("r*"), Collections.emptySet());
        this.testFilter(expectedRawFieldIncluded, sampleWithRaw, Collections.emptySet(), Collections.singleton("f*"));
        sampleWithRaw = builder -> {
            BytesReference raw = BytesReference.bytes((XContentBuilder)XContentBuilder.builder((XContent)builder.contentType().xContent()).startObject().field("content", "hello world!").endObject());
            return builder.startObject().field("foo", 0).rawField("raw", (InputStream)raw.streamInput(), builder.contentType()).endObject();
        };
        this.testFilter(expectedRawField, sampleWithRaw, Collections.emptySet(), Collections.emptySet());
        this.testFilter(expectedRawFieldRemoved, sampleWithRaw, Collections.singleton("f*"), Collections.emptySet());
        this.testFilter(expectedRawFieldRemoved, sampleWithRaw, Collections.emptySet(), Collections.singleton("r*"));
        this.testFilter(expectedRawFieldIncluded, sampleWithRaw, Collections.singleton("r*"), Collections.emptySet());
        this.testFilter(expectedRawFieldIncluded, sampleWithRaw, Collections.emptySet(), Collections.singleton("f*"));
    }

    public void testArrays() throws Exception {
        Builder sampleArrayOfValues = builder -> {
            builder.startObject();
            builder.startArray("tags").value("lorem").value("ipsum").value("dolor").endArray();
            return builder.endObject();
        };
        this.testFilter(sampleArrayOfValues, sampleArrayOfValues, Collections.singleton("t*"), Collections.emptySet());
        this.testFilter(sampleArrayOfValues, sampleArrayOfValues, Collections.singleton("tags"), Collections.emptySet());
        this.testFilter(sampleArrayOfValues, sampleArrayOfValues, Collections.emptySet(), Collections.singleton("a"));
        Builder expected = builder -> builder.startObject().endObject();
        this.testFilter(expected, sampleArrayOfValues, Collections.singleton("foo"), Collections.emptySet());
        this.testFilter(expected, sampleArrayOfValues, Collections.emptySet(), Collections.singleton("t*"));
        this.testFilter(expected, sampleArrayOfValues, Collections.emptySet(), Collections.singleton("tags"));
        Builder sampleArrayOfObjects = builder -> {
            builder.startObject();
            builder.startArray("tags");
            builder.startObject().field("lastname", "lorem").endObject();
            builder.startObject().field("firstname", "ipsum").endObject();
            builder.endArray();
            return builder.endObject();
        };
        this.testFilter(sampleArrayOfObjects, sampleArrayOfObjects, Collections.singleton("t*"), Collections.emptySet());
        this.testFilter(sampleArrayOfObjects, sampleArrayOfObjects, Collections.singleton("tags"), Collections.emptySet());
        this.testFilter(sampleArrayOfObjects, sampleArrayOfObjects, Collections.emptySet(), Collections.singleton("a"));
        this.testFilter(expected, sampleArrayOfObjects, Collections.singleton("foo"), Collections.emptySet());
        this.testFilter(expected, sampleArrayOfObjects, Collections.emptySet(), Collections.singleton("t*"));
        this.testFilter(expected, sampleArrayOfObjects, Collections.emptySet(), Collections.singleton("tags"));
        expected = builder -> {
            builder.startObject();
            builder.startArray("tags");
            builder.startObject().field("firstname", "ipsum").endObject();
            builder.endArray();
            return builder.endObject();
        };
        this.testFilter(expected, sampleArrayOfObjects, Collections.singleton("t*.firstname"), Collections.emptySet());
        this.testFilter(expected, sampleArrayOfObjects, Collections.emptySet(), Collections.singleton("t*.lastname"));
    }

    public void testEmptyObject() throws IOException {
        Builder sample = builder -> builder.startObject().startObject("foo").endObject().endObject();
        Builder expected = builder -> builder.startObject().startObject("foo").endObject().endObject();
        this.testFilter(expected, sample, Collections.singleton("foo"), Collections.emptySet());
        this.testFilter(expected, sample, Collections.emptySet(), Collections.singleton("bar"));
        this.testFilter(expected, sample, Collections.singleton("f*"), Collections.singleton("baz"));
        expected = builder -> builder.startObject().endObject();
        this.testFilter(expected, sample, Collections.emptySet(), Collections.singleton("foo"));
        this.testFilter(expected, sample, Collections.singleton("bar"), Collections.emptySet());
        this.testFilter(expected, sample, Collections.singleton("f*"), Collections.singleton("foo"));
    }

    public void testSingleFieldWithBothExcludesIncludes() throws IOException {
        Builder expected = builder -> builder.startObject().field("pages", 456).field("price", 27.99).endObject();
        this.testFilter(expected, SAMPLE, Collections.singleton("p*"), Collections.singleton("properties"));
    }

    public void testObjectsInArrayWithBothExcludesIncludes() throws IOException {
        HashSet includes = Sets.newHashSet((Object[])new String[]{"tags", "authors"});
        Set<String> excludes = Collections.singleton("authors.name");
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_just_tags_authors_no_name.json"), SAMPLE, includes, excludes);
    }

    public void testRecursiveObjectsInArrayWithBothExcludesIncludes() throws IOException {
        HashSet includes = Sets.newHashSet((Object[])new String[]{"**.language", "properties.weight"});
        Set<String> excludes = Collections.singleton("**.distributors");
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_just_properties_no_distributors.json"), SAMPLE, includes, excludes);
    }

    public void testRecursiveSameObjectWithBothExcludesIncludes() throws IOException {
        Set<String> includes = Collections.singleton("**.distributors");
        Set<String> excludes = Collections.singleton("**.distributors");
        Builder expected = builder -> builder.startObject().endObject();
        this.testFilter(expected, SAMPLE, includes, excludes);
    }

    public void testRecursiveObjectsPropertiesWithBothExcludesIncludes() throws IOException {
        Set<String> includes = Collections.singleton("**.en.*");
        HashSet excludes = Sets.newHashSet((Object[])new String[]{"**.distributors.*.name", "**.street"});
        this.testFilter(AbstractFilteringTestCase.builderFor("sample_just_properties_en_no_distributors_name_no_street.json"), SAMPLE, includes, excludes);
    }

    public void testWithLfAtEnd() throws IOException {
        Builder sample = builder -> {
            builder.startObject();
            builder.startObject("foo").field("bar", "baz").endObject();
            return builder.endObject().prettyPrint().lfAtEnd();
        };
        this.testFilter(sample, sample, Collections.singleton("foo"), Collections.emptySet());
        this.testFilter(sample, sample, Collections.emptySet(), Collections.singleton("bar"));
        this.testFilter(sample, sample, Collections.singleton("f*"), Collections.singleton("baz"));
        Builder expected = builder -> builder.startObject().endObject().prettyPrint().lfAtEnd();
        this.testFilter(expected, sample, Collections.emptySet(), Collections.singleton("foo"));
        this.testFilter(expected, sample, Collections.singleton("bar"), Collections.emptySet());
        this.testFilter(expected, sample, Collections.singleton("f*"), Collections.singleton("foo"));
    }

    public void testBasics() throws Exception {
        Builder sample = builder -> builder.startObject().field("test1", "value1").field("test2", "value2").field("something_else", "value3").endObject();
        Builder expected = builder -> builder.startObject().field("test1", "value1").endObject();
        this.testFilter(expected, sample, Collections.singleton("test1"), Collections.emptySet());
        expected = builder -> builder.startObject().field("test1", "value1").field("test2", "value2").endObject();
        this.testFilter(expected, sample, Collections.singleton("test*"), Collections.emptySet());
        expected = builder -> builder.startObject().field("test2", "value2").field("something_else", "value3").endObject();
        this.testFilter(expected, sample, Collections.emptySet(), Collections.singleton("test1"));
        Builder complex = builder -> {
            builder.startObject();
            builder.startObject("path1");
            builder.startArray("path2");
            builder.startObject().field("test", "value1").endObject();
            builder.startObject().field("test", "value2").endObject();
            builder.endArray();
            builder.endObject();
            builder.field("test1", "value1");
            return builder.endObject();
        };
        expected = builder -> {
            builder.startObject();
            builder.startObject("path1");
            builder.startArray("path2");
            builder.startObject().field("test", "value1").endObject();
            builder.startObject().field("test", "value2").endObject();
            builder.endArray();
            builder.endObject();
            return builder.endObject();
        };
        this.testFilter(expected, complex, Collections.singleton("path1"), Collections.emptySet());
        this.testFilter(expected, complex, Collections.singleton("path1*"), Collections.emptySet());
        this.testFilter(expected, complex, Collections.singleton("path1.path2.*"), Collections.emptySet());
        expected = builder -> builder.startObject().field("test1", "value1").endObject();
        this.testFilter(expected, complex, Collections.singleton("test1*"), Collections.emptySet());
    }

    public void testFilterSupplementaryCharactersInPaths() throws IOException {
        Builder sample = builder -> builder.startObject().field("\u641c\u7d22", 2).field("\u6307\u6570", 3).endObject();
        Builder expected = builder -> builder.startObject().field("\u641c\u7d22", 2).endObject();
        this.testFilter(expected, sample, Collections.singleton("\u641c\u7d22"), Collections.emptySet());
        expected = builder -> builder.startObject().field("\u6307\u6570", 3).endObject();
        this.testFilter(expected, sample, Collections.emptySet(), Collections.singleton("\u641c\u7d22"));
    }

    public void testFilterSharedPrefixes() throws IOException {
        Builder sample = builder -> builder.startObject().field("foobar", 2).field("foobaz", 3).endObject();
        Builder expected = builder -> builder.startObject().field("foobar", 2).endObject();
        this.testFilter(expected, sample, Collections.singleton("foobar"), Collections.emptySet());
        expected = builder -> builder.startObject().field("foobaz", 3).endObject();
        this.testFilter(expected, sample, Collections.emptySet(), Collections.singleton("foobar"));
    }

    public void testFilterPrefix() throws IOException {
        Builder sample = builder -> builder.startObject().array("photos", new String[]{"foo", "bar"}).field("photosCount", 2).endObject();
        Builder expected = builder -> builder.startObject().field("photosCount", 2).endObject();
        this.testFilter(expected, sample, Collections.singleton("photosCount"), Collections.emptySet());
    }

    public void testManyFilters() throws IOException, URISyntaxException {
        Builder deep = builder -> builder.startObject().startObject("system").startObject("process").startObject("cgroup").startObject("memory").startObject("stats").startObject("mapped_file").field("bytes", 100).endObject().endObject().endObject().endObject().endObject().endObject().endObject();
        try (InputStream stream = AbstractFilteringTestCase.class.getResourceAsStream("many_filters.txt");){
            AbstractFilteringTestCase.assertThat((String)"Couldn't find [many_filters.txt]", (Object)stream, (Matcher)Matchers.notNullValue());
            Set<String> manyFilters = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().filter(s -> false == s.startsWith("#")).collect(Collectors.toSet());
            this.testFilter(deep, deep, manyFilters, Collections.emptySet());
        }
    }

    @FunctionalInterface
    protected static interface Builder
    extends CheckedFunction<XContentBuilder, XContentBuilder, IOException> {
    }
}

