/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractWireTestCase<T>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    protected abstract T createTestInstance();

    protected T mutateInstance(T instance) throws IOException {
        return null;
    }

    public final void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestInstance(), this::copyInstance, this::mutateInstance);
        }
    }

    public final void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            T testInstance = this.createTestInstance();
            this.assertSerialization(testInstance);
        }
    }

    protected final void assertSerialization(T testInstance) throws IOException {
        this.assertSerialization(testInstance, Version.CURRENT);
    }

    protected final void assertSerialization(T testInstance, Version version) throws IOException {
        T deserializedInstance = this.copyInstance(testInstance, version);
        this.assertEqualInstances(testInstance, deserializedInstance);
    }

    protected void assertEqualInstances(T expectedInstance, T newInstance) {
        AbstractWireTestCase.assertNotSame(newInstance, expectedInstance);
        AbstractWireTestCase.assertThat(newInstance, (Matcher)Matchers.equalTo(expectedInstance));
        AbstractWireTestCase.assertThat((Object)newInstance.hashCode(), (Matcher)Matchers.equalTo((Object)expectedInstance.hashCode()));
    }

    protected final T copyInstance(T instance) throws IOException {
        return this.copyInstance(instance, Version.CURRENT);
    }

    protected abstract T copyInstance(T var1, Version var2) throws IOException;

    protected NamedWriteableRegistry getNamedWriteableRegistry() {
        return new NamedWriteableRegistry(Collections.emptyList());
    }
}

