/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.mockito;

import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.test.mockito.SecureMockUtil;
import org.mockito.MockedConstruction;
import org.mockito.internal.creation.bytebuddy.SubclassByteBuddyMockMaker;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;

public class SecureMockMaker
implements MockMaker {
    private final SubclassByteBuddyMockMaker delegate = SecureMockUtil.wrap(SubclassByteBuddyMockMaker::new);

    public static void init() {
        SecureMockUtil.init();
    }

    public <T> T createMock(MockCreationSettings<T> mockCreationSettings, MockHandler mockHandler) {
        return (T)SecureMockUtil.wrap(() -> this.delegate.createMock(mockCreationSettings, mockHandler));
    }

    public <T> Optional<T> createSpy(MockCreationSettings<T> settings, MockHandler handler, T object) {
        return SecureMockUtil.wrap(() -> {
            Object instance = this.delegate.createMock(settings, handler);
            new LenientCopyTool().copyToMock(object, instance);
            return Optional.of(instance);
        });
    }

    public MockHandler getHandler(Object o) {
        return this.delegate.getHandler(o);
    }

    public void resetMock(Object o, MockHandler mockHandler, MockCreationSettings mockCreationSettings) {
        SecureMockUtil.wrap(() -> {
            this.delegate.resetMock(o, mockHandler, mockCreationSettings);
            return null;
        });
    }

    public MockMaker.TypeMockability isTypeMockable(Class<?> type) {
        return this.delegate.isTypeMockable(type);
    }

    public <T> MockMaker.StaticMockControl<T> createStaticMock(Class<T> type, MockCreationSettings<T> settings, MockHandler handler) {
        return this.delegate.createStaticMock(type, settings, handler);
    }

    public <T> MockMaker.ConstructionMockControl<T> createConstructionMock(Class<T> type, Function<MockedConstruction.Context, MockCreationSettings<T>> settingsFactory, Function<MockedConstruction.Context, MockHandler<T>> handlerFactory, MockedConstruction.MockInitializer<T> mockInitializer) {
        return this.delegate.createConstructionMock(type, settingsFactory, handlerFactory, mockInitializer);
    }

    public void clearAllCaches() {
        this.delegate.clearAllCaches();
    }
}

