/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.test.ESTestCase;

public class ClusterStateCreationUtils {
    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRoutingState ... replicaStates) {
        int numberOfReplicas = replicaStates.length;
        int numberOfNodes = numberOfReplicas + 1;
        if (primaryState == ShardRoutingState.RELOCATING) {
            ++numberOfNodes;
        }
        for (ShardRoutingState state : replicaStates) {
            if (state != ShardRoutingState.RELOCATING) continue;
            ++numberOfNodes;
        }
        numberOfNodes = Math.max(2, numberOfNodes);
        ShardId shardId = new ShardId(index, "_na_", 0);
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> unassignedNodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            unassignedNodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        int primaryTerm = 1 + ESTestCase.randomInt(200);
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", 1).put("index.number_of_replicas", numberOfReplicas).put("index.creation_date", System.currentTimeMillis())).primaryTerm(0, (long)primaryTerm).timestampRange(primaryState == ShardRoutingState.STARTED || primaryState == ShardRoutingState.RELOCATING ? IndexLongFieldRange.UNKNOWN : IndexLongFieldRange.NO_SHARDS).build();
        IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
        String primaryNode = null;
        String relocatingNode = null;
        UnassignedInfo unassignedInfo = null;
        if (primaryState != ShardRoutingState.UNASSIGNED) {
            if (activePrimaryLocal) {
                primaryNode = ClusterStateCreationUtils.newNode(0).getId();
                unassignedNodes.remove(primaryNode);
            } else {
                ShardRoutingState[] unassignedNodesExecludingPrimary = new HashSet(unassignedNodes);
                unassignedNodesExecludingPrimary.remove(ClusterStateCreationUtils.newNode(0).getId());
                primaryNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodesExecludingPrimary);
                unassignedNodes.remove(primaryNode);
            }
            if (primaryState == ShardRoutingState.RELOCATING) {
                relocatingNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
            } else if (primaryState == ShardRoutingState.INITIALIZING) {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
            }
        } else {
            unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
        }
        indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, 0, primaryNode, relocatingNode, true, primaryState, unassignedInfo));
        for (ShardRoutingState replicaState : replicaStates) {
            String replicaNode = null;
            relocatingNode = null;
            unassignedInfo = null;
            if (replicaState != ShardRoutingState.UNASSIGNED) {
                assert (primaryNode != null) : "a replica is assigned but the primary isn't";
                replicaNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
                if (replicaState == ShardRoutingState.RELOCATING) {
                    relocatingNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
                }
            } else {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
            }
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, shardId.id(), replicaNode, relocatingNode, false, replicaState, unassignedInfo));
        }
        IndexShardRoutingTable indexShardRoutingTable = indexShardRoutingBuilder.build();
        IndexMetadata.Builder indexMetadataBuilder = new IndexMetadata.Builder(indexMetadata);
        indexMetadataBuilder.putInSyncAllocationIds(0, indexShardRoutingTable.activeShards().stream().map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet()));
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(indexMetadataBuilder.build(), false).generateClusterUuidIfNeeded());
        state.routingTable(RoutingTable.builder().add(IndexRoutingTable.builder((Index)indexMetadata.getIndex()).addIndexShard(indexShardRoutingTable)).build());
        return state.build();
    }

    public static ClusterState state(String index, int numberOfNodes, int numberOfPrimaries) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            nodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId((String)ESTestCase.randomFrom(nodes));
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", numberOfPrimaries).put("index.number_of_replicas", 0).put("index.creation_date", System.currentTimeMillis())).build();
        IndexRoutingTable.Builder indexRoutingTable = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
        for (int i = 0; i < numberOfPrimaries; ++i) {
            ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
            IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, (String)ESTestCase.randomFrom(nodes), true, ShardRoutingState.STARTED));
            indexRoutingTable.addIndexShard(indexShardRoutingBuilder.build());
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(indexMetadata, false).generateClusterUuidIfNeeded());
        state.routingTable(RoutingTable.builder().add(indexRoutingTable).build());
        return state.build();
    }

    public static ClusterState state(int numberOfNodes, String[] indices, int numberOfPrimaries) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            nodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(0).getId());
        Metadata.Builder metadata = Metadata.builder();
        RoutingTable.Builder routingTable = RoutingTable.builder();
        ArrayList nodesList = new ArrayList(nodes);
        int currentNodeToAssign = 0;
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", numberOfPrimaries).put("index.number_of_replicas", 0).put("index.creation_date", System.currentTimeMillis())).build();
            IndexRoutingTable.Builder indexRoutingTable = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfPrimaries; ++i) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, (String)nodesList.get(currentNodeToAssign++), true, ShardRoutingState.STARTED));
                if (currentNodeToAssign == nodesList.size()) {
                    currentNodeToAssign = 0;
                }
                indexRoutingTable.addIndexShard(indexShardRoutingBuilder.build());
            }
            metadata.put(indexMetadata, false);
            routingTable.add(indexRoutingTable);
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(metadata.generateClusterUuidIfNeeded().build());
        state.routingTable(routingTable.build());
        return state.build();
    }

    public static ClusterState stateWithAssignedPrimariesAndOneReplica(String index, int numberOfShards) {
        int numberOfNodes = 2;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", numberOfShards).put("index.number_of_replicas", 1).put("index.creation_date", System.currentTimeMillis())).build();
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(indexMetadata, false).generateClusterUuidIfNeeded());
        IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
        for (int i = 0; i < numberOfShards; ++i) {
            ShardId shardId = new ShardId(index, "_na_", i);
            IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(0).getId(), null, true, ShardRoutingState.STARTED));
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(1).getId(), null, false, ShardRoutingState.STARTED));
            indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder.build());
        }
        state.routingTable(RoutingTable.builder().add(indexRoutingTableBuilder.build()).build());
        return state.build();
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(String[] indices, int numberOfShards, int numberOfReplicas) {
        int numberOfDataNodes = numberOfReplicas + 1;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfDataNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(numberOfDataNodes + 1).getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        Metadata.Builder metadataBuilder = Metadata.builder();
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", numberOfShards).put("index.number_of_replicas", numberOfReplicas).put("index.creation_date", System.currentTimeMillis())).timestampRange(IndexLongFieldRange.UNKNOWN).build();
            metadataBuilder.put(indexMetadata, false).generateClusterUuidIfNeeded();
            IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(index, "_na_", i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(0).getId(), null, true, ShardRoutingState.STARTED));
                for (int replica = 0; replica < numberOfReplicas; ++replica) {
                    indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(replica + 1).getId(), null, false, ShardRoutingState.STARTED));
                }
                indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder.build());
            }
            routingTableBuilder.add(indexRoutingTableBuilder.build());
        }
        state.metadata(metadataBuilder);
        state.routingTable(routingTableBuilder.build());
        return state.build();
    }

    public static ClusterState stateWithActivePrimary(String index, boolean activePrimaryLocal, int numberOfReplicas) {
        int assignedReplicas = ESTestCase.randomIntBetween(0, numberOfReplicas);
        return ClusterStateCreationUtils.stateWithActivePrimary(index, activePrimaryLocal, assignedReplicas, numberOfReplicas - assignedReplicas);
    }

    public static ClusterState stateWithActivePrimary(String index, boolean activePrimaryLocal, int assignedReplicas, int unassignedReplicas) {
        int i;
        ShardRoutingState[] replicaStates = new ShardRoutingState[assignedReplicas + unassignedReplicas];
        for (i = 0; i < assignedReplicas; ++i) {
            replicaStates[i] = ESTestCase.randomFrom(ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED, ShardRoutingState.RELOCATING);
        }
        for (i = assignedReplicas; i < replicaStates.length; ++i) {
            replicaStates[i] = ShardRoutingState.UNASSIGNED;
        }
        return ClusterStateCreationUtils.state(index, activePrimaryLocal, ESTestCase.randomFrom(ShardRoutingState.STARTED, ShardRoutingState.RELOCATING), replicaStates);
    }

    public static ClusterState stateWithNoShard() {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().generateClusterUuidIfNeeded());
        state.routingTable(RoutingTable.builder().build());
        return state.build();
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode ... allNodes) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (DiscoveryNode node : allNodes) {
            discoBuilder.add(node);
        }
        if (masterNode != null) {
            discoBuilder.masterNodeId(masterNode.getId());
        }
        discoBuilder.localNodeId(localNode.getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().generateClusterUuidIfNeeded());
        return state.build();
    }

    private static DiscoveryNode newNode(int nodeId) {
        return new DiscoveryNode("node_" + nodeId, ESTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), new HashSet(DiscoveryNodeRole.BUILT_IN_ROLES), Version.CURRENT);
    }

    private static String selectAndRemove(Set<String> strings) {
        String selection = ESTestCase.randomFrom(strings.toArray(new String[strings.size()]));
        strings.remove(selection);
        return selection;
    }
}

