/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class GeoShapeIntegTestCase
extends ESIntegTestCase {
    protected abstract void getGeoShapeMapping(XContentBuilder var1) throws IOException;

    protected abstract boolean allowExpensiveQueries();

    @Override
    protected boolean forbidPrivateIndexSettings() {
        return false;
    }

    public void testOrientationPersistence() throws Exception {
        String idxName = "orientation";
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("location");
        this.getGeoShapeMapping(mapping);
        mapping.field("orientation", "left").endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate(idxName).addMapping("shape", mapping));
        mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("location");
        this.getGeoShapeMapping(mapping);
        mapping.field("orientation", "right").endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate(idxName + "2").addMapping("shape", mapping));
        this.ensureGreen(idxName, idxName + "2");
        GeoShapeIntegTestCase.internalCluster().fullRestart();
        this.ensureGreen(idxName, idxName + "2");
        IndicesService indicesService = GeoShapeIntegTestCase.internalCluster().getInstance(IndicesService.class, this.findNodeName(idxName));
        IndexService indexService = indicesService.indexService(GeoShapeIntegTestCase.resolveIndex(idxName));
        MappedFieldType fieldType = indexService.mapperService().fieldType("location");
        GeoShapeIntegTestCase.assertThat((Object)fieldType, (Matcher)Matchers.instanceOf(AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType.class));
        AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType gsfm = (AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType)fieldType;
        Orientation orientation = gsfm.orientation();
        GeoShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.CLOCKWISE));
        GeoShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.LEFT));
        GeoShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.CW));
        indicesService = GeoShapeIntegTestCase.internalCluster().getInstance(IndicesService.class, this.findNodeName(idxName + "2"));
        indexService = indicesService.indexService(GeoShapeIntegTestCase.resolveIndex(idxName + "2"));
        fieldType = indexService.mapperService().fieldType("location");
        GeoShapeIntegTestCase.assertThat((Object)fieldType, (Matcher)Matchers.instanceOf(AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType.class));
        gsfm = (AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType)fieldType;
        orientation = gsfm.orientation();
        GeoShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.COUNTER_CLOCKWISE));
        GeoShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.RIGHT));
        GeoShapeIntegTestCase.assertThat((Object)orientation, (Matcher)Matchers.equalTo((Object)Orientation.CCW));
    }

    public void testIgnoreMalformed() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.field("ignore_malformed", true).endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").addMapping("shape", mapping));
        this.ensureGreen(new String[0]);
        String polygonGeoJson = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("type", "Polygon").startArray("coordinates").startArray().startArray().value(176.0).value(15.0).endArray().startArray().value(-177.0).value(10.0).endArray().startArray().value(-177.0).value(-10.0).endArray().startArray().value(176.0).value(-15.0).endArray().startArray().value(-177.0).value(15.0).endArray().startArray().value(172.0).value(0.0).endArray().startArray().value(176.0).value(15.0).endArray().endArray().endArray().endObject());
        this.indexRandom(true, GeoShapeIntegTestCase.client().prepareIndex("test", "shape").setId("0").setSource(new Object[]{"shape", polygonGeoJson}));
        SearchResponse searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    public void testIndexShapeRouting() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_routing").field("required", true).endObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked(this.prepareCreate("test").addMapping("shape", mapping));
        this.ensureGreen(new String[0]);
        String source = "{\n    \"shape\" : {\n        \"type\" : \"bbox\",\n        \"coordinates\" : [[-45.0, 45.0], [45.0, -45.0]]\n    }\n}";
        this.indexRandom(true, GeoShapeIntegTestCase.client().prepareIndex("test", "shape").setId("0").setSource(source, XContentType.JSON).setRouting("ABC"));
        SearchResponse searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (String)"0").indexedShapeIndex("test")).indexedShapeRouting("ABC")).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    public void testIndexPolygonDateLine() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)GeoShapeIntegTestCase.client().admin().indices().prepareCreate("test").addMapping("shape", mapping).get());
        this.ensureGreen(new String[0]);
        String source = "{\n    \"shape\" : \"POLYGON((179 0, -179 0, -179 2, 179 2, 179 0))\"}";
        this.indexRandom(true, GeoShapeIntegTestCase.client().prepareIndex("test", "shape").setId("0").setSource(source, XContentType.JSON));
        SearchResponse searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(-179.75, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(90.0, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)0L));
        searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(-180.0, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(180.0, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisallowExpensiveQueries() throws InterruptedException, IOException {
        ClusterUpdateSettingsRequest updateSettingsRequest;
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)GeoShapeIntegTestCase.client().admin().indices().prepareCreate("test").addMapping("shape", mapping).get());
        this.ensureGreen(new String[0]);
        String source = "{\n    \"shape\" : {\n        \"type\" : \"bbox\",\n        \"coordinates\" : [[-45.0, 45.0], [45.0, -45.0]]\n    }\n}";
        this.indexRandom(true, GeoShapeIntegTestCase.client().prepareIndex("test", "shape").setId("0").setSource(source, XContentType.JSON));
        this.refresh(new String[0]);
        try {
            updateSettingsRequest = new ClusterUpdateSettingsRequest();
            updateSettingsRequest.persistentSettings(Settings.builder().put("search.allow_expensive_queries", false));
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)GeoShapeIntegTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
            SearchRequestBuilder builder = GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Circle(0.0, 0.0, 77000.0)));
            if (this.allowExpensiveQueries()) {
                GeoShapeIntegTestCase.assertThat((Object)((SearchResponse)builder.get()).getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            } else {
                ElasticsearchException e = (ElasticsearchException)GeoShapeIntegTestCase.expectThrows(ElasticsearchException.class, () -> ((SearchRequestBuilder)builder).get());
                GeoShapeIntegTestCase.assertEquals((Object)"[geo-shape] queries on [PrefixTree geo shapes] cannot be executed when 'search.allow_expensive_queries' is set to false.", (Object)e.getCause().getMessage());
            }
            updateSettingsRequest = new ClusterUpdateSettingsRequest();
            updateSettingsRequest.persistentSettings(Settings.builder().put("search.allow_expensive_queries", (String)null));
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)GeoShapeIntegTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
            GeoShapeIntegTestCase.assertThat((Object)((SearchResponse)builder.get()).getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
            updateSettingsRequest = new ClusterUpdateSettingsRequest();
            updateSettingsRequest.persistentSettings(Settings.builder().put("search.allow_expensive_queries", true));
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)GeoShapeIntegTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
            GeoShapeIntegTestCase.assertThat((Object)((SearchResponse)builder.get()).getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        }
        finally {
            updateSettingsRequest = new ClusterUpdateSettingsRequest();
            updateSettingsRequest.persistentSettings(Settings.builder().put("search.allow_expensive_queries", (String)null));
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)GeoShapeIntegTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
        }
    }

    public void testShapeRelations() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("area");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        CreateIndexRequestBuilder mappingRequest = GeoShapeIntegTestCase.client().admin().indices().prepareCreate("shapes").addMapping("shape", mapping);
        mappingRequest.get();
        GeoShapeIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForGreenStatus().get();
        List polygons = org.elasticsearch.core.List.of((Object)new Polygon(new LinearRing(new double[]{-10.0, -10.0, 10.0, 10.0, -10.0}, new double[]{-10.0, 10.0, 10.0, -10.0, -10.0}), org.elasticsearch.core.List.of((Object)new LinearRing(new double[]{-5.0, -5.0, 5.0, 5.0, -5.0}, new double[]{-5.0, 5.0, 5.0, -5.0, -5.0}))), (Object)new Polygon(new LinearRing(new double[]{-4.0, -4.0, 4.0, 4.0, -4.0}, new double[]{-4.0, 4.0, 4.0, -4.0, -4.0})));
        BytesReference data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)new MultiPolygon(polygons))).endObject());
        GeoShapeIntegTestCase.client().prepareIndex("shapes", "shape").setId("1").setSource(data, XContentType.JSON).get();
        GeoShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        SearchResponse result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(3.0, 3.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(4.5, 4.5))).get();
        ElasticsearchAssertions.assertHitCount(result, 0L);
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(10.0, 5.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(5.0, 2.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoDisjointQuery((String)"area", (Geometry)new Point(3.0, 3.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 0L);
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoDisjointQuery((String)"area", (Geometry)new Point(4.5, 4.5))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("1"));
        Polygon inverse = new Polygon(new LinearRing(new double[]{-5.0, -5.0, 5.0, 5.0, -5.0}, new double[]{-5.0, 5.0, 5.0, -5.0, -5.0}), org.elasticsearch.core.List.of((Object)new LinearRing(new double[]{-4.0, -4.0, 4.0, 4.0, -4.0}, new double[]{-4.0, 4.0, 4.0, -4.0, -4.0})));
        data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)inverse)).endObject());
        GeoShapeIntegTestCase.client().prepareIndex("shapes", "shape").setId("2").setSource(data, XContentType.JSON).get();
        GeoShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(4.5, 4.5))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        ElasticsearchAssertions.assertFirstHit(result, ElasticsearchAssertions.hasId("2"));
        Polygon WithIn = new Polygon(new LinearRing(new double[]{-30.0, -30.0, 30.0, 30.0, -30.0}, new double[]{-30.0, 30.0, 30.0, -30.0, -30.0}));
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoWithinQuery((String)"area", (Geometry)WithIn)).get();
        ElasticsearchAssertions.assertHitCount(result, 2L);
        Polygon crossing = new Polygon(new LinearRing(new double[]{170.0, 190.0, 190.0, 170.0, 170.0}, new double[]{-10.0, -10.0, 10.0, 10.0, -10.0}));
        data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)crossing)).endObject());
        GeoShapeIntegTestCase.client().prepareIndex("shapes", "shape").setId("1").setSource(data, XContentType.JSON).get();
        GeoShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        crossing = new Polygon(new LinearRing(new double[]{170.0, 190.0, 190.0, 170.0, 170.0}, new double[]{-10.0, -10.0, 10.0, 10.0, -10.0}), org.elasticsearch.core.List.of((Object)new LinearRing(new double[]{175.0, 185.0, 185.0, 175.0, 175.0}, new double[]{-5.0, -5.0, 5.0, 5.0, -5.0})));
        data = BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().startObject().field("area", WellKnownText.toWKT((Geometry)crossing)).endObject());
        GeoShapeIntegTestCase.client().prepareIndex("shapes", "shape").setId("1").setSource(data, XContentType.JSON).get();
        GeoShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(174.0, -4.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(-174.0, -4.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(180.0, -4.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 0L);
        result = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setPostFilter((QueryBuilder)QueryBuilders.geoIntersectionQuery((String)"area", (Geometry)new Point(180.0, -6.0))).get();
        ElasticsearchAssertions.assertHitCount(result, 1L);
    }

    public void testBulk() throws Exception {
        byte[] bulkAction = this.unZipData("/org/elasticsearch/search/geo/gzippedmap.gz");
        Version version = VersionUtils.randomIndexCompatibleVersion(GeoShapeIntegTestCase.random());
        Settings settings = Settings.builder().put("index.version.created", version).build();
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject("country").startObject("properties").startObject("pin").field("type", "geo_point");
        xContentBuilder.field("store", true).endObject().startObject("location").field("type", "geo_shape").field("ignore_malformed", true).endObject().endObject().endObject().endObject();
        GeoShapeIntegTestCase.client().admin().indices().prepareCreate("countries").setSettings(settings).addMapping("country", xContentBuilder).get();
        BulkResponse bulk = (BulkResponse)GeoShapeIntegTestCase.client().prepareBulk().add(bulkAction, 0, bulkAction.length, null, xContentBuilder.contentType()).get();
        for (BulkItemResponse item : bulk.getItems()) {
            GeoShapeIntegTestCase.assertFalse((String)"unable to index data", (boolean)item.isFailed());
        }
        GeoShapeIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
        String key = "DE";
        SearchResponse searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)key)).get();
        ElasticsearchAssertions.assertHitCount(searchResponse, 1L);
        for (SearchHit hit : searchResponse.getHits()) {
            GeoShapeIntegTestCase.assertThat((Object)hit.getId(), (Matcher)Matchers.equalTo((Object)key));
        }
        SearchResponse world = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).addStoredField("pin").setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"pin").setCorners(90.0, -179.99999, -90.0, 179.99999)).get();
        ElasticsearchAssertions.assertHitCount(world, 53L);
        SearchResponse distance = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).addStoredField("pin").setQuery((QueryBuilder)QueryBuilders.geoDistanceQuery((String)"pin").distance("425km").point(51.11, 9.851)).get();
        ElasticsearchAssertions.assertHitCount(distance, 5L);
        GeoPoint point = new GeoPoint();
        for (SearchHit hit : distance.getHits()) {
            String name = hit.getId();
            point.resetFromString((String)((DocumentField)hit.getFields().get("pin")).getValue());
            double dist = this.distance(point.getLat(), point.getLon(), 51.11, 9.851);
            GeoShapeIntegTestCase.assertThat((String)("distance to '" + name + "'"), (Object)dist, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(425000.0)));
            GeoShapeIntegTestCase.assertThat((Object)name, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"CZ"), (Matcher)Matchers.equalTo((Object)"DE"), (Matcher)Matchers.equalTo((Object)"BE"), (Matcher)Matchers.equalTo((Object)"NL"), (Matcher)Matchers.equalTo((Object)"LU")));
            if (!key.equals(name)) continue;
            GeoShapeIntegTestCase.assertThat((Object)dist, (Matcher)Matchers.closeTo((double)0.0, (double)0.1));
        }
    }

    private String findNodeName(String index) {
        ClusterState state = ((ClusterStateResponse)GeoShapeIntegTestCase.client().admin().cluster().prepareState().get()).getState();
        IndexShardRoutingTable shard = state.getRoutingTable().index(index).shard(0);
        String nodeId = ((ShardRouting)shard.assignedShards().get(0)).currentNodeId();
        return state.getNodes().get(nodeId).getName();
    }

    private byte[] unZipData(String path) throws IOException {
        InputStream is = Streams.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream in = new GZIPInputStream(is);
        Streams.copy((InputStream)in, (OutputStream)out);
        is.close();
        out.close();
        return out.toByteArray();
    }

    private double distance(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters((double)lat1, (double)lon1, (double)lat2, (double)lon2);
    }
}

