/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class MetadataMapperTestCase
extends MapperServiceTestCase {
    protected abstract String fieldName();

    protected abstract void registerParameters(ParameterChecker var1) throws IOException;

    public final void testUpdates() throws IOException {
        MapperService mapperService;
        ParameterChecker checker = new ParameterChecker();
        this.registerParameters(checker);
        for (String param : checker.conflictChecks.keySet()) {
            mapperService = this.createMapperService(checker.conflictChecks.get((Object)param).init);
            this.merge(mapperService, checker.conflictChecks.get((Object)param).init);
            Exception e = (Exception)MetadataMapperTestCase.expectThrows(IllegalArgumentException.class, (String)("No conflict when updating parameter [" + param + "]"), () -> this.merge(mapperService, checker.conflictChecks.get((Object)param).update));
            MetadataMapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)("Cannot update parameter [" + param + "]")), (Matcher)Matchers.containsString((String)("different [" + param + "]"))));
        }
        for (UpdateCheck updateCheck : checker.updateChecks) {
            mapperService = this.createMapperService(updateCheck.init);
            this.merge(mapperService, updateCheck.update);
            updateCheck.check.accept(mapperService.documentMapper());
        }
    }

    public class ParameterChecker {
        Map<String, ConflictCheck> conflictChecks = new HashMap<String, ConflictCheck>();
        List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();

        public void registerConflictCheck(String param, CheckedConsumer<XContentBuilder, IOException> update) throws IOException {
            this.conflictChecks.put(param, new ConflictCheck(MetadataMapperTestCase.this.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startObject(MetadataMapperTestCase.this.fieldName()).endObject())), MetadataMapperTestCase.this.topMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject(MetadataMapperTestCase.this.fieldName());
                update.accept(b);
                b.endObject();
            }))));
        }

        public void registerConflictCheck(String param, XContentBuilder init, XContentBuilder update) {
            this.conflictChecks.put(param, new ConflictCheck(init, update));
        }

        public void registerUpdateCheck(XContentBuilder init, XContentBuilder update, Consumer<DocumentMapper> check) {
            this.updateChecks.add(new UpdateCheck(init, update, check));
        }
    }

    private static class ConflictCheck {
        final XContentBuilder init;
        final XContentBuilder update;

        private ConflictCheck(XContentBuilder init, XContentBuilder update) {
            this.init = init;
            this.update = update;
        }
    }

    private static class UpdateCheck {
        final XContentBuilder init;
        final XContentBuilder update;
        final Consumer<DocumentMapper> check;

        private UpdateCheck(XContentBuilder init, XContentBuilder update, Consumer<DocumentMapper> check) {
            this.init = init;
            this.update = update;
            this.check = check;
        }
    }
}

