/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterServiceUtils {
    public static MasterService createMasterService(ThreadPool threadPool, ClusterState initialClusterState) {
        MasterService masterService = new MasterService(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), "test_master_node").build(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), threadPool);
        AtomicReference<ClusterState> clusterStateRef = new AtomicReference<ClusterState>(initialClusterState);
        masterService.setClusterStatePublisher((clusterStatePublicationEvent, publishListener, ackListener) -> {
            ClusterServiceUtils.setAllElapsedMillis(clusterStatePublicationEvent);
            clusterStateRef.set(clusterStatePublicationEvent.getNewState());
            publishListener.onResponse(null);
        });
        masterService.setClusterStateSupplier(clusterStateRef::get);
        masterService.start();
        return masterService;
    }

    public static MasterService createMasterService(ThreadPool threadPool, DiscoveryNode localNode) {
        ClusterState initialClusterState = ClusterState.builder((ClusterName)new ClusterName(ClusterServiceUtils.class.getSimpleName())).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).masterNodeId(localNode.getId())).blocks(ClusterBlocks.EMPTY_CLUSTER_BLOCK).build();
        return ClusterServiceUtils.createMasterService(threadPool, initialClusterState);
    }

    public static void setState(ClusterApplierService executor, ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        executor.onNewClusterState("test setting state", () -> ClusterState.builder((ClusterState)clusterState).version(clusterState.version() + 1L).build(), (ActionListener)new ActionListener<Void>(){

            public void onResponse(Void ignored) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                exception.set(e);
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (exception.get() != null) {
                Throwables.rethrow((Throwable)((Throwable)exception.get()));
            }
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException("unexpected exception", (Throwable)e, new Object[0]);
        }
    }

    public static void setState(MasterService executor, final ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        executor.submitStateUpdateTask("test setting state", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                return ClusterState.builder((ClusterState)clusterState).build();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                latch.countDown();
            }

            public void onFailure(String source, Exception e) {
                TestCase.fail((String)("unexpected exception" + e));
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException("unexpected interruption", (Throwable)e, new Object[0]);
        }
    }

    public static ClusterService createClusterService(ThreadPool threadPool) {
        DiscoveryNode discoveryNode = new DiscoveryNode("node", ESTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), (Set)DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT);
        return ClusterServiceUtils.createClusterService(threadPool, discoveryNode);
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode) {
        return ClusterServiceUtils.createClusterService(threadPool, localNode, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode, ClusterSettings clusterSettings) {
        Settings settings = Settings.builder().put("node.name", "test").put("cluster.name", "ClusterServiceTests").build();
        ClusterService clusterService = new ClusterService(settings, clusterSettings, threadPool);
        clusterService.setNodeConnectionsService(ClusterServiceUtils.createNoOpNodeConnectionsService());
        ClusterState initialClusterState = ClusterState.builder((ClusterName)new ClusterName(ClusterServiceUtils.class.getSimpleName())).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).masterNodeId(localNode.getId())).blocks(ClusterBlocks.EMPTY_CLUSTER_BLOCK).build();
        clusterService.getClusterApplierService().setInitialState(initialClusterState);
        clusterService.getMasterService().setClusterStatePublisher(ClusterServiceUtils.createClusterStatePublisher((ClusterApplier)clusterService.getClusterApplierService()));
        clusterService.getMasterService().setClusterStateSupplier(() -> ((ClusterApplierService)clusterService.getClusterApplierService()).state());
        clusterService.start();
        return clusterService;
    }

    public static NodeConnectionsService createNoOpNodeConnectionsService() {
        return new NodeConnectionsService(Settings.EMPTY, null, null){

            public void connectToNodes(DiscoveryNodes discoveryNodes, Runnable onCompletion) {
                onCompletion.run();
            }

            public void disconnectFromNodesExcept(DiscoveryNodes nodesToKeep) {
            }
        };
    }

    public static ClusterStatePublisher createClusterStatePublisher(ClusterApplier clusterApplier) {
        return (clusterStatePublicationEvent, publishListener, ackListener) -> {
            ClusterServiceUtils.setAllElapsedMillis(clusterStatePublicationEvent);
            clusterApplier.onNewClusterState("mock_publish_to_self[" + clusterStatePublicationEvent.getSummary() + "]", () -> ((ClusterStatePublicationEvent)clusterStatePublicationEvent).getNewState(), publishListener);
        };
    }

    public static ClusterService createClusterService(ClusterState initialState, ThreadPool threadPool) {
        ClusterService clusterService = ClusterServiceUtils.createClusterService(threadPool);
        ClusterServiceUtils.setState(clusterService, initialState);
        return clusterService;
    }

    public static void setState(ClusterService clusterService, ClusterState.Builder clusterStateBuilder) {
        ClusterServiceUtils.setState(clusterService, clusterStateBuilder.build());
    }

    public static void setState(ClusterService clusterService, ClusterState clusterState) {
        ClusterServiceUtils.setState(clusterService.getClusterApplierService(), clusterState);
    }

    public static void setAllElapsedMillis(ClusterStatePublicationEvent clusterStatePublicationEvent) {
        clusterStatePublicationEvent.setPublicationContextConstructionElapsedMillis(0L);
        clusterStatePublicationEvent.setPublicationCommitElapsedMillis(0L);
        clusterStatePublicationEvent.setPublicationCompletionElapsedMillis(0L);
        clusterStatePublicationEvent.setMasterApplyElapsedMillis(0L);
    }

    public static void awaitClusterState(Logger logger, Predicate<ClusterState> statePredicate, final ClusterService clusterService) throws Exception {
        ClusterStateObserver observer = new ClusterStateObserver(clusterService, null, logger, clusterService.getClusterApplierService().threadPool().getThreadContext());
        if (!statePredicate.test(observer.setAndGetObservedState())) {
            final PlainActionFuture future = PlainActionFuture.newFuture();
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    future.onResponse(null);
                }

                public void onClusterServiceClose() {
                    future.onFailure((Exception)new NodeClosedException(clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    assert (false) : "onTimeout called with no timeout set";
                }
            }, statePredicate);
            future.get(30L, TimeUnit.SECONDS);
        }
    }
}

