/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class DataStreamTestHelper {
    private static final Settings.Builder SETTINGS = ESTestCase.settings(Version.CURRENT).put("index.hidden", true);
    private static final int NUMBER_OF_SHARDS = 1;
    private static final int NUMBER_OF_REPLICAS = 1;

    public static DataStream newInstance(String name, DataStream.TimestampField timeStampField, List<Index> indices) {
        return DataStreamTestHelper.newInstance(name, timeStampField, indices, indices.size(), null);
    }

    public static DataStream newInstance(String name, DataStream.TimestampField timeStampField, List<Index> indices, long generation, Map<String, Object> metadata) {
        return DataStreamTestHelper.newInstance(name, timeStampField, indices, generation, metadata, false);
    }

    public static DataStream newInstance(String name, DataStream.TimestampField timeStampField, List<Index> indices, long generation, Map<String, Object> metadata, boolean replicated) {
        return new DataStream(name, timeStampField, indices, generation, metadata, false, replicated, false);
    }

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName, long epochMillis) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1, epochMillis);
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, generation, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation, long epochMillis) {
        return IndexMetadata.builder((String)DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation, (long)epochMillis)).settings(SETTINGS).numberOfShards(1).numberOfReplicas(1);
    }

    public static IndexMetadata.Builder getIndexMetadataBuilderForIndex(Index index) {
        return IndexMetadata.builder((String)index.getName()).settings(Settings.builder().put(SETTINGS.build()).put("index.uuid", index.getUUID())).numberOfShards(1).numberOfReplicas(1);
    }

    public static DataStream.TimestampField createTimestampField(String fieldName) {
        return new DataStream.TimestampField(fieldName);
    }

    public static String generateMapping(String timestampFieldName) {
        return "{     \"_doc\":{\n        \"properties\": {\n          \"" + timestampFieldName + "\": {\n            \"type\": \"date\"\n          }\n      }\n    }}";
    }

    public static String generateMapping(String timestampFieldName, String type) {
        return "{\n      \"_data_stream_timestamp\": {\n        \"enabled\": true\n      },      \"properties\": {\n        \"" + timestampFieldName + "\": {\n          \"type\": \"" + type + "\"\n        }\n      }\n    }";
    }

    public static List<Index> randomIndexInstances() {
        int numIndices = ESTestCase.randomIntBetween(0, 128);
        ArrayList<Index> indices = new ArrayList<Index>(numIndices);
        for (int i = 0; i < numIndices; ++i) {
            indices.add(new Index(ESTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        }
        return indices;
    }

    public static DataStream randomInstance() {
        return DataStreamTestHelper.randomInstance(System::currentTimeMillis);
    }

    public static DataStream randomInstance(String name) {
        return DataStreamTestHelper.randomInstance(name, System::currentTimeMillis);
    }

    public static DataStream randomInstance(LongSupplier timeProvider) {
        String dataStreamName = ESTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT);
        return DataStreamTestHelper.randomInstance(dataStreamName, timeProvider);
    }

    public static DataStream randomInstance(String dataStreamName, LongSupplier timeProvider) {
        List<Index> indices = DataStreamTestHelper.randomIndexInstances();
        long generation = (long)indices.size() + ESTestCase.randomLongBetween(1L, 128L);
        indices.add(new Index(DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        HashMap<String, String> metadata = null;
        if (ESTestCase.randomBoolean()) {
            metadata = new HashMap<String, String>();
            metadata.put("key", "value");
        }
        return new DataStream(dataStreamName, DataStreamTestHelper.createTimestampField("@timestamp"), indices, generation, metadata, ESTestCase.randomBoolean(), ESTestCase.randomBoolean(), false, timeProvider);
    }

    public static DataStreamAlias randomAliasInstance() {
        List<String> dataStreams = Arrays.asList(ESTestCase.generateRandomStringArray(5, 5, false, false));
        return new DataStreamAlias(ESTestCase.randomAlphaOfLength(5), dataStreams, ESTestCase.randomBoolean() ? ESTestCase.randomFrom(dataStreams) : null, ESTestCase.randomBoolean() ? ESTestCase.randomMap(1, 4, () -> new Tuple((Object)"term", Collections.singletonMap("year", "2022"))) : null);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, 1);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, int replicas) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, replicas, false);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, int replicas, boolean replicated) {
        Metadata.Builder builder = Metadata.builder();
        ArrayList allIndices = new ArrayList();
        for (Tuple<String, Integer> dsTuple : dataStreams) {
            ArrayList<IndexMetadata> backingIndices = new ArrayList<IndexMetadata>();
            for (int backingIndexNumber = 1; backingIndexNumber <= (Integer)dsTuple.v2(); ++backingIndexNumber) {
                backingIndices.add(DataStreamTestHelper.createIndexMetadata(DataStream.getDefaultBackingIndexName((String)((String)dsTuple.v1()), (long)backingIndexNumber), true, replicas));
            }
            allIndices.addAll(backingIndices);
            DataStream ds = DataStreamTestHelper.newInstance((String)dsTuple.v1(), DataStreamTestHelper.createTimestampField("@timestamp"), backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toList()), ((Integer)dsTuple.v2()).intValue(), null, replicated);
            builder.put(ds);
        }
        for (String indexName : indexNames) {
            allIndices.add(DataStreamTestHelper.createIndexMetadata(indexName, false, replicas));
        }
        for (IndexMetadata index : allIndices) {
            builder.put(index, false);
        }
        return ClusterState.builder((ClusterName)new ClusterName("_name")).metadata(builder).build();
    }

    private static IndexMetadata createIndexMetadata(String name, boolean hidden, int replicas) {
        Settings.Builder b = Settings.builder().put("index.version.created", Version.CURRENT).put("index.hidden", hidden);
        return IndexMetadata.builder((String)name).settings(b).numberOfShards(1).numberOfReplicas(replicas).build();
    }

    public static String backingIndexPattern(String dataStreamName, long generation) {
        return String.format(Locale.ROOT, "\\.ds-%s-(\\d{4}\\.\\d{2}\\.\\d{2}-)?%06d", dataStreamName, generation);
    }

    public static Matcher<String> backingIndexEqualTo(final String dataStreamName, final int generation) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String backingIndexName) {
                if (backingIndexName == null) {
                    return false;
                }
                int indexOfLastDash = backingIndexName.lastIndexOf(45);
                String actualDataStreamName = this.parseDataStreamName(backingIndexName, indexOfLastDash);
                int actualGeneration = this.parseGeneration(backingIndexName, indexOfLastDash);
                return actualDataStreamName.equals(dataStreamName) && actualGeneration == generation;
            }

            protected void describeMismatchSafely(String backingIndexName, Description mismatchDescription) {
                int indexOfLastDash = backingIndexName.lastIndexOf(45);
                String dataStreamName2 = this.parseDataStreamName(backingIndexName, indexOfLastDash);
                int generation2 = this.parseGeneration(backingIndexName, indexOfLastDash);
                mismatchDescription.appendText(" was data stream name ").appendValue((Object)dataStreamName2).appendText(" and generation ").appendValue((Object)generation2);
            }

            public void describeTo(Description description) {
                description.appendText("expected data stream name ").appendValue((Object)dataStreamName).appendText(" and expected generation ").appendValue((Object)generation);
            }

            private String parseDataStreamName(String backingIndexName, int indexOfLastDash) {
                return backingIndexName.substring(4, backingIndexName.lastIndexOf(45, indexOfLastDash - 1));
            }

            private int parseGeneration(String backingIndexName, int indexOfLastDash) {
                return Integer.parseInt(backingIndexName.substring(indexOfLastDash + 1));
            }
        };
    }
}

