/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;

public class FakeThreadPoolMasterService
extends MasterService {
    private static final Logger logger = LogManager.getLogger(FakeThreadPoolMasterService.class);
    private final String name;
    private final List<Runnable> pendingTasks = new ArrayList<Runnable>();
    private final Consumer<Runnable> onTaskAvailableToRun;
    private boolean scheduledNextTask = false;
    private boolean taskInProgress = false;
    private boolean waitForPublish = false;

    public FakeThreadPoolMasterService(String nodeName, String serviceName, ThreadPool threadPool, Consumer<Runnable> onTaskAvailableToRun) {
        super(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), nodeName).build(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), threadPool);
        this.name = serviceName;
        this.onTaskAvailableToRun = onTaskAvailableToRun;
    }

    protected PrioritizedEsThreadPoolExecutor createThreadPoolExecutor() {
        return new PrioritizedEsThreadPoolExecutor(this.name, 1, 1, 1L, TimeUnit.SECONDS, EsExecutors.daemonThreadFactory((String)this.name), null, null, PrioritizedEsThreadPoolExecutor.StarvationWatcher.NOOP_STARVATION_WATCHER){

            public void execute(Runnable command, TimeValue timeout, Runnable timeoutCallback) {
                this.execute(command);
            }

            public void execute(Runnable command) {
                FakeThreadPoolMasterService.this.pendingTasks.add(command);
                FakeThreadPoolMasterService.this.scheduleNextTaskIfNecessary();
            }
        };
    }

    public int getFakeMasterServicePendingTaskCount() {
        return this.pendingTasks.size();
    }

    private void scheduleNextTaskIfNecessary() {
        if (!(this.taskInProgress || this.pendingTasks.isEmpty() || this.scheduledNextTask)) {
            this.scheduledNextTask = true;
            this.onTaskAvailableToRun.accept(new Runnable(){

                public String toString() {
                    return "master service scheduling next task";
                }

                @Override
                public void run() {
                    assert (!FakeThreadPoolMasterService.this.taskInProgress);
                    assert (!FakeThreadPoolMasterService.this.waitForPublish);
                    assert (FakeThreadPoolMasterService.this.scheduledNextTask);
                    int taskIndex = ESTestCase.randomInt(FakeThreadPoolMasterService.this.pendingTasks.size() - 1);
                    logger.debug("next master service task: choosing task {} of {}", (Object)taskIndex, (Object)FakeThreadPoolMasterService.this.pendingTasks.size());
                    Runnable task = (Runnable)FakeThreadPoolMasterService.this.pendingTasks.remove(taskIndex);
                    FakeThreadPoolMasterService.this.taskInProgress = true;
                    FakeThreadPoolMasterService.this.scheduledNextTask = false;
                    ThreadContext threadContext = FakeThreadPoolMasterService.this.threadPool.getThreadContext();
                    try (ThreadContext.StoredContext ignored = threadContext.stashContext();){
                        threadContext.markAsSystemContext();
                        task.run();
                    }
                    if (!FakeThreadPoolMasterService.this.waitForPublish) {
                        FakeThreadPoolMasterService.this.taskInProgress = false;
                    }
                    FakeThreadPoolMasterService.this.scheduleNextTaskIfNecessary();
                }
            });
        }
    }

    public ClusterState.Builder incrementVersion(ClusterState clusterState) {
        return ClusterState.builder((ClusterState)clusterState).incrementVersion().stateUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random()));
    }

    protected void publish(final ClusterStatePublicationEvent clusterStatePublicationEvent, final MasterService.TaskOutputs taskOutputs) {
        assert (!this.waitForPublish);
        this.waitForPublish = true;
        ClusterStatePublisher.AckListener ackListener = taskOutputs.createAckListener(this.threadPool, clusterStatePublicationEvent.getNewState());
        ActionListener<Void> publishListener = new ActionListener<Void>(){
            private boolean listenerCalled = false;

            public void onResponse(Void aVoid) {
                assert (!this.listenerCalled);
                this.listenerCalled = true;
                assert (FakeThreadPoolMasterService.this.waitForPublish);
                FakeThreadPoolMasterService.this.waitForPublish = false;
                try {
                    FakeThreadPoolMasterService.this.onPublicationSuccess(clusterStatePublicationEvent, taskOutputs);
                }
                finally {
                    FakeThreadPoolMasterService.this.taskInProgress = false;
                    FakeThreadPoolMasterService.this.scheduleNextTaskIfNecessary();
                }
            }

            public void onFailure(Exception e) {
                assert (!this.listenerCalled);
                this.listenerCalled = true;
                assert (FakeThreadPoolMasterService.this.waitForPublish);
                FakeThreadPoolMasterService.this.waitForPublish = false;
                try {
                    FakeThreadPoolMasterService.this.onPublicationFailed(clusterStatePublicationEvent, taskOutputs, e);
                }
                finally {
                    FakeThreadPoolMasterService.this.taskInProgress = false;
                    FakeThreadPoolMasterService.this.scheduleNextTaskIfNecessary();
                }
            }
        };
        this.threadPool.generic().execute(this.threadPool.getThreadContext().preserveContext(new Runnable(){
            final /* synthetic */ ActionListener val$publishListener;
            final /* synthetic */ ClusterStatePublisher.AckListener val$ackListener;
            {
                this.val$publishListener = actionListener;
                this.val$ackListener = ackListener;
            }

            @Override
            public void run() {
                FakeThreadPoolMasterService.this.clusterStatePublisher.publish(clusterStatePublicationEvent, this.val$publishListener, FakeThreadPoolMasterService.this.wrapAckListener(this.val$ackListener));
            }

            public String toString() {
                return "publish change of cluster state from version [" + clusterStatePublicationEvent.getOldState().version() + "] in term [" + clusterStatePublicationEvent.getOldState().term() + "] to version [" + clusterStatePublicationEvent.getNewState().version() + "] in term [" + clusterStatePublicationEvent.getNewState().term() + "]";
            }
        }));
    }

    protected ClusterStatePublisher.AckListener wrapAckListener(ClusterStatePublisher.AckListener ackListener) {
        return ackListener;
    }
}

