/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import com.carrotsearch.randomizedtesting.generators.CodepointSetGenerator;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestUtil;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapForTesting;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.HeaderWarningAppender;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.time.FormatNames;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.List;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.PathUtilsForTesting;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.jdk.JavaVersion;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.test.junit.listeners.LoggingListener;
import org.elasticsearch.test.junit.listeners.ReproduceInfoPrinter;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.transport.nio.MockNioTransportPlugin;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Listeners(value={ReproduceInfoPrinter.class, LoggingListener.class})
@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakLingering(linger=5000)
@TimeoutSuite(millis=1200000)
@LuceneTestCase.SuppressSysoutChecks(bugUrl="we log a lot on purpose")
@LuceneTestCase.SuppressCodecs(value={"SimpleText", "Memory", "CheapBastard", "Direct", "Compressing", "FST50", "FSTOrd50", "TestBloomFilteredLucenePostings", "MockRandom", "BlockTreeOrds", "LuceneFixedGap", "LuceneVarGapFixedInterval", "LuceneVarGapDocFreqInterval", "Lucene50"})
@LuceneTestCase.SuppressReproduceLine
public abstract class ESTestCase
extends LuceneTestCase {
    protected static final java.util.List<String> JODA_TIMEZONE_IDS;
    protected static final java.util.List<String> JAVA_TIMEZONE_IDS;
    protected static final java.util.List<String> JAVA_ZONE_IDS;
    private static final AtomicInteger portGenerator;
    private static final Collection<String> loggedLeaks;
    public static final int MIN_PRIVATE_PORT = 13301;
    private HeaderWarningAppender headerWarningAppender;
    public static final String TEST_WORKER_VM_ID;
    public static final String TEST_WORKER_SYS_PROPERTY = "org.gradle.test.worker";
    public static final String DEFAULT_TEST_WORKER_ID = "--not-gradle--";
    public static final String FIPS_SYSPROP = "tests.fips.enabled";
    protected final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ThreadContext threadContext;
    @Rule
    public RuleChain failureAndSuccessEvents = RuleChain.outerRule((TestRule)new TestRuleAdapter(){

        protected void afterIfSuccessful() throws Throwable {
            ESTestCase.this.afterIfSuccessful();
        }

        protected void afterAlways(java.util.List<Throwable> errors) throws Throwable {
            if (errors != null && !errors.isEmpty()) {
                boolean allAssumption = true;
                for (Throwable error : errors) {
                    if (error instanceof AssumptionViolatedException) continue;
                    allAssumption = false;
                    break;
                }
                if (!allAssumption) {
                    ESTestCase.this.afterIfFailed(errors);
                }
            }
            super.afterAlways(errors);
        }
    });
    private static final java.util.List<StatusData> statusData;
    private static final java.util.List<String> LOG_4J_MSG_PREFIXES;
    public static final java.util.List<Exception> checkIndexFailures;
    private static final String[] TIME_SUFFIXES;
    private static final long AWAIT_BUSY_THRESHOLD = 1000L;
    private static final GeohashGenerator geohashGenerator;
    private static final NamedXContentRegistry DEFAULT_NAMED_X_CONTENT_REGISTRY;
    protected static final NamedWriteableRegistry DEFAULT_NAMED_WRITABLE_REGISTRY;

    @AfterClass
    public static void resetPortCounter() {
        portGenerator.set(0);
    }

    @SuppressForbidden(reason="force log4j and netty sysprops")
    private static void setTestSysProps() {
        System.setProperty("log4j.shutdownHookEnabled", "false");
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("io.netty.leakDetection.level", "paranoid");
        System.setProperty("es.set.netty.runtime.available.processors", "false");
    }

    public static TransportAddress buildNewFakeTransportAddress() {
        return new TransportAddress(TransportAddress.META_ADDRESS, portGenerator.incrementAndGet());
    }

    protected void afterIfFailed(java.util.List<Throwable> errors) {
    }

    protected void afterIfSuccessful() throws Exception {
    }

    @BeforeClass
    public static void setFileSystem() throws Exception {
        PathUtilsForTesting.setup();
    }

    @AfterClass
    public static void restoreFileSystem() throws Exception {
        PathUtilsForTesting.teardown();
    }

    @BeforeClass
    public static void setContentType() throws Exception {
        Requests.CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
        Requests.INDEX_CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
    }

    @AfterClass
    public static void restoreContentType() {
        Requests.CONTENT_TYPE = XContentType.SMILE;
        Requests.INDEX_CONTENT_TYPE = XContentType.JSON;
    }

    @BeforeClass
    public static void ensureSupportedLocale() {
        if (ESTestCase.isUnusableLocale()) {
            Logger logger = LogManager.getLogger(ESTestCase.class);
            logger.warn("Attempting to run tests in an unusable locale in a FIPS JVM. Certificate expiration validation will fail, switching to English. See: https://github.com/bcgit/bc-java/issues/405");
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    @Before
    public void setHeaderWarningAppender() {
        this.headerWarningAppender = HeaderWarningAppender.createAppender((String)"header_warning", null);
        this.headerWarningAppender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.headerWarningAppender);
    }

    @After
    public void removeHeaderWarningAppender() {
        if (this.headerWarningAppender != null) {
            Loggers.removeAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.headerWarningAppender);
            this.headerWarningAppender = null;
        }
    }

    @Before
    public final void before() {
        this.logger.info("{}before test", (Object)this.getTestParamsForLogging());
        ESTestCase.assertNull((String)"Thread context initialized twice", (Object)this.threadContext);
        if (this.enableWarningsCheck()) {
            this.threadContext = new ThreadContext(Settings.EMPTY);
            HeaderWarning.setThreadContext((ThreadContext)this.threadContext);
        }
    }

    @AfterClass
    public static void clearAdditionalRoles() {
        DiscoveryNode.setAdditionalRoles(Collections.emptySet());
    }

    protected boolean enableWarningsCheck() {
        return true;
    }

    protected boolean enableJodaDeprecationWarningsCheck() {
        return false;
    }

    @After
    public final void after() throws Exception {
        ESTestCase.checkStaticState();
        if (this.threadContext != null) {
            this.ensureNoWarnings();
            HeaderWarning.removeThreadContext((ThreadContext)this.threadContext);
            this.threadContext = null;
        }
        this.ensureAllSearchContextsReleased();
        this.ensureCheckIndexPassed();
        this.logger.info("{}after test", (Object)this.getTestParamsForLogging());
    }

    private String getTestParamsForLogging() {
        String name = this.getTestName();
        int start = name.indexOf(123);
        if (start < 0) {
            return "";
        }
        int end = name.lastIndexOf(125);
        if (end < 0) {
            return "";
        }
        return "[" + name.substring(start + 1, end) + "] ";
    }

    public void ensureNoWarnings() {
        try {
            java.util.List warnings = (java.util.List)this.threadContext.getResponseHeaders().get("Warning");
            if (warnings != null) {
                java.util.List filteredWarnings = warnings.stream().filter(k -> this.filteredWarnings().stream().noneMatch(s -> k.contains((CharSequence)s))).collect(Collectors.toList());
                ESTestCase.assertThat((String)"unexpected warning headers", filteredWarnings, (Matcher)Matchers.empty());
            } else {
                ESTestCase.assertNull((String)"unexpected warning headers", (Object)warnings);
            }
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    protected java.util.List<String> filteredWarnings() {
        ArrayList<String> filtered = new ArrayList<String>();
        filtered.add("Configuring [path.data] with a list is deprecated. Instead specify as a string value");
        filtered.add("setting [path.shared_data] is deprecated and will be removed in a future release");
        if (!this.enableJodaDeprecationWarningsCheck()) {
            filtered.add("Use new java.time date format specifiers.");
        }
        if (!JvmInfo.jvmInfo().getBundledJdk()) {
            filtered.add("no-jdk distributions that do not bundle a JDK are deprecated and will be removed in a future release");
        }
        return filtered;
    }

    protected final void assertSettingDeprecationsAndWarnings(Setting<?>[] settings, DeprecationWarning ... warnings) {
        this.assertWarnings(true, (DeprecationWarning[])Stream.concat(Arrays.stream(settings).map(setting -> {
            String warningMessage = String.format(Locale.ROOT, "[%s] setting was deprecated in Elasticsearch and will be removed in a future release! See the breaking changes documentation for the next major version.", setting.getKey());
            return new DeprecationWarning(setting.getProperties().contains(Setting.Property.Deprecated) ? DeprecationLogger.CRITICAL : Level.WARN, warningMessage);
        }), Arrays.stream(warnings)).toArray(DeprecationWarning[]::new));
    }

    protected final void assertWarnings(Level level, String ... expectedWarnings) {
        this.assertWarnings(true, (DeprecationWarning[])Arrays.stream(expectedWarnings).map(expectedWarning -> new DeprecationWarning(level, (String)expectedWarning)).toArray(DeprecationWarning[]::new));
    }

    protected final void assertWarnings(String ... expectedWarnings) {
        this.assertWarnings(true, (DeprecationWarning[])Arrays.stream(expectedWarnings).map(expectedWarning -> new DeprecationWarning(DeprecationLogger.CRITICAL, (String)expectedWarning)).toArray(DeprecationWarning[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void allowedWarnings(String ... allowedWarnings) {
        if (!this.enableWarningsCheck()) {
            throw new IllegalStateException("unable to check warning headers if the test is not set to do so");
        }
        try {
            java.util.List actualWarnings = (java.util.List)this.threadContext.getResponseHeaders().get("Warning");
            if (actualWarnings == null) {
                return;
            }
            Set actualWarningValues = actualWarnings.stream().map(s -> HeaderWarning.extractWarningValueFromWarningHeader((String)s, (boolean)true)).map(HeaderWarning::escapeAndEncode).collect(Collectors.toSet());
            HashSet<String> expectedWarnings = new HashSet<String>(Arrays.asList(allowedWarnings));
            Set warningsNotExpected = Sets.difference(actualWarningValues, expectedWarnings);
            ESTestCase.assertThat((String)("Found " + warningsNotExpected.size() + " unexpected warnings\nExpected: " + expectedWarnings + "\nActual: " + actualWarningValues), (Object)warningsNotExpected.size(), (Matcher)Matchers.equalTo((Object)0));
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertWarnings(boolean stripXContentPosition, DeprecationWarning ... expectedWarnings) {
        if (!this.enableWarningsCheck()) {
            throw new IllegalStateException("unable to check warning headers if the test is not set to do so");
        }
        try {
            java.util.List actualWarningStrings = (java.util.List)this.threadContext.getResponseHeaders().get("Warning");
            if (expectedWarnings == null || expectedWarnings.length == 0) {
                ESTestCase.assertNull((String)("expected 0 warnings, actual: " + actualWarningStrings), (Object)actualWarningStrings);
            } else {
                ESTestCase.assertNotNull((String)("no warnings, expected: " + Arrays.asList(expectedWarnings)), (Object)actualWarningStrings);
                Set actualDeprecationWarnings = actualWarningStrings.stream().map(warningString -> {
                    Level level;
                    String warningText = HeaderWarning.extractWarningValueFromWarningHeader((String)warningString, (boolean)stripXContentPosition);
                    if (warningString.startsWith(Integer.toString(DeprecationLogger.CRITICAL.intLevel()))) {
                        level = DeprecationLogger.CRITICAL;
                    } else if (warningString.startsWith(Integer.toString(Level.WARN.intLevel()))) {
                        level = Level.WARN;
                    } else {
                        throw new IllegalArgumentException("Unknown level in deprecation message " + warningString);
                    }
                    return new DeprecationWarning(level, warningText);
                }).collect(Collectors.toSet());
                for (DeprecationWarning expectedWarning : expectedWarnings) {
                    DeprecationWarning escapedExpectedWarning = new DeprecationWarning(expectedWarning.level, HeaderWarning.escapeAndEncode((String)expectedWarning.message));
                    ESTestCase.assertThat(actualDeprecationWarnings, (Matcher)Matchers.hasItem((Object)escapedExpectedWarning));
                }
                ESTestCase.assertEquals((String)("Expected " + expectedWarnings.length + " warnings but found " + actualWarningStrings.size() + "\nExpected: " + Arrays.asList(expectedWarnings) + "\nActual: " + actualWarningStrings), (long)expectedWarnings.length, (long)actualWarningStrings.size());
            }
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    private void assertWarnings(boolean stripXContentPosition, java.util.List<String> actualWarnings, String[] expectedWarnings) {
        ESTestCase.assertNotNull((String)("no warnings, expected: " + Arrays.asList(expectedWarnings)), actualWarnings);
        Set actualWarningValues = actualWarnings.stream().map(s -> HeaderWarning.extractWarningValueFromWarningHeader((String)s, (boolean)stripXContentPosition)).collect(Collectors.toSet());
        for (String msg : expectedWarnings) {
            ESTestCase.assertThat(actualWarningValues, (Matcher)Matchers.hasItem((Object)HeaderWarning.escapeAndEncode((String)msg)));
        }
        ESTestCase.assertEquals((String)("Expected " + expectedWarnings.length + " warnings but found " + actualWarnings.size() + "\nExpected: " + Arrays.asList(expectedWarnings) + "\nActual: " + actualWarnings), (long)expectedWarnings.length, (long)actualWarnings.size());
    }

    private void resetDeprecationLogger() {
        this.threadContext.stashContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkStaticState() throws Exception {
        LeakTracker.INSTANCE.reportLeak();
        MockBigArrays.ensureAllArraysAreReleased();
        ESTestCase.assertThat((Object)StatusLogger.getLogger().getLevel(), (Matcher)Matchers.equalTo((Object)Level.WARN));
        Collection<Object> collection = statusData;
        synchronized (collection) {
            try {
                ESTestCase.assertThat(statusData.stream().map(status -> status.getMessage().getFormattedMessage()).collect(Collectors.toList()), (Matcher)Matchers.anyOf((Matcher)Matchers.emptyCollectionOf(String.class), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.startsWith((String)LOG_4J_MSG_PREFIXES.get(0)), Matchers.startsWith((String)LOG_4J_MSG_PREFIXES.get(1))}), (Matcher)Matchers.contains((Matcher)Matchers.startsWith((String)LOG_4J_MSG_PREFIXES.get(1)))));
            }
            finally {
                statusData.clear();
            }
        }
        collection = loggedLeaks;
        synchronized (collection) {
            try {
                ESTestCase.assertThat(loggedLeaks, (Matcher)Matchers.empty());
            }
            finally {
                loggedLeaks.clear();
            }
        }
    }

    public final void ensureAllSearchContextsReleased() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> MockSearchService.assertNoInFlightContext()));
    }

    @Before
    public final void resetCheckIndexStatus() throws Exception {
        checkIndexFailures.clear();
    }

    public final void ensureCheckIndexPassed() {
        if (!checkIndexFailures.isEmpty()) {
            AssertionError e = new AssertionError((Object)"at least one shard failed CheckIndex");
            for (Exception failure : checkIndexFailures) {
                ((Throwable)((Object)e)).addSuppressed(failure);
            }
            throw e;
        }
    }

    public static int scaledRandomIntBetween(int min, int max) {
        return RandomizedTest.scaledRandomIntBetween((int)min, (int)max);
    }

    public static int randomIntBetween(int min, int max) {
        return RandomNumbers.randomIntBetween((Random)ESTestCase.random(), (int)min, (int)max);
    }

    public static long randomLongBetween(long min, long max) {
        return RandomNumbers.randomLongBetween((Random)ESTestCase.random(), (long)min, (long)max);
    }

    public static int iterations(int min, int max) {
        return ESTestCase.scaledRandomIntBetween(min, max);
    }

    public static int between(int min, int max) {
        return ESTestCase.randomIntBetween(min, max);
    }

    public static boolean frequently() {
        return !ESTestCase.rarely();
    }

    public static boolean randomBoolean() {
        return ESTestCase.random().nextBoolean();
    }

    public static byte randomByte() {
        return (byte)ESTestCase.random().nextInt();
    }

    public static byte randomNonNegativeByte() {
        byte randomByte = ESTestCase.randomByte();
        return (byte)(randomByte == -128 ? 0 : Math.abs(randomByte));
    }

    public static byte[] randomByteArrayOfLength(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = ESTestCase.randomByte();
        }
        return bytes;
    }

    public static short randomShort() {
        return (short)ESTestCase.random().nextInt();
    }

    public static int randomInt() {
        return ESTestCase.random().nextInt();
    }

    public static long randomNonNegativeLong() {
        long randomLong = ESTestCase.randomLong();
        return randomLong == Long.MIN_VALUE ? 0L : Math.abs(randomLong);
    }

    public static float randomFloat() {
        return ESTestCase.random().nextFloat();
    }

    public static double randomDouble() {
        return ESTestCase.random().nextDouble();
    }

    public static double randomDoubleBetween(double start, double end, boolean lowerInclusive) {
        double result = 0.0;
        if (start == -1.7976931348623157E308 || end == Double.MAX_VALUE) {
            result = Double.longBitsToDouble(ESTestCase.randomLong());
            while (result < start || result > end || Double.isNaN(result)) {
                result = Double.longBitsToDouble(ESTestCase.randomLong());
            }
        } else {
            result = ESTestCase.randomDouble();
            if (!lowerInclusive) {
                while (result <= 0.0) {
                    result = ESTestCase.randomDouble();
                }
            }
            result = result * end + (1.0 - result) * start;
        }
        return result;
    }

    public static long randomLong() {
        return ESTestCase.random().nextLong();
    }

    public static BigInteger randomBigInteger() {
        return new BigInteger(64, ESTestCase.random());
    }

    public static int randomInt(int max) {
        return RandomizedTest.randomInt((int)max);
    }

    @SafeVarargs
    public static <T> T randomFrom(T ... array) {
        return ESTestCase.randomFrom(ESTestCase.random(), array);
    }

    @SafeVarargs
    public static <T> T randomFrom(Random random, T ... array) {
        return (T)RandomPicks.randomFrom((Random)random, (Object[])array);
    }

    @SafeVarargs
    public static <T> T randomFrom(Random random, Supplier<T> ... array) {
        Supplier supplier = (Supplier)RandomPicks.randomFrom((Random)random, (Object[])array);
        return supplier.get();
    }

    public static <T> T randomFrom(java.util.List<T> list) {
        return (T)RandomPicks.randomFrom((Random)ESTestCase.random(), list);
    }

    public static <T> T randomFrom(Collection<T> collection) {
        return ESTestCase.randomFrom(ESTestCase.random(), collection);
    }

    public static <T> T randomFrom(Random random, Collection<T> collection) {
        return (T)RandomPicks.randomFrom((Random)random, collection);
    }

    public static String randomAlphaOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomAsciiOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomAlphaOfLength(int codeUnits) {
        return RandomizedTest.randomAsciiOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomUnicodeOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLength((int)codePoints);
    }

    public static String randomRealisticUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomRealisticUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLength((int)codeUnits);
    }

    public static String randomRealisticUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomRealisticUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLength((int)codePoints);
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull, boolean allowEmpty) {
        if (allowNull && ESTestCase.random().nextBoolean()) {
            return null;
        }
        int arraySize = ESTestCase.randomIntBetween(allowEmpty ? 0 : 1, maxArraySize);
        String[] array = new String[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = RandomStrings.randomAsciiOfLength((Random)ESTestCase.random(), (int)stringSize);
        }
        return array;
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull) {
        return ESTestCase.generateRandomStringArray(maxArraySize, stringSize, allowNull, true);
    }

    public static <T> T[] randomArray(int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        return ESTestCase.randomArray(0, maxArraySize, arrayConstructor, valueConstructor);
    }

    public static <T> T[] randomArray(int minArraySize, int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        int size = ESTestCase.randomIntBetween(minArraySize, maxArraySize);
        T[] array = arrayConstructor.apply(size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = valueConstructor.get();
        }
        return array;
    }

    public static <T> java.util.List<T> randomList(int maxListSize, Supplier<T> valueConstructor) {
        return ESTestCase.randomList(0, maxListSize, valueConstructor);
    }

    public static <T> java.util.List<T> randomList(int minListSize, int maxListSize, Supplier<T> valueConstructor) {
        int size = ESTestCase.randomIntBetween(minListSize, maxListSize);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(valueConstructor.get());
        }
        return list;
    }

    public static <K, V> Map<K, V> randomMap(int minMapSize, int maxMapSize, Supplier<Tuple<K, V>> entryConstructor) {
        int size = ESTestCase.randomIntBetween(minMapSize, maxMapSize);
        HashMap<Object, Object> list = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Tuple<K, V> entry = entryConstructor.get();
            list.put(entry.v1(), entry.v2());
        }
        return list;
    }

    public static String randomTimeValue(int lower, int upper, String ... suffixes) {
        return ESTestCase.randomIntBetween(lower, upper) + ESTestCase.randomFrom(suffixes);
    }

    public static String randomTimeValue(int lower, int upper) {
        return ESTestCase.randomTimeValue(lower, upper, TIME_SUFFIXES);
    }

    public static String randomTimeValue() {
        return ESTestCase.randomTimeValue(0, 1000);
    }

    public static String randomPositiveTimeValue() {
        return ESTestCase.randomTimeValue(1, 1000);
    }

    public static DateTimeZone randomDateTimeZone() {
        return DateTimeZone.forID((String)ESTestCase.randomFrom(JODA_TIMEZONE_IDS));
    }

    public long randomMillisUpToYear9999() {
        return ESTestCase.randomLongBetween(1L, 253402300799999L);
    }

    public static TimeZone randomTimeZone() {
        return TimeZone.getTimeZone(ESTestCase.randomJodaAndJavaSupportedTimezone(JAVA_TIMEZONE_IDS));
    }

    public static ZoneId randomZone() {
        if ((Integer)JavaVersion.current().getVersion().get(0) == 8) {
            ZoneId timeZone;
            while ((timeZone = ZoneId.of(ESTestCase.randomJodaAndJavaSupportedTimezone(JAVA_ZONE_IDS))).equals(ZoneId.of("GMT0"))) {
            }
            return timeZone;
        }
        return ZoneId.of(ESTestCase.randomJodaAndJavaSupportedTimezone(JAVA_ZONE_IDS));
    }

    private static String randomJodaAndJavaSupportedTimezone(java.util.List<String> zoneIds) {
        return ESTestCase.randomValueOtherThanMany(id -> !JODA_TIMEZONE_IDS.contains(id), () -> (String)ESTestCase.randomFrom(zoneIds));
    }

    public static String randomDateFormatterPattern() {
        EnumSet<FormatNames> formatNamesSet = EnumSet.complementOf(EnumSet.of(FormatNames.WEEK_YEAR));
        FormatNames formatName = ESTestCase.randomFrom(formatNamesSet);
        if (FormatNames.WEEK_BASED_FORMATS.contains(formatName)) {
            boolean runtimeJdk8 = (Integer)JavaVersion.current().getVersion().get(0) == 8;
            ESTestCase.assumeFalse((String)("week based formats won't work in jdk8 because SPI mechanism is not looking at classpath - needs ISOCalendarDataProvider in jre's ext/libs.Random format was =" + formatName), (boolean)runtimeJdk8);
        }
        return formatName.getSnakeCaseName();
    }

    public static <T> void maybeSet(Consumer<T> consumer, T value) {
        if (ESTestCase.randomBoolean()) {
            consumer.accept(value);
        }
    }

    public static <T> T randomValueOtherThan(T input, Supplier<T> randomSupplier) {
        return (T)ESTestCase.randomValueOtherThanMany(v -> Objects.equals(input, v), randomSupplier);
    }

    public static <T> T randomValueOtherThanMany(Predicate<T> input, Supplier<T> randomSupplier) {
        T randomValue = null;
        while (input.test(randomValue = (T)randomSupplier.get())) {
        }
        return randomValue;
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock) throws Exception {
        ESTestCase.assertBusy(codeBlock, 10L, TimeUnit.SECONDS);
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock, long maxWaitTime, TimeUnit unit) throws Exception {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long iterations = Math.max(Math.round(Math.log10(maxTimeInMillis) / Math.log10(2.0)), 1L);
        long timeInMillis = 1L;
        long sum = 0L;
        ArrayList<AssertionError> failures = new ArrayList<AssertionError>();
        int i = 0;
        while ((long)i < iterations) {
            try {
                codeBlock.run();
                return;
            }
            catch (AssertionError e) {
                failures.add(e);
                sum += timeInMillis;
                Thread.sleep(timeInMillis);
                timeInMillis *= 2L;
                ++i;
            }
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        try {
            codeBlock.run();
        }
        catch (AssertionError e) {
            for (AssertionError failure : failures) {
                ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)failure));
            }
            throw e;
        }
    }

    public static boolean waitUntil(BooleanSupplier breakSupplier) throws InterruptedException {
        return ESTestCase.waitUntil(breakSupplier, 10L, TimeUnit.SECONDS);
    }

    public static boolean waitUntil(BooleanSupplier breakSupplier, long maxWaitTime, TimeUnit unit) throws InterruptedException {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long timeInMillis = 1L;
        long sum = 0L;
        while (sum + timeInMillis < maxTimeInMillis) {
            if (breakSupplier.getAsBoolean()) {
                return true;
            }
            Thread.sleep(timeInMillis);
            sum += timeInMillis;
            timeInMillis = Math.min(1000L, timeInMillis * 2L);
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        return breakSupplier.getAsBoolean();
    }

    public static boolean terminate(ExecutorService ... services) {
        boolean terminated = true;
        for (ExecutorService service : services) {
            if (service == null) continue;
            terminated &= ThreadPool.terminate((ExecutorService)service, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        return terminated;
    }

    public static boolean terminate(ThreadPool threadPool) {
        return ThreadPool.terminate((ThreadPool)threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Path getDataPath(String relativePath) {
        try {
            return PathUtils.get((URI)((Object)((Object)this)).getClass().getResource(relativePath).toURI()).toAbsolutePath().normalize();
        }
        catch (Exception e) {
            throw new RuntimeException("resource not found: " + relativePath, e);
        }
    }

    public String[] tmpPaths() {
        int numPaths = TestUtil.nextInt((Random)ESTestCase.random(), (int)1, (int)3);
        String[] absPaths = new String[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            absPaths[i] = ESTestCase.createTempDir().toAbsolutePath().toString();
        }
        return absPaths;
    }

    public NodeEnvironment newNodeEnvironment() throws IOException {
        return this.newNodeEnvironment(Settings.EMPTY);
    }

    public Settings buildEnvSettings(Settings settings) {
        return Settings.builder().put(settings).put(Environment.PATH_HOME_SETTING.getKey(), ESTestCase.createTempDir().toAbsolutePath()).putList(Environment.PATH_DATA_SETTING.getKey(), this.tmpPaths()).build();
    }

    public NodeEnvironment newNodeEnvironment(Settings settings) throws IOException {
        Settings build = this.buildEnvSettings(settings);
        return new NodeEnvironment(build, TestEnvironment.newEnvironment(build));
    }

    public Environment newEnvironment() {
        Settings build = this.buildEnvSettings(Settings.EMPTY);
        return TestEnvironment.newEnvironment(build);
    }

    public Environment newEnvironment(Settings settings) {
        Settings build = this.buildEnvSettings(settings);
        return TestEnvironment.newEnvironment(build);
    }

    public static Settings.Builder settings(Version version) {
        Settings.Builder builder = Settings.builder().put("index.version.created", version);
        return builder;
    }

    @SafeVarargs
    public static <T> java.util.List<T> randomSubsetOf(int size, T ... values) {
        ArrayList list = CollectionUtils.arrayAsArrayList((Object[])values);
        return ESTestCase.randomSubsetOf(size, list);
    }

    public static <T> java.util.List<T> randomSubsetOf(Collection<T> collection) {
        return ESTestCase.randomSubsetOf(ESTestCase.randomInt(collection.size()), collection);
    }

    public static <T> java.util.List<T> randomSubsetOf(int size, Collection<T> collection) {
        if (size > collection.size()) {
            throw new IllegalArgumentException("Can't pick " + size + " random objects from a collection of " + collection.size() + " objects");
        }
        ArrayList<T> tempList = new ArrayList<T>(collection);
        Collections.shuffle(tempList, ESTestCase.random());
        return tempList.subList(0, size);
    }

    public static <T> Set<T> randomUnique(Supplier<T> supplier, int targetCount) {
        HashSet<T> things = new HashSet<T>();
        int maxTries = targetCount * 10;
        for (int t = 0; t < maxTries; ++t) {
            if (things.size() == targetCount) {
                return things;
            }
            things.add(supplier.get());
        }
        return things;
    }

    public static String randomGeohash(int minPrecision, int maxPrecision) {
        return geohashGenerator.ofStringLength(ESTestCase.random(), minPrecision, maxPrecision);
    }

    public static String getTestTransportType() {
        return "mock-nio";
    }

    public static Class<? extends Plugin> getTestTransportPlugin() {
        return MockNioTransportPlugin.class;
    }

    protected final BytesReference toShuffledXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable, String ... exceptFieldNames) throws IOException {
        BytesReference bytes = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
        try (XContentParser parser = this.createParser(xContentType.xContent(), bytes);){
            BytesReference bytesReference;
            block12: {
                XContentBuilder builder = ESTestCase.shuffleXContent(parser, ESTestCase.rarely(), exceptFieldNames);
                try {
                    bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    if (builder == null) break block12;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return bytesReference;
        }
    }

    protected final XContentBuilder shuffleXContent(XContentBuilder builder, String ... exceptFieldNames) throws IOException {
        try (XContentParser parser = this.createParser(builder);){
            XContentBuilder xContentBuilder = ESTestCase.shuffleXContent(parser, builder.isPrettyPrint(), exceptFieldNames);
            return xContentBuilder;
        }
    }

    public static XContentBuilder shuffleXContent(XContentParser parser, boolean prettyPrint, String ... exceptFieldNames) throws IOException {
        XContentParser.Token token;
        XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)parser.contentType());
        if (prettyPrint) {
            xContentBuilder.prettyPrint();
        }
        XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            java.util.List<Object> shuffledList = ESTestCase.shuffleList(parser.listOrderedMap(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
            return xContentBuilder.value(shuffledList);
        }
        LinkedHashMap<String, Object> shuffledMap = ESTestCase.shuffleMap((LinkedHashMap)parser.mapOrdered(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
        return xContentBuilder.map(shuffledMap);
    }

    private static java.util.List<Object> shuffleList(java.util.List<Object> list, Set<String> exceptFields) {
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object value : list) {
            if (value instanceof Map) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetList.add(ESTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof java.util.List) {
                targetList.add(ESTestCase.shuffleList((java.util.List)value, exceptFields));
                continue;
            }
            targetList.add(value);
        }
        return targetList;
    }

    public static LinkedHashMap<String, Object> shuffleMap(LinkedHashMap<String, Object> map, Set<String> exceptFields) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
        Collections.shuffle(keys, ESTestCase.random());
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof Map && !exceptFields.contains(key)) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetMap.put(key, ESTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof java.util.List && !exceptFields.contains(key)) {
                targetMap.put(key, ESTestCase.shuffleList((java.util.List)value, exceptFields));
                continue;
            }
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        return ESTestCase.copyWriteable(original, namedWriteableRegistry, reader, Version.CURRENT);
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, Version version) throws IOException {
        return ESTestCase.copyInstance(original, namedWriteableRegistry, (out, value) -> value.writeTo(out), reader, version);
    }

    public static <T extends NamedWriteable> T copyNamedWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Class<T> categoryClass) throws IOException {
        return ESTestCase.copyNamedWriteable(original, namedWriteableRegistry, categoryClass, Version.CURRENT);
    }

    public static <T extends NamedWriteable> T copyNamedWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Class<T> categoryClass, Version version) throws IOException {
        return ESTestCase.copyInstance(original, namedWriteableRegistry, (out, value) -> out.writeNamedWriteable(value), in -> in.readNamedWriteable(categoryClass), version);
    }

    protected static <T> T copyInstance(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Writer<T> writer, Writeable.Reader<T> reader, Version version) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            Object object;
            output.setVersion(version);
            writer.write((StreamOutput)output, original);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
                in.setVersion(version);
                object = reader.read((StreamInput)in);
            }
            return (T)object;
        }
    }

    protected final XContentParser createParser(XContentBuilder builder) throws IOException {
        return this.createParser(builder.contentType().xContent(), BytesReference.bytes((XContentBuilder)builder));
    }

    protected final XContentParser createParser(XContent xContent, String data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, InputStream data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, byte[] data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, BytesReference data) throws IOException {
        return this.createParser(this.xContentRegistry(), xContent, data);
    }

    protected final XContentParser createParser(NamedXContentRegistry namedXContentRegistry, XContent xContent, BytesReference data) throws IOException {
        if (data.hasArray()) {
            return xContent.createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data.array(), data.arrayOffset(), data.length());
        }
        return xContent.createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)data.streamInput());
    }

    protected NamedXContentRegistry xContentRegistry() {
        return DEFAULT_NAMED_X_CONTENT_REGISTRY;
    }

    protected NamedWriteableRegistry writableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }

    public static Script mockScript(String id) {
        return new Script(ScriptType.INLINE, "mockscript", id, Collections.emptyMap());
    }

    public static TestRuleMarkFailure getSuiteFailureMarker() {
        return suiteFailureMarker;
    }

    public static void assertArrayEquals(StackTraceElement[] expected, StackTraceElement[] actual) {
        ESTestCase.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            ESTestCase.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        ESTestCase.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        ESTestCase.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        ESTestCase.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        ESTestCase.assertEquals((long)expected.getLineNumber(), (long)actual.getLineNumber());
        ESTestCase.assertEquals((Object)expected.isNativeMethod(), (Object)actual.isNativeMethod());
    }

    protected static long spinForAtLeastOneMillisecond() {
        return ESTestCase.spinForAtLeastNMilliseconds(1L);
    }

    protected static long spinForAtLeastNMilliseconds(long ms) {
        long elapsed;
        long nanosecondsInMillisecond = TimeUnit.NANOSECONDS.convert(ms, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        while ((elapsed = System.nanoTime() - start) < nanosecondsInMillisecond) {
        }
        return elapsed;
    }

    protected IndexAnalyzers createDefaultIndexAnalyzers() {
        return new IndexAnalyzers(Collections.singletonMap("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())), Collections.emptyMap(), Collections.emptyMap());
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings nodeSettings = Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), ESTestCase.createTempDir()).build();
        return ESTestCase.createTestAnalysis(index, nodeSettings, settings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings nodeSettings, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings indexSettings = Settings.builder().put(settings).put("index.version.created", Version.CURRENT).build();
        return ESTestCase.createTestAnalysis(IndexSettingsModule.newIndexSettings(index, indexSettings, new Setting[0]), nodeSettings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(IndexSettings indexSettings, Settings nodeSettings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Environment env = TestEnvironment.newEnvironment(nodeSettings);
        AnalysisModule analysisModule = new AnalysisModule(env, Arrays.asList(analysisPlugins));
        AnalysisRegistry analysisRegistry = analysisModule.getAnalysisRegistry();
        return new TestAnalysis(analysisRegistry.build(indexSettings), analysisRegistry.buildTokenFilterFactories(indexSettings), analysisRegistry.buildTokenizerFactories(indexSettings), analysisRegistry.buildCharFilterFactories(indexSettings));
    }

    private static boolean isUnusableLocale() {
        return ESTestCase.inFipsJvm() && (Locale.getDefault().toLanguageTag().equals("th-TH") || Locale.getDefault().toLanguageTag().equals("ja-JP-u-ca-japanese-x-lvariant-JP") || Locale.getDefault().toLanguageTag().equals("th-TH-u-nu-thai-x-lvariant-TH"));
    }

    public static boolean inFipsJvm() {
        return Boolean.parseBoolean(System.getProperty(FIPS_SYSPROP));
    }

    public static String getPortRange() {
        return ESTestCase.getBasePort() + "-" + (ESTestCase.getBasePort() + 99);
    }

    protected static int getBasePort() {
        int startAt;
        String workerIdStr = System.getProperty(TEST_WORKER_SYS_PROPERTY);
        if (workerIdStr == null) {
            startAt = 0;
        } else {
            long workerId = Long.valueOf(workerIdStr);
            assert (workerId >= 1L) : "Non positive gradle worker id: " + workerIdStr;
            startAt = (int)Math.floorMod(workerId - 1L, 223L) + 1;
        }
        assert (startAt >= 0) : "Unexpected test worker Id, resulting port range would be negative";
        return 13301 + startAt * 100;
    }

    protected static InetAddress randomIp(boolean v4) {
        try {
            if (v4) {
                byte[] ipv4 = new byte[4];
                ESTestCase.random().nextBytes(ipv4);
                return InetAddress.getByAddress(ipv4);
            }
            byte[] ipv6 = new byte[16];
            ESTestCase.random().nextBytes(ipv6);
            return InetAddress.getByAddress(ipv6);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    private static /* synthetic */ void lambda$static$0(Appender leakAppender) {
        leakAppender.stop();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configurator.shutdown((LoggerContext)context);
    }

    static {
        portGenerator = new AtomicInteger();
        loggedLeaks = new ArrayList<String>();
        TEST_WORKER_VM_ID = System.getProperty(TEST_WORKER_SYS_PROPERTY, DEFAULT_TEST_WORKER_ID);
        ESTestCase.setTestSysProps();
        LogConfigurator.loadLog4jPlugins();
        for (String leakLoggerName : Arrays.asList("io.netty.util.ResourceLeakDetector", LeakTracker.class.getName())) {
            Logger leakLogger = LogManager.getLogger((String)leakLoggerName);
            AbstractAppender leakAppender = new AbstractAppender(leakLoggerName, null, (Layout)PatternLayout.newBuilder().withPattern("%m").build()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void append(LogEvent event) {
                    String message = event.getMessage().getFormattedMessage();
                    if (Level.ERROR.equals((Object)event.getLevel()) && message.contains("LEAK:")) {
                        Collection collection = loggedLeaks;
                        synchronized (collection) {
                            loggedLeaks.add(message);
                        }
                    }
                }
            };
            leakAppender.start();
            Loggers.addAppender((Logger)leakLogger, (Appender)leakAppender);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ESTestCase.lambda$static$0((Appender)leakAppender)));
        }
        BootstrapForTesting.ensureInitialized();
        java.util.List jodaTZIds = DateTimeZone.getAvailableIDs().stream().filter(s -> !DateUtils.DEPRECATED_SHORT_TZ_IDS.contains(s)).sorted().collect(Collectors.toList());
        JODA_TIMEZONE_IDS = Collections.unmodifiableList(jodaTZIds);
        java.util.List<String> javaTZIds = Arrays.asList(TimeZone.getAvailableIDs());
        Collections.sort(javaTZIds);
        JAVA_TIMEZONE_IDS = Collections.unmodifiableList(javaTZIds);
        ArrayList<String> javaZoneIds = new ArrayList<String>(ZoneId.getAvailableZoneIds());
        Collections.sort(javaZoneIds);
        JAVA_ZONE_IDS = Collections.unmodifiableList(javaZoneIds);
        statusData = new ArrayList<StatusData>();
        StatusLogger.getLogger().setLevel(Level.WARN);
        StatusLogger.getLogger().registerListener((StatusListener)new StatusConsoleListener(Level.WARN){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void log(StatusData data) {
                java.util.List list = statusData;
                synchronized (list) {
                    statusData.add(data);
                }
            }
        });
        LOG_4J_MSG_PREFIXES = List.of((Object)"JNDI lookup class is not available because this JRE does not support JNDI. JNDI string lookups will not be available, continuing configuration.", (Object)"JMX runtime input lookup class is not available because this JRE does not support JMX. JMX lookups will not be available, continuing configuration. ");
        checkIndexFailures = new CopyOnWriteArrayList<Exception>();
        TIME_SUFFIXES = new String[]{"d", "h", "ms", "s", "m", "micros", "nanos"};
        geohashGenerator = new GeohashGenerator();
        DEFAULT_NAMED_X_CONTENT_REGISTRY = new NamedXContentRegistry(CollectionUtils.concatLists((java.util.List)ClusterModule.getNamedXWriteables(), (java.util.List)IndicesModule.getNamedXContents()));
        DEFAULT_NAMED_WRITABLE_REGISTRY = new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }

    public static final class DeprecationWarning {
        private final Level level;
        private final String message;

        public DeprecationWarning(Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public int hashCode() {
            return Objects.hash(this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeprecationWarning that = (DeprecationWarning)o;
            return Objects.equals(this.message, that.message);
        }

        public String toString() {
            return String.format(Locale.ROOT, "%s: %s", this.level.name(), this.message);
        }
    }

    public static class GeohashGenerator
    extends CodepointSetGenerator {
        private static final char[] ASCII_SET = "0123456789bcdefghjkmnpqrstuvwxyz".toCharArray();

        public GeohashGenerator() {
            super(ASCII_SET);
        }
    }

    public static final class TestAnalysis {
        public final IndexAnalyzers indexAnalyzers;
        public final Map<String, TokenFilterFactory> tokenFilter;
        public final Map<String, TokenizerFactory> tokenizer;
        public final Map<String, CharFilterFactory> charFilter;

        public TestAnalysis(IndexAnalyzers indexAnalyzers, Map<String, TokenFilterFactory> tokenFilter, Map<String, TokenizerFactory> tokenizer, Map<String, CharFilterFactory> charFilter) {
            this.indexAnalyzers = indexAnalyzers;
            this.tokenFilter = tokenFilter;
            this.tokenizer = tokenizer;
            this.charFilter = charFilter;
        }
    }
}

