/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.HasAttributeNodeSelector;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.section.ApiCallSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.SkipSection;
import org.elasticsearch.test.rest.yaml.section.VersionRange;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class DoSection
implements ExecutableSection {
    private static final Logger logger = LogManager.getLogger(DoSection.class);
    private final XContentLocation location;
    private String catchParam;
    private ApiCallSection apiCallSection;
    private List<String> expectedWarningHeaders = Collections.emptyList();
    private List<Pattern> expectedWarningHeadersRegex = Collections.emptyList();
    private List<String> allowedWarningHeaders = Collections.emptyList();
    private List<Pattern> allowedWarningHeadersRegex = Collections.emptyList();
    private static final Map<String, Tuple<String, org.hamcrest.Matcher<Integer>>> CATCHES = org.elasticsearch.core.Map.ofEntries((Map.Entry[])new Map.Entry[]{org.elasticsearch.core.Map.entry((Object)"bad_request", (Object)Tuple.tuple((Object)"400", (Object)Matchers.equalTo((Object)400))), org.elasticsearch.core.Map.entry((Object)"unauthorized", (Object)Tuple.tuple((Object)"401", (Object)Matchers.equalTo((Object)401))), org.elasticsearch.core.Map.entry((Object)"forbidden", (Object)Tuple.tuple((Object)"403", (Object)Matchers.equalTo((Object)403))), org.elasticsearch.core.Map.entry((Object)"missing", (Object)Tuple.tuple((Object)"404", (Object)Matchers.equalTo((Object)404))), org.elasticsearch.core.Map.entry((Object)"request_timeout", (Object)Tuple.tuple((Object)"408", (Object)Matchers.equalTo((Object)408))), org.elasticsearch.core.Map.entry((Object)"conflict", (Object)Tuple.tuple((Object)"409", (Object)Matchers.equalTo((Object)409))), org.elasticsearch.core.Map.entry((Object)"unavailable", (Object)Tuple.tuple((Object)"503", (Object)Matchers.equalTo((Object)503))), org.elasticsearch.core.Map.entry((Object)"request", (Object)Tuple.tuple((Object)"4xx|5xx", (Object)Matchers.allOf((org.hamcrest.Matcher[])new org.hamcrest.Matcher[]{Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)400)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)401)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)403)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)404)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)408)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)409))})))});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        DoSection doSection = new DoSection(parser.getTokenLocation());
        ApiCallSection apiCallSection = null;
        NodeSelector nodeSelector = NodeSelector.ANY;
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> expectedWarnings = new ArrayList<String>();
        ArrayList<Pattern> expectedWarningsRegex = new ArrayList<Pattern>();
        ArrayList<String> allowedWarnings = new ArrayList<String>();
        ArrayList<Pattern> allowedWarningsRegex = new ArrayList<Pattern>();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("expected [" + XContentParser.Token.START_OBJECT + "], found [" + parser.currentToken() + "], the do section is not properly indented");
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("catch".equals(currentFieldName)) {
                    doSection.setCatch(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "unsupported field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("warnings".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        expectedWarnings.add(parser.text());
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[warnings] must be a string array but saw [" + token + "]", new Object[0]);
                }
                if ("warnings_regex".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        expectedWarningsRegex.add(Pattern.compile(parser.text()));
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[warnings_regex] must be a string array but saw [" + token + "]", new Object[0]);
                }
                if ("allowed_warnings".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        allowedWarnings.add(parser.text());
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[allowed_warnings] must be a string array but saw [" + token + "]", new Object[0]);
                }
                if ("allowed_warnings_regex".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        allowedWarningsRegex.add(Pattern.compile(parser.text()));
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[allowed_warnings_regex] must be a string array but saw [" + token + "]", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "unknown array [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("headers".equals(currentFieldName)) {
                String headerName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        headerName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    headers.put(headerName, parser.text());
                }
                continue;
            }
            if ("node_selector".equals(currentFieldName)) {
                String selectorName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        selectorName = parser.currentName();
                        continue;
                    }
                    NodeSelector newSelector = DoSection.buildNodeSelector(selectorName, parser);
                    nodeSelector = nodeSelector == NodeSelector.ANY ? newSelector : new ComposeNodeSelector(nodeSelector, newSelector);
                }
                continue;
            }
            if (currentFieldName == null) continue;
            apiCallSection = new ApiCallSection(currentFieldName);
            String paramName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    paramName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("body".equals(paramName)) {
                        String body = parser.text();
                        XContentParser bodyParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, body);
                        while (bodyParser.nextToken() != null) {
                            apiCallSection.addBody(bodyParser.mapOrdered());
                        }
                        continue;
                    }
                    apiCallSection.addParam(paramName, parser.text());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !"body".equals(paramName)) continue;
                apiCallSection.addBody(parser.mapOrdered());
            }
        }
        try {
            if (apiCallSection == null) {
                throw new IllegalArgumentException("client call section is mandatory within a do section");
            }
            for (String w : expectedWarnings) {
                if (!allowedWarnings.contains(w)) continue;
                throw new IllegalArgumentException("the warning [" + w + "] was both allowed and expected");
            }
            for (Pattern p : expectedWarningsRegex) {
                if (!allowedWarningsRegex.contains(p)) continue;
                throw new IllegalArgumentException("the warning pattern [" + p + "] was both allowed and expected");
            }
            apiCallSection.addHeaders(headers);
            apiCallSection.setNodeSelector(nodeSelector);
            doSection.setApiCallSection(apiCallSection);
            doSection.setExpectedWarningHeaders(Collections.unmodifiableList(expectedWarnings));
            doSection.setExpectedWarningHeadersRegex(Collections.unmodifiableList(expectedWarningsRegex));
            doSection.setAllowedWarningHeaders(Collections.unmodifiableList(allowedWarnings));
            doSection.setAllowedWarningHeadersRegex(Collections.unmodifiableList(allowedWarningsRegex));
        }
        finally {
            parser.nextToken();
        }
        return doSection;
    }

    public DoSection(XContentLocation location) {
        this.location = location;
    }

    public String getCatch() {
        return this.catchParam;
    }

    public void setCatch(String param) {
        this.catchParam = param;
    }

    public ApiCallSection getApiCallSection() {
        return this.apiCallSection;
    }

    void setApiCallSection(ApiCallSection apiCallSection) {
        this.apiCallSection = apiCallSection;
    }

    List<String> getExpectedWarningHeaders() {
        return this.expectedWarningHeaders;
    }

    List<Pattern> getExpectedWarningHeadersRegex() {
        return this.expectedWarningHeadersRegex;
    }

    void setExpectedWarningHeaders(List<String> expectedWarningHeaders) {
        this.expectedWarningHeaders = expectedWarningHeaders;
    }

    void setExpectedWarningHeadersRegex(List<Pattern> expectedWarningHeadersRegex) {
        this.expectedWarningHeadersRegex = expectedWarningHeadersRegex;
    }

    List<String> getAllowedWarningHeaders() {
        return this.allowedWarningHeaders;
    }

    List<Pattern> getAllowedWarningHeadersRegex() {
        return this.allowedWarningHeadersRegex;
    }

    void setAllowedWarningHeaders(List<String> allowedWarningHeaders) {
        this.allowedWarningHeaders = allowedWarningHeaders;
    }

    void setAllowedWarningHeadersRegex(List<Pattern> allowedWarningHeadersRegex) {
        this.allowedWarningHeadersRegex = allowedWarningHeadersRegex;
    }

    @Override
    public XContentLocation getLocation() {
        return this.location;
    }

    @Override
    public void execute(ClientYamlTestExecutionContext executionContext) throws IOException {
        if ("param".equals(this.catchParam)) {
            logger.info("found [catch: param], no request sent");
            return;
        }
        try {
            ClientYamlTestResponse response = executionContext.callApi(this.apiCallSection.getApi(), this.apiCallSection.getParams(), this.apiCallSection.getBodies(), this.apiCallSection.getHeaders(), this.apiCallSection.getNodeSelector());
            if (Strings.hasLength((String)this.catchParam)) {
                String catchStatusCode;
                if (CATCHES.containsKey(this.catchParam)) {
                    catchStatusCode = (String)CATCHES.get(this.catchParam).v1();
                } else if (this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                    catchStatusCode = "4xx|5xx";
                } else {
                    throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
                }
                Assert.fail((String)this.formatStatusCodeMessage(response, catchStatusCode));
            }
            String testPath = executionContext.getClientYamlTestCandidate() != null ? executionContext.getClientYamlTestCandidate().getTestPath() : null;
            this.checkWarningHeaders(response.getWarningHeaders(), testPath, executionContext.masterVersion());
        }
        catch (ClientYamlTestResponseException e) {
            ClientYamlTestResponse restTestResponse = e.getRestTestResponse();
            if (!Strings.hasLength((String)this.catchParam)) {
                Assert.fail((String)this.formatStatusCodeMessage(restTestResponse, "2xx"));
            }
            if (CATCHES.containsKey(this.catchParam)) {
                this.assertStatusCode(restTestResponse);
            }
            if (this.catchParam.length() > 2 && this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                Assert.assertThat((String)this.formatStatusCodeMessage(restTestResponse, "4xx|5xx"), (Object)e.getResponseException().getResponse().getStatusLine().getStatusCode(), (org.hamcrest.Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)));
                Object error = executionContext.response("error");
                Assert.assertThat((String)"error was expected in the response", (Object)error, (org.hamcrest.Matcher)Matchers.notNullValue());
                String regex = this.catchParam.substring(1, this.catchParam.length() - 1);
                Assert.assertThat((String)"the error message was expected to match the provided regex but didn't", (Object)error.toString(), (org.hamcrest.Matcher)RegexMatcher.matches(regex));
            }
            throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
        }
    }

    void checkWarningHeaders(List<String> warningHeaders, Version masterVersion) {
        this.checkWarningHeaders(warningHeaders, null, masterVersion);
    }

    void checkWarningHeaders(List<String> warningHeaders, String testPath, Version masterVersion) {
        ArrayList<String> unexpected = new ArrayList<String>();
        ArrayList<String> unmatched = new ArrayList<String>();
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> missingRegex = new ArrayList<String>();
        Set allowed = this.allowedWarningHeaders.stream().map(HeaderWarning::escapeAndEncode).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<Pattern> allowedRegex = new LinkedHashSet<Pattern>(this.allowedWarningHeadersRegex);
        Set expected = this.expectedWarningHeaders.stream().map(HeaderWarning::escapeAndEncode).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<Pattern> expectedRegex = new LinkedHashSet<Pattern>(this.expectedWarningHeadersRegex);
        for (String header : warningHeaders) {
            Matcher matcher = HeaderWarning.WARNING_HEADER_PATTERN.matcher(header);
            boolean matches = matcher.matches();
            if (matches) {
                String message = HeaderWarning.extractWarningValueFromWarningHeader((String)header, (boolean)true);
                if (masterVersion.before(Version.V_7_0_0) && message.equals("the default number of shards will change from [5] to [1] in 7.0.0; if you wish to continue using the default of [5] shards, you must manage this on the create index request or with an index template") || message.startsWith("[types removal]") || allowed.contains(message) || expected.remove(message)) continue;
                boolean matchedRegex = false;
                for (Pattern pattern : new HashSet<Pattern>(expectedRegex)) {
                    if (!pattern.matcher(message).matches()) continue;
                    matchedRegex = true;
                    expectedRegex.remove(pattern);
                    break;
                }
                for (Pattern pattern : allowedRegex) {
                    if (!pattern.matcher(message).matches()) continue;
                    matchedRegex = true;
                    break;
                }
                if (matchedRegex) continue;
                unexpected.add(header);
                continue;
            }
            unmatched.add(header);
        }
        if (!expected.isEmpty()) {
            for (String header : expected) {
                missing.add(header);
            }
        }
        if (!expectedRegex.isEmpty()) {
            for (Pattern headerPattern : expectedRegex) {
                missingRegex.add(headerPattern.pattern());
            }
        }
        Iterator warnings = unexpected.iterator();
        while (warnings.hasNext()) {
            if (!((String)warnings.next()).endsWith("Legacy index templates are deprecated in favor of composable templates.\"")) continue;
            logger.warn("Test [{}] uses deprecated legacy index templates and should be updated to use composable templates", (Object)((testPath == null ? "<unknown>" : testPath) + ":" + this.getLocation().lineNumber));
            warnings.remove();
        }
        if (!(unexpected.isEmpty() && unmatched.isEmpty() && missing.isEmpty() && missingRegex.isEmpty())) {
            StringBuilder failureMessage = new StringBuilder();
            this.appendBadHeaders(failureMessage, unexpected, "got unexpected warning header" + (unexpected.size() > 1 ? "s" : ""));
            this.appendBadHeaders(failureMessage, unmatched, "got unmatched warning header" + (unmatched.size() > 1 ? "s" : ""));
            this.appendBadHeaders(failureMessage, missing, "did not get expected warning header" + (missing.size() > 1 ? "s" : ""));
            this.appendBadHeaders(failureMessage, missingRegex, "the following regular expression" + (missingRegex.size() > 1 ? "s" : "") + " did not match any warning header");
            Assert.fail((String)failureMessage.toString());
        }
    }

    private void appendBadHeaders(StringBuilder sb, List<String> headers, String message) {
        if (!headers.isEmpty()) {
            sb.append(message).append(" [\n");
            for (String header : headers) {
                sb.append("\t").append(header).append("\n");
            }
            sb.append("]\n");
        }
    }

    private void assertStatusCode(ClientYamlTestResponse restTestResponse) {
        Tuple<String, org.hamcrest.Matcher<Integer>> stringMatcherTuple = CATCHES.get(this.catchParam);
        Assert.assertThat((String)this.formatStatusCodeMessage(restTestResponse, (String)stringMatcherTuple.v1()), (Object)restTestResponse.getStatusCode(), (org.hamcrest.Matcher)((org.hamcrest.Matcher)stringMatcherTuple.v2()));
    }

    private String formatStatusCodeMessage(ClientYamlTestResponse restTestResponse, String expected) {
        String api = this.apiCallSection.getApi();
        if ("raw".equals(api)) {
            api = api + "[method=" + this.apiCallSection.getParams().get("method") + " path=" + this.apiCallSection.getParams().get("path") + "]";
        }
        return "expected [" + expected + "] status code but api [" + api + "] returned [" + restTestResponse.getStatusCode() + " " + restTestResponse.getReasonPhrase() + "] [" + restTestResponse.getBodyAsString() + "]";
    }

    private static NodeSelector buildNodeSelector(String name, XContentParser parser) throws IOException {
        switch (name) {
            case "attribute": {
                return DoSection.parseAttributeValuesSelector(parser);
            }
            case "version": {
                return DoSection.parseVersionSelector(parser);
            }
        }
        throw new XContentParseException(parser.getTokenLocation(), "unknown node_selector [" + name + "]");
    }

    private static NodeSelector parseAttributeValuesSelector(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "expected START_OBJECT");
        }
        String key = null;
        NodeSelector result = NodeSelector.ANY;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                key = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                HasAttributeNodeSelector delegate = new HasAttributeNodeSelector(key, parser.text());
                NodeSelector newSelector = new NodeSelector((NodeSelector)delegate){
                    final /* synthetic */ NodeSelector val$delegate;
                    {
                        this.val$delegate = nodeSelector;
                    }

                    public void select(Iterable<Node> nodes) {
                        for (Node node : nodes) {
                            if (node.getAttributes() != null) continue;
                            throw new IllegalStateException("expected [attributes] metadata to be set but got " + node);
                        }
                        this.val$delegate.select(nodes);
                    }

                    public String toString() {
                        return this.val$delegate.toString();
                    }
                };
                result = result == NodeSelector.ANY ? newSelector : new ComposeNodeSelector(result, newSelector);
                continue;
            }
            throw new XContentParseException(parser.getTokenLocation(), "expected [" + key + "] to be a value");
        }
        return result;
    }

    private static NodeSelector parseVersionSelector(XContentParser parser) throws IOException {
        if (!parser.currentToken().isValue()) {
            throw new XContentParseException(parser.getTokenLocation(), "expected [version] to be a value");
        }
        final List skipVersionRanges = parser.text().equals("current") ? org.elasticsearch.core.List.of((Object)new VersionRange(Version.CURRENT, Version.CURRENT)) : SkipSection.parseVersionRanges(parser.text());
        return new NodeSelector(){

            public void select(Iterable<Node> nodes) {
                Iterator<Node> itr = nodes.iterator();
                while (itr.hasNext()) {
                    Node node = itr.next();
                    if (node.getVersion() == null) {
                        throw new IllegalStateException("expected [version] metadata to be set but got " + node);
                    }
                    Version version = Version.fromString((String)node.getVersion());
                    boolean skip = skipVersionRanges.stream().anyMatch(v -> v.contains(version));
                    if (skip) continue;
                    itr.remove();
                }
            }

            public String toString() {
                return "version ranges " + skipVersionRanges;
            }
        };
    }

    private static class ComposeNodeSelector
    implements NodeSelector {
        private final NodeSelector lhs;
        private final NodeSelector rhs;

        private ComposeNodeSelector(NodeSelector lhs, NodeSelector rhs) {
            this.lhs = Objects.requireNonNull(lhs, "lhs is required");
            this.rhs = Objects.requireNonNull(rhs, "rhs is required");
        }

        public void select(Iterable<Node> nodes) {
            this.rhs.select(nodes);
            this.lhs.select(nodes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComposeNodeSelector that = (ComposeNodeSelector)o;
            return Objects.equals(this.lhs, that.lhs) && Objects.equals(this.rhs, that.rhs);
        }

        public int hashCode() {
            return Objects.hash(this.lhs, this.rhs);
        }

        public String toString() {
            return this.lhs + "." + this.rhs;
        }
    }
}

