/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;

public class MockSecureSettings
implements SecureSettings {
    private Map<String, String> secureStrings = new HashMap<String, String>();
    private Map<String, byte[]> files = new HashMap<String, byte[]>();
    private Map<String, byte[]> sha256Digests = new HashMap<String, byte[]>();
    private Set<String> settingNames = new HashSet<String>();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MockSecureSettings() {
    }

    private MockSecureSettings(MockSecureSettings source) {
        this.secureStrings.putAll(source.secureStrings);
        this.files.putAll(source.files);
        this.sha256Digests.putAll(source.sha256Digests);
        this.settingNames.addAll(source.settingNames);
    }

    public boolean isLoaded() {
        return true;
    }

    public Set<String> getSettingNames() {
        return this.settingNames;
    }

    public SecureString getString(String setting) {
        this.ensureOpen();
        String s = this.secureStrings.get(setting);
        if (s == null) {
            return null;
        }
        return new SecureString(s.toCharArray());
    }

    public InputStream getFile(String setting) {
        this.ensureOpen();
        return new ByteArrayInputStream(this.files.get(setting));
    }

    public byte[] getSHA256Digest(String setting) {
        return this.sha256Digests.get(setting);
    }

    public void setString(String setting, String value) {
        this.ensureOpen();
        this.secureStrings.put(setting, value);
        this.sha256Digests.put(setting, MessageDigests.sha256().digest(value.getBytes(StandardCharsets.UTF_8)));
        this.settingNames.add(setting);
    }

    public void setFile(String setting, byte[] value) {
        this.ensureOpen();
        this.files.put(setting, value);
        this.sha256Digests.put(setting, MessageDigests.sha256().digest(value));
        this.settingNames.add(setting);
    }

    public void merge(MockSecureSettings secureSettings) {
        for (String setting : secureSettings.getSettingNames()) {
            if (!this.settingNames.contains(setting)) continue;
            throw new IllegalArgumentException("Cannot overwrite existing secure setting " + setting);
        }
        this.settingNames.addAll(secureSettings.settingNames);
        this.secureStrings.putAll(secureSettings.secureStrings);
        this.sha256Digests.putAll(secureSettings.sha256Digests);
        this.files.putAll(secureSettings.files);
    }

    public void close() throws IOException {
        this.closed.set(true);
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new IllegalStateException("secure settings are already closed");
        }
    }

    public SecureSettings clone() {
        this.ensureOpen();
        return new MockSecureSettings(this);
    }
}

