/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class DeterministicTaskQueue {
    private static final Logger logger = LogManager.getLogger(DeterministicTaskQueue.class);
    public static final String NODE_ID_LOG_CONTEXT_KEY = "nodeId";
    private final Settings settings;
    private final List<Runnable> runnableTasks = new ArrayList<Runnable>();
    private final Random random;
    private List<DeferredTask> deferredTasks = new ArrayList<DeferredTask>();
    private long currentTimeMillis;
    private long nextDeferredTaskExecutionTimeMillis = Long.MAX_VALUE;
    private long executionDelayVariabilityMillis;
    private long latestDeferredExecutionTime;

    public DeterministicTaskQueue(Settings settings, Random random) {
        this.settings = settings;
        this.random = random;
    }

    public DeterministicTaskQueue() {
        this(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), "deterministic-task-queue").build(), ESTestCase.random());
    }

    public long getExecutionDelayVariabilityMillis() {
        return this.executionDelayVariabilityMillis;
    }

    public void setExecutionDelayVariabilityMillis(long executionDelayVariabilityMillis) {
        assert (executionDelayVariabilityMillis >= 0L) : executionDelayVariabilityMillis;
        this.executionDelayVariabilityMillis = executionDelayVariabilityMillis;
    }

    public void runAllRunnableTasks() {
        while (this.hasRunnableTasks()) {
            this.runRandomTask();
        }
    }

    public void runAllTasks() {
        while (this.hasDeferredTasks() || this.hasRunnableTasks()) {
            if (this.hasDeferredTasks() && this.random.nextBoolean()) {
                this.advanceTime();
                continue;
            }
            if (!this.hasRunnableTasks()) continue;
            this.runRandomTask();
        }
    }

    public void runAllTasksInTimeOrder() {
        while (this.hasDeferredTasks() || this.hasRunnableTasks()) {
            if (this.hasRunnableTasks()) {
                this.runRandomTask();
                continue;
            }
            this.advanceTime();
        }
    }

    public boolean hasRunnableTasks() {
        return !this.runnableTasks.isEmpty();
    }

    public boolean hasDeferredTasks() {
        return !this.deferredTasks.isEmpty();
    }

    public long getCurrentTimeMillis() {
        return this.currentTimeMillis;
    }

    public void runRandomTask() {
        assert (this.hasRunnableTasks());
        this.runTask(RandomNumbers.randomIntBetween((Random)this.random, (int)0, (int)(this.runnableTasks.size() - 1)));
    }

    private void runTask(int index) {
        Runnable task = this.runnableTasks.remove(index);
        logger.trace("running task {} of {}: {}", (Object)index, (Object)(this.runnableTasks.size() + 1), (Object)task);
        task.run();
    }

    public void scheduleNow(Runnable task) {
        if (this.executionDelayVariabilityMillis > 0L && this.random.nextBoolean()) {
            long executionDelay = RandomNumbers.randomLongBetween((Random)this.random, (long)1L, (long)this.executionDelayVariabilityMillis);
            DeferredTask deferredTask = new DeferredTask(this.currentTimeMillis + executionDelay, task);
            logger.trace("scheduleNow: delaying [{}ms], scheduling {}", (Object)executionDelay, (Object)deferredTask);
            this.scheduleDeferredTask(deferredTask);
        } else {
            logger.trace("scheduleNow: adding runnable {}", (Object)task);
            this.runnableTasks.add(task);
        }
    }

    public void scheduleAt(long executionTimeMillis, Runnable task) {
        long extraDelayMillis = RandomNumbers.randomLongBetween((Random)this.random, (long)0L, (long)this.executionDelayVariabilityMillis);
        long actualExecutionTimeMillis = executionTimeMillis + extraDelayMillis;
        if (actualExecutionTimeMillis <= this.currentTimeMillis) {
            logger.trace("scheduleAt: [{}ms] is not in the future, adding runnable {}", (Object)executionTimeMillis, (Object)task);
            this.runnableTasks.add(task);
        } else {
            DeferredTask deferredTask = new DeferredTask(actualExecutionTimeMillis, task);
            logger.trace("scheduleAt: adding {} with extra delay of [{}ms]", (Object)deferredTask, (Object)extraDelayMillis);
            this.scheduleDeferredTask(deferredTask);
        }
    }

    private void scheduleDeferredTask(DeferredTask deferredTask) {
        this.nextDeferredTaskExecutionTimeMillis = Math.min(this.nextDeferredTaskExecutionTimeMillis, deferredTask.getExecutionTimeMillis());
        this.latestDeferredExecutionTime = Math.max(this.latestDeferredExecutionTime, deferredTask.getExecutionTimeMillis());
        this.deferredTasks.add(deferredTask);
    }

    public void advanceTime() {
        assert (this.hasDeferredTasks());
        assert (this.currentTimeMillis < this.nextDeferredTaskExecutionTimeMillis);
        logger.trace("advanceTime: from [{}ms] to [{}ms]", (Object)this.currentTimeMillis, (Object)this.nextDeferredTaskExecutionTimeMillis);
        this.currentTimeMillis = this.nextDeferredTaskExecutionTimeMillis;
        assert (this.currentTimeMillis <= this.latestDeferredExecutionTime) : this.latestDeferredExecutionTime + " < " + this.currentTimeMillis;
        this.nextDeferredTaskExecutionTimeMillis = Long.MAX_VALUE;
        ArrayList<DeferredTask> remainingDeferredTasks = new ArrayList<DeferredTask>();
        for (DeferredTask deferredTask : this.deferredTasks) {
            assert (this.currentTimeMillis <= deferredTask.getExecutionTimeMillis());
            if (deferredTask.getExecutionTimeMillis() == this.currentTimeMillis) {
                logger.trace("advanceTime: no longer deferred: {}", (Object)deferredTask);
                this.runnableTasks.add(deferredTask.getTask());
                continue;
            }
            remainingDeferredTasks.add(deferredTask);
            this.nextDeferredTaskExecutionTimeMillis = Math.min(this.nextDeferredTaskExecutionTimeMillis, deferredTask.getExecutionTimeMillis());
        }
        this.deferredTasks = remainingDeferredTasks;
        assert (this.deferredTasks.isEmpty() == (this.nextDeferredTaskExecutionTimeMillis == Long.MAX_VALUE));
    }

    public PrioritizedEsThreadPoolExecutor getPrioritizedEsThreadPoolExecutor() {
        return this.getPrioritizedEsThreadPoolExecutor(Function.identity());
    }

    public PrioritizedEsThreadPoolExecutor getPrioritizedEsThreadPoolExecutor(final Function<Runnable, Runnable> runnableWrapper) {
        return new PrioritizedEsThreadPoolExecutor("DeterministicTaskQueue", 1, 1, 1L, TimeUnit.SECONDS, r -> {
            throw new AssertionError((Object)"should not create new threads");
        }, null, null, PrioritizedEsThreadPoolExecutor.StarvationWatcher.NOOP_STARVATION_WATCHER){

            public void execute(Runnable command, TimeValue timeout, Runnable timeoutCallback) {
                throw new AssertionError((Object)"not implemented");
            }

            public void execute(Runnable command) {
                Runnable wrappedCommand = (Runnable)runnableWrapper.apply(command);
                ((Runnable)runnableWrapper.apply(() -> DeterministicTaskQueue.this.scheduleNow(wrappedCommand))).run();
            }
        };
    }

    public ThreadPool getThreadPool() {
        return this.getThreadPool(Function.identity());
    }

    public ThreadPool getThreadPool(final Function<Runnable, Runnable> runnableWrapper) {
        return new ThreadPool(this.settings, new ExecutorBuilder[0]){
            private final Map<String, ThreadPool.Info> infos;
            private final ExecutorService forkingExecutor;
            {
                super(arg0, arg1);
                this.stopCachedTimeThread();
                this.infos = new HashMap<String, ThreadPool.Info>();
                this.forkingExecutor = new ExecutorService(){

                    @Override
                    public void shutdown() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isShutdown() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isTerminated() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean awaitTermination(long timeout, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> Future<T> submit(Callable<T> task) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> Future<T> submit(Runnable task, T result1) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Future<?> submit(Runnable task) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void execute(Runnable command) {
                        DeterministicTaskQueue.this.scheduleNow((Runnable)runnableWrapper.apply(command));
                    }
                };
            }

            public long relativeTimeInMillis() {
                return DeterministicTaskQueue.this.currentTimeMillis;
            }

            public long rawRelativeTimeInMillis() {
                return DeterministicTaskQueue.this.currentTimeMillis;
            }

            public long absoluteTimeInMillis() {
                return DeterministicTaskQueue.this.currentTimeMillis;
            }

            public ThreadPoolInfo info() {
                throw new UnsupportedOperationException();
            }

            public ThreadPool.Info info(String name) {
                return this.infos.computeIfAbsent(name, n -> new ThreadPool.Info(n, ThreadPool.ThreadPoolType.FIXED, DeterministicTaskQueue.this.random.nextInt(10) + 1));
            }

            public ThreadPoolStats stats() {
                throw new UnsupportedOperationException();
            }

            public ExecutorService generic() {
                return this.executor("generic");
            }

            public ExecutorService executor(String name) {
                return "same".equals(name) ? EsExecutors.DIRECT_EXECUTOR_SERVICE : this.forkingExecutor;
            }

            public Scheduler.ScheduledCancellable schedule(final Runnable command, TimeValue delay, String executor) {
                boolean NOT_STARTED = false;
                boolean STARTED = true;
                int CANCELLED = 2;
                final AtomicInteger taskState = new AtomicInteger(0);
                DeterministicTaskQueue.this.scheduleAt(DeterministicTaskQueue.this.currentTimeMillis + delay.millis(), (Runnable)runnableWrapper.apply(new Runnable(){

                    @Override
                    public void run() {
                        if (taskState.compareAndSet(0, 1)) {
                            command.run();
                        }
                    }

                    public String toString() {
                        return command.toString();
                    }
                }));
                return new Scheduler.ScheduledCancellable(){

                    public long getDelay(TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    public int compareTo(Delayed o) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean cancel() {
                        return taskState.compareAndSet(0, 2);
                    }

                    public boolean isCancelled() {
                        return taskState.get() == 2;
                    }
                };
            }

            public Scheduler.Cancellable scheduleWithFixedDelay(Runnable command, TimeValue interval, String executor) {
                return super.scheduleWithFixedDelay(command, interval, executor);
            }

            public void shutdown() {
                throw new UnsupportedOperationException();
            }

            public void shutdownNow() {
                throw new UnsupportedOperationException();
            }

            public boolean awaitTermination(long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }

            public ScheduledExecutorService scheduler() {
                return new ScheduledExecutorService(){

                    @Override
                    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void shutdown() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isShutdown() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isTerminated() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean awaitTermination(long timeout, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> Future<T> submit(Callable<T> task) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> Future<T> submit(Runnable task, T result) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Future<?> submit(Runnable task) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void execute(Runnable command) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public long getLatestDeferredExecutionTime() {
        return this.latestDeferredExecutionTime;
    }

    public static String getNodeIdForLogContext(DiscoveryNode node) {
        return "{" + node.getId() + "}{" + node.getEphemeralId() + "}";
    }

    public static Runnable onNodeLog(DiscoveryNode node, final Runnable runnable) {
        final String nodeId = DeterministicTaskQueue.getNodeIdForLogContext(node);
        return new Runnable(){

            @Override
            public void run() {
                try (CloseableThreadContext.Instance ignored = DeterministicTaskQueue.getLogContext(nodeId);){
                    runnable.run();
                }
            }

            public String toString() {
                return nodeId + ": " + runnable.toString();
            }
        };
    }

    public static CloseableThreadContext.Instance getLogContext(String value) {
        return CloseableThreadContext.put((String)NODE_ID_LOG_CONTEXT_KEY, (String)value);
    }

    private static class DeferredTask {
        private final long executionTimeMillis;
        private final Runnable task;

        DeferredTask(long executionTimeMillis, Runnable task) {
            this.executionTimeMillis = executionTimeMillis;
            this.task = task;
            assert (executionTimeMillis < Long.MAX_VALUE) : "Long.MAX_VALUE is special, cannot be an execution time";
        }

        long getExecutionTimeMillis() {
            return this.executionTimeMillis;
        }

        Runnable getTask() {
            return this.task;
        }

        public String toString() {
            return "DeferredTask{executionTimeMillis=" + this.executionTimeMillis + ", task=" + this.task + '}';
        }
    }
}

