/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.index.query.IntervalFilterScript;
import org.elasticsearch.index.similarity.ScriptedSimilarity;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.BucketAggregationScript;
import org.elasticsearch.script.BucketAggregationSelectorScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.MockDeterministicScript;
import org.elasticsearch.script.NumberSortScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.script.SignificantTermsHeuristicScoreScript;
import org.elasticsearch.script.SimilarityScript;
import org.elasticsearch.script.SimilarityWeightScript;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.script.StringSortScript;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.TermsSetQueryScript;
import org.elasticsearch.script.UpdateScript;
import org.elasticsearch.search.aggregations.pipeline.MovingFunctionScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class MockScriptEngine
implements ScriptEngine {
    public static final String NAME = "mockscript";
    private final String type;
    private final Map<String, MockDeterministicScript> scripts;
    private final Map<ScriptContext<?>, ContextCompiler> contexts;

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> scripts, Map<ScriptContext<?>, ContextCompiler> contexts) {
        this(type, scripts, Collections.emptyMap(), contexts);
    }

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> deterministicScripts, Map<String, Function<Map<String, Object>, Object>> nonDeterministicScripts, Map<ScriptContext<?>, ContextCompiler> contexts) {
        HashMap scriptMap = new HashMap(deterministicScripts.size() + nonDeterministicScripts.size());
        deterministicScripts.forEach((key, value) -> scriptMap.put(key, MockDeterministicScript.asDeterministic(value)));
        nonDeterministicScripts.forEach((key, value) -> scriptMap.put(key, MockDeterministicScript.asNonDeterministic(value)));
        this.type = type;
        this.scripts = Collections.unmodifiableMap(scriptMap);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public MockScriptEngine() {
        this(NAME, Collections.emptyMap(), Collections.emptyMap());
    }

    public String getType() {
        return this.type;
    }

    public <T> T compile(String name, String source, ScriptContext<T> context, Map<String, String> params) {
        final MockDeterministicScript script = this.scripts.get(source);
        if (script == null) {
            throw new IllegalArgumentException("No pre defined script matching [" + source + "] for script with name [" + name + "], did you declare the mocked script?");
        }
        MockCompiledScript mockCompiled = new MockCompiledScript(name, params, source, script);
        if (context.instanceClazz.equals(FieldScript.class)) {
            return context.factoryClazz.cast(new MockFieldScriptFactory(script));
        }
        if (context.instanceClazz.equals(TermsSetQueryScript.class)) {
            TermsSetQueryScript.Factory factory = (parameters, lookup) -> ctx -> new TermsSetQueryScript(parameters, lookup, ctx){

                public Number execute() {
                    HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                    vars.put("params", parameters);
                    vars.put("doc", this.getDoc());
                    return (Number)script.apply((Map<String, Object>)vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(NumberSortScript.class)) {
            NumberSortScript.Factory factory = (parameters, lookup) -> new NumberSortScript.LeafFactory(){

                public NumberSortScript newInstance(DocReader reader) {
                    return new NumberSortScript(parameters, lookup, reader){

                        public double execute() {
                            HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                            vars.put("params", parameters);
                            vars.put("doc", this.getDoc());
                            return ((Number)script.apply((Map<String, Object>)vars)).doubleValue();
                        }
                    };
                }

                public boolean needs_score() {
                    return false;
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(StringSortScript.class)) {
            return context.factoryClazz.cast(new MockStringSortScriptFactory(script));
        }
        if (context.instanceClazz.equals(IngestScript.class)) {
            IngestScript.Factory factory = vars -> new IngestScript(vars){

                public void execute(Map<String, Object> ctx) {
                    script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(AggregationScript.class)) {
            return context.factoryClazz.cast(new MockAggregationScript(script));
        }
        if (context.instanceClazz.equals(IngestConditionalScript.class)) {
            IngestConditionalScript.Factory factory = parameters -> new IngestConditionalScript(parameters){

                public boolean execute(Map<String, Object> ctx) {
                    return (Boolean)script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(UpdateScript.class)) {
            UpdateScript.Factory factory = (parameters, ctx) -> new UpdateScript(parameters, ctx){

                public void execute() {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("ctx", ctx);
                    vars.put("params", parameters);
                    vars.putAll(parameters);
                    script.apply((Map<String, Object>)vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationScript.class)) {
            BucketAggregationScript.Factory factory = parameters -> new BucketAggregationScript(parameters){

                public Double execute() {
                    Object ret = script.apply(this.getParams());
                    if (ret == null) {
                        return null;
                    }
                    return ((Number)ret).doubleValue();
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationSelectorScript.class)) {
            BucketAggregationSelectorScript.Factory factory = parameters -> new BucketAggregationSelectorScript(parameters){

                public boolean execute() {
                    return (Boolean)script.apply(this.getParams());
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SignificantTermsHeuristicScoreScript.class)) {
            return context.factoryClazz.cast(new MockSignificantTermsHeuristicScoreScript(script));
        }
        if (context.instanceClazz.equals(TemplateScript.class)) {
            TemplateScript.Factory factory = vars -> {
                final HashMap<String, Map> varsWithParams = new HashMap<String, Map>();
                if (vars != null) {
                    varsWithParams.put("params", vars);
                }
                return new TemplateScript(vars){

                    public String execute() {
                        return (String)script.apply(varsWithParams);
                    }
                };
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(FilterScript.class)) {
            FilterScript.Factory factory = mockCompiled::createFilterScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityScript.class)) {
            SimilarityScript.Factory factory = mockCompiled::createSimilarityScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityWeightScript.class)) {
            SimilarityWeightScript.Factory factory = mockCompiled::createSimilarityWeightScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(MovingFunctionScript.class)) {
            MovingFunctionScript.Factory factory = () -> new MovingFunctionScript(){

                public double execute(Map<String, Object> params1, double[] values) {
                    params1.put("_values", values);
                    return (Double)script.apply(params1);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScoreScript.class)) {
            MockScoreScript factory = new MockScoreScript(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.InitScript.class)) {
            MockMetricAggInitScriptFactory factory = new MockMetricAggInitScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.MapScript.class)) {
            MockMetricAggMapScriptFactory factory = new MockMetricAggMapScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.CombineScript.class)) {
            MockMetricAggCombineScriptFactory factory = new MockMetricAggCombineScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.ReduceScript.class)) {
            MockMetricAggReduceScriptFactory factory = new MockMetricAggReduceScriptFactory(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(IntervalFilterScript.class)) {
            IntervalFilterScript.Factory factory = mockCompiled::createIntervalFilterScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BooleanFieldScript.class)) {
            BooleanFieldScript.Factory booleanFieldScript = (f, p, s) -> ctx -> new BooleanFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit(true);
                }
            };
            return context.factoryClazz.cast(booleanFieldScript);
        }
        if (context.instanceClazz.equals(StringFieldScript.class)) {
            StringFieldScript.Factory stringFieldScript = (f, p, s) -> ctx -> new StringFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit("test");
                }
            };
            return context.factoryClazz.cast(stringFieldScript);
        }
        if (context.instanceClazz.equals(LongFieldScript.class)) {
            LongFieldScript.Factory longFieldScript = (f, p, s) -> ctx -> new LongFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit(1L);
                }
            };
            return context.factoryClazz.cast(longFieldScript);
        }
        if (context.instanceClazz.equals(DoubleFieldScript.class)) {
            DoubleFieldScript.Factory doubleFieldScript = (f, p, s) -> ctx -> new DoubleFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit(1.2);
                }
            };
            return context.factoryClazz.cast(doubleFieldScript);
        }
        if (context.instanceClazz.equals(DateFieldScript.class)) {
            DateFieldScript.Factory dateFieldScript = (f, p, s, formatter) -> ctx -> new DateFieldScript(f, p, s, formatter, ctx){

                public void execute() {
                    this.emit(123L);
                }
            };
            return context.factoryClazz.cast(dateFieldScript);
        }
        if (context.instanceClazz.equals(IpFieldScript.class)) {
            IpFieldScript.Factory ipFieldScript = (f, p, s) -> ctx -> new IpFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit("127.0.0.1");
                }
            };
            return context.factoryClazz.cast(ipFieldScript);
        }
        if (context.instanceClazz.equals(GeoPointFieldScript.class)) {
            GeoPointFieldScript.Factory geoPointFieldScript = (f, p, s) -> ctx -> new GeoPointFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit(1.2, 1.2);
                }
            };
            return context.factoryClazz.cast(geoPointFieldScript);
        }
        if (context.instanceClazz.equals(CompositeFieldScript.class)) {
            CompositeFieldScript.Factory objectFieldScript = (f, p, s) -> ctx -> new CompositeFieldScript(f, p, s, ctx){

                public void execute() {
                    this.emit("field1", "value1");
                    this.emit("field2", "value2");
                }
            };
            return context.factoryClazz.cast(objectFieldScript);
        }
        ContextCompiler compiler = this.contexts.get(context);
        if (compiler != null) {
            return context.factoryClazz.cast(compiler.compile(script::apply, params));
        }
        throw new IllegalArgumentException("mock script engine does not know how to handle context [" + context.name + "]");
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Stream.of(FieldScript.CONTEXT, TermsSetQueryScript.CONTEXT, NumberSortScript.CONTEXT, StringSortScript.CONTEXT, IngestScript.CONTEXT, AggregationScript.CONTEXT, IngestConditionalScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, TemplateScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, MovingFunctionScript.CONTEXT, ScoreScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT, IntervalFilterScript.CONTEXT).collect(Collectors.toSet());
    }

    private Map<String, Object> createVars(Map<String, Object> params) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("params", params);
        return vars;
    }

    public static Script mockInlineScript(String script) {
        return new Script(ScriptType.INLINE, "mock", script, Collections.emptyMap());
    }

    public class MockCompiledScript {
        private final String name;
        private final String source;
        private final Map<String, String> options;
        private final Function<Map<String, Object>, Object> script;

        public MockCompiledScript(String name, Map<String, String> options, String source, Function<Map<String, Object>, Object> script) {
            this.name = name;
            this.source = source;
            this.options = options;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public FilterScript.LeafFactory createFilterScript(Map<String, Object> params, SearchLookup lookup) {
            return new MockFilterScript(lookup, params, this.script);
        }

        public SimilarityScript createSimilarityScript() {
            return new MockSimilarityScript(this.script != null ? this.script : ctx -> 42.0);
        }

        public SimilarityWeightScript createSimilarityWeightScript() {
            return new MockSimilarityWeightScript(this.script != null ? this.script : ctx -> 42.0);
        }

        public IntervalFilterScript createIntervalFilterScript() {
            return new IntervalFilterScript(){

                public boolean execute(IntervalFilterScript.Interval interval) {
                    return false;
                }
            };
        }
    }

    class MockFieldScriptFactory
    implements FieldScript.Factory {
        private final MockDeterministicScript script;

        MockFieldScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public FieldScript.LeafFactory newFactory(final Map<String, Object> parameters, SearchLookup lookup) {
            return ctx -> new FieldScript(parameters, lookup, ctx){

                public Object execute() {
                    Map vars = MockScriptEngine.this.createVars(parameters);
                    vars.putAll(this.docAsMap());
                    return MockFieldScriptFactory.this.script.apply(vars);
                }
            };
        }
    }

    class MockStringSortScriptFactory
    implements StringSortScript.Factory {
        private final MockDeterministicScript script;

        MockStringSortScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public StringSortScript.LeafFactory newFactory(final Map<String, Object> parameters) {
            return docReader -> new StringSortScript(parameters, docReader){

                public String execute() {
                    HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                    vars.put("params", parameters);
                    vars.put("doc", this.getDoc());
                    return String.valueOf(MockStringSortScriptFactory.this.script.apply((Map<String, Object>)vars));
                }
            };
        }
    }

    class MockAggregationScript
    implements AggregationScript.Factory {
        private final MockDeterministicScript script;

        MockAggregationScript(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public AggregationScript.LeafFactory newFactory(final Map<String, Object> params, final SearchLookup lookup) {
            return new AggregationScript.LeafFactory(){

                public AggregationScript newInstance(LeafReaderContext ctx) {
                    return new AggregationScript(params, lookup, ctx){

                        public Object execute() {
                            HashMap<String, Object> vars = new HashMap<String, Object>(params);
                            vars.put("params", params);
                            vars.put("doc", this.getDoc());
                            vars.put("_score", this.get_score());
                            vars.put("_value", this.get_value());
                            return MockAggregationScript.this.script.apply((Map<String, Object>)vars);
                        }
                    };
                }

                public boolean needs_score() {
                    return true;
                }
            };
        }
    }

    class MockSignificantTermsHeuristicScoreScript
    implements SignificantTermsHeuristicScoreScript.Factory {
        private final MockDeterministicScript script;

        MockSignificantTermsHeuristicScoreScript(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public SignificantTermsHeuristicScoreScript newInstance() {
            return new SignificantTermsHeuristicScoreScript(){

                public double execute(Map<String, Object> vars) {
                    return ((Number)MockSignificantTermsHeuristicScoreScript.this.script.apply(vars)).doubleValue();
                }
            };
        }
    }

    public class MockScoreScript
    implements ScoreScript.Factory {
        private final MockDeterministicScript script;

        public MockScoreScript(MockDeterministicScript script) {
            this.script = script;
        }

        public ScoreScript.LeafFactory newFactory(final Map<String, Object> params, SearchLookup lookup) {
            return new ScoreScript.LeafFactory(){

                public boolean needs_score() {
                    return true;
                }

                public ScoreScript newInstance(DocReader docReader) throws IOException {
                    final Scorable[] scorerHolder = new Scorable[1];
                    return new ScoreScript(params, null, docReader){

                        public double execute(ScoreScript.ExplanationHolder explanation) {
                            HashMap<String, Object> vars = new HashMap<String, Object>(this.getParams());
                            vars.put("doc", this.getDoc());
                            if (scorerHolder[0] != null) {
                                vars.put("_score", new ScoreAccessor(scorerHolder[0]));
                            }
                            return ((Number)MockScoreScript.this.script.apply((Map<String, Object>)vars)).doubleValue();
                        }

                        public void setScorer(Scorable scorer) {
                            scorerHolder[0] = scorer;
                        }
                    };
                }
            };
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }
    }

    public static class MockMetricAggInitScriptFactory
    implements ScriptedMetricAggContexts.InitScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggInitScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.InitScript newInstance(Map<String, Object> params, Map<String, Object> state) {
            return new MockMetricAggInitScript(params, state, this.script);
        }
    }

    public static class MockMetricAggMapScriptFactory
    implements ScriptedMetricAggContexts.MapScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggMapScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.MapScript.LeafFactory newFactory(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup) {
            return new MockMetricAggMapScript(params, state, lookup, this.script);
        }
    }

    public static class MockMetricAggCombineScriptFactory
    implements ScriptedMetricAggContexts.CombineScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggCombineScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.CombineScript newInstance(Map<String, Object> params, Map<String, Object> state) {
            return new MockMetricAggCombineScript(params, state, this.script);
        }
    }

    public static class MockMetricAggReduceScriptFactory
    implements ScriptedMetricAggContexts.ReduceScript.Factory {
        private final MockDeterministicScript script;

        MockMetricAggReduceScriptFactory(MockDeterministicScript script) {
            this.script = script;
        }

        public boolean isResultDeterministic() {
            return this.script.isResultDeterministic();
        }

        public ScriptedMetricAggContexts.ReduceScript newInstance(Map<String, Object> params, List<Object> states) {
            return new MockMetricAggReduceScript(params, states, this.script);
        }
    }

    public static interface ContextCompiler {
        public Object compile(Function<Map<String, Object>, Object> var1, Map<String, String> var2);
    }

    public static class MockMetricAggReduceScript
    extends ScriptedMetricAggContexts.ReduceScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggReduceScript(Map<String, Object> params, List<Object> states, Function<Map<String, Object>, Object> script) {
            super(params, states);
            this.script = script;
        }

        public Object execute() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("states", this.getStates());
            return this.script.apply(map);
        }
    }

    public static class MockMetricAggCombineScript
    extends ScriptedMetricAggContexts.CombineScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggCombineScript(Map<String, Object> params, Map<String, Object> state, Function<Map<String, Object>, Object> script) {
            super(params, state);
            this.script = script;
        }

        public Object execute() {
            HashMap<String, Map> map = new HashMap<String, Map>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("state", this.getState());
            return this.script.apply(map);
        }
    }

    public static class MockMetricAggMapScript
    implements ScriptedMetricAggContexts.MapScript.LeafFactory {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        private final SearchLookup lookup;
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggMapScript(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup, Function<Map<String, Object>, Object> script) {
            this.params = params;
            this.state = state;
            this.lookup = lookup;
            this.script = script;
        }

        public ScriptedMetricAggContexts.MapScript newInstance(LeafReaderContext context) {
            return new ScriptedMetricAggContexts.MapScript(this.params, this.state, this.lookup, context){

                public void execute() {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (this.getParams() != null) {
                        map.putAll(this.getParams());
                        map.put("params", this.getParams());
                    }
                    map.put("state", this.getState());
                    map.put("doc", this.getDoc());
                    map.put("_score", this.get_score());
                    script.apply(map);
                }
            };
        }
    }

    public static class MockMetricAggInitScript
    extends ScriptedMetricAggContexts.InitScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggInitScript(Map<String, Object> params, Map<String, Object> state, Function<Map<String, Object>, Object> script) {
            super(params, state);
            this.script = script;
        }

        public void execute() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("state", this.getState());
            this.script.apply(map);
        }
    }

    public class MockSimilarityWeightScript
    extends SimilarityWeightScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityWeightScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("query", query);
            map.put("field", field);
            map.put("term", term);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public class MockSimilarityScript
    extends SimilarityScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(double weight, ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term, ScriptedSimilarity.Doc doc) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("weight", weight);
            map.put("query", (Double)query);
            map.put("field", (Double)field);
            map.put("term", (Double)term);
            map.put("doc", (Double)doc);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public static class MockFilterScript
    implements FilterScript.LeafFactory {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;
        private final SearchLookup lookup;

        public MockFilterScript(SearchLookup lookup, Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.lookup = lookup;
            this.vars = vars;
            this.script = script;
        }

        public FilterScript newInstance(DocReader docReader) throws IOException {
            final HashMap<String, Object> ctx = new HashMap<String, Object>(docReader.docAsMap());
            if (this.vars != null) {
                ctx.putAll(this.vars);
            }
            return new FilterScript(ctx, this.lookup, docReader){

                public boolean execute() {
                    return (Boolean)script.apply(ctx);
                }

                public void setDocument(int doc) {
                    this.docReader.setDocument(doc);
                }
            };
        }
    }
}

