/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.mockito.Mockito;

public class HighlighterTestCase
extends MapperServiceTestCase {
    protected Map<String, Highlighter> getHighlighters() {
        HashMap<String, Highlighter> highlighters = new HashMap<String, Highlighter>();
        highlighters.put("unified", (Highlighter)new UnifiedHighlighter());
        highlighters.put("fvh", (Highlighter)new FastVectorHighlighter(this.getIndexSettings()));
        highlighters.put("plain", (Highlighter)new PlainHighlighter());
        return highlighters;
    }

    protected final Map<String, HighlightField> highlight(MapperService mapperService, ParsedDocument doc, SearchSourceBuilder search) throws IOException {
        HashMap<String, HighlightField> highlights = new HashMap<String, HighlightField>();
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)ir -> {
            SearchExecutionContext context = this.createSearchExecutionContext(mapperService, new IndexSearcher(ir));
            HighlightPhase highlightPhase = new HighlightPhase(this.getHighlighters());
            FetchSubPhaseProcessor processor = highlightPhase.getProcessor(HighlighterTestCase.fetchContext(context, search));
            FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(new SearchHit(0, "id", new Text("_doc"), null, null), (LeafReaderContext)ir.leaves().get(0), 0);
            processor.process(hitContext);
            highlights.putAll(hitContext.hit().getHighlightFields());
        }));
        return highlights;
    }

    protected static void assertHighlights(Map<String, HighlightField> highlights, String field, String ... fragments) {
        HighlighterTestCase.assertNotNull((String)("No highlights reported for field [" + field + "]"), (Object)highlights.get(field));
        Set actualFragments = Arrays.stream(highlights.get(field).getFragments()).map(Text::toString).collect(Collectors.toSet());
        HashSet<String> expectedFragments = new HashSet<String>(Arrays.asList(fragments));
        HighlighterTestCase.assertEquals(expectedFragments, actualFragments);
    }

    private static FetchContext fetchContext(SearchExecutionContext context, SearchSourceBuilder search) throws IOException {
        FetchContext fetchContext = (FetchContext)Mockito.mock(FetchContext.class);
        Mockito.when((Object)fetchContext.highlight()).thenReturn((Object)search.highlighter().build(context));
        Mockito.when((Object)fetchContext.parsedQuery()).thenReturn((Object)new ParsedQuery(search.query().toQuery(context)));
        Mockito.when((Object)fetchContext.getSearchExecutionContext()).thenReturn((Object)context);
        return fetchContext;
    }
}

